/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.impl.identity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jws.WebParam;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.criteria.QueryResults;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.core.api.exception.RiceIllegalStateException;
import org.kuali.rice.kim.api.identity.CodedAttribute;
import org.kuali.rice.kim.api.identity.IdentityService;
import org.kuali.rice.kim.api.identity.address.EntityAddress;
import org.kuali.rice.kim.api.identity.affiliation.EntityAffiliation;
import org.kuali.rice.kim.api.identity.affiliation.EntityAffiliationType;
import org.kuali.rice.kim.api.identity.citizenship.EntityCitizenship;
import org.kuali.rice.kim.api.identity.email.EntityEmail;
import org.kuali.rice.kim.api.identity.employment.EntityEmployment;
import org.kuali.rice.kim.api.identity.entity.Entity;
import org.kuali.rice.kim.api.identity.entity.EntityContract;
import org.kuali.rice.kim.api.identity.entity.EntityDefault;
import org.kuali.rice.kim.api.identity.entity.EntityDefaultQueryResults;
import org.kuali.rice.kim.api.identity.entity.EntityQueryResults;
import org.kuali.rice.kim.api.identity.external.EntityExternalIdentifier;
import org.kuali.rice.kim.api.identity.external.EntityExternalIdentifierType;
import org.kuali.rice.kim.api.identity.name.EntityName;
import org.kuali.rice.kim.api.identity.name.EntityNameContract;
import org.kuali.rice.kim.api.identity.name.EntityNameQueryResults;
import org.kuali.rice.kim.api.identity.personal.EntityBioDemographics;
import org.kuali.rice.kim.api.identity.personal.EntityEthnicity;
import org.kuali.rice.kim.api.identity.phone.EntityPhone;
import org.kuali.rice.kim.api.identity.principal.EntityNamePrincipalName;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.identity.principal.PrincipalContract;
import org.kuali.rice.kim.api.identity.principal.PrincipalQueryResults;
import org.kuali.rice.kim.api.identity.privacy.EntityPrivacyPreferences;
import org.kuali.rice.kim.api.identity.residency.EntityResidency;
import org.kuali.rice.kim.api.identity.type.EntityTypeContactInfo;
import org.kuali.rice.kim.api.identity.visa.EntityVisa;
import org.kuali.rice.kim.impl.identity.EntityTypeBo;
import org.kuali.rice.kim.impl.identity.IdentityServiceDao;
import org.kuali.rice.kim.impl.identity.address.EntityAddressBo;
import org.kuali.rice.kim.impl.identity.address.EntityAddressTypeBo;
import org.kuali.rice.kim.impl.identity.affiliation.EntityAffiliationBo;
import org.kuali.rice.kim.impl.identity.affiliation.EntityAffiliationTypeBo;
import org.kuali.rice.kim.impl.identity.citizenship.EntityCitizenshipBo;
import org.kuali.rice.kim.impl.identity.citizenship.EntityCitizenshipStatusBo;
import org.kuali.rice.kim.impl.identity.email.EntityEmailBo;
import org.kuali.rice.kim.impl.identity.email.EntityEmailTypeBo;
import org.kuali.rice.kim.impl.identity.employment.EntityEmploymentBo;
import org.kuali.rice.kim.impl.identity.employment.EntityEmploymentStatusBo;
import org.kuali.rice.kim.impl.identity.employment.EntityEmploymentTypeBo;
import org.kuali.rice.kim.impl.identity.entity.EntityBo;
import org.kuali.rice.kim.impl.identity.external.EntityExternalIdentifierBo;
import org.kuali.rice.kim.impl.identity.external.EntityExternalIdentifierTypeBo;
import org.kuali.rice.kim.impl.identity.name.EntityNameBo;
import org.kuali.rice.kim.impl.identity.name.EntityNameTypeBo;
import org.kuali.rice.kim.impl.identity.personal.EntityBioDemographicsBo;
import org.kuali.rice.kim.impl.identity.personal.EntityEthnicityBo;
import org.kuali.rice.kim.impl.identity.phone.EntityPhoneBo;
import org.kuali.rice.kim.impl.identity.phone.EntityPhoneTypeBo;
import org.kuali.rice.kim.impl.identity.principal.PrincipalBo;
import org.kuali.rice.kim.impl.identity.privacy.EntityPrivacyPreferencesBo;
import org.kuali.rice.kim.impl.identity.residency.EntityResidencyBo;
import org.kuali.rice.kim.impl.identity.type.EntityTypeContactInfoBo;
import org.kuali.rice.kim.impl.identity.visa.EntityVisaBo;
import org.kuali.rice.kim.impl.services.KimImplServiceLocator;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.PersistenceOption;

public class IdentityServiceImpl
implements IdentityService {
    protected static final String UNAVAILABLE = "Unavailable";
    protected DataObjectService dataObjectService;
    protected IdentityServiceDao identityServiceDao;

    public Entity getEntity(String entityId) throws RiceIllegalArgumentException {
        this.incomingParamCheck(entityId, "entityId");
        EntityBo entity = this.getEntityBo(entityId);
        if (entity == null) {
            return null;
        }
        return EntityBo.to(entity);
    }

    public Entity getEntityByPrincipalId(String principalId) throws RiceIllegalArgumentException {
        this.incomingParamCheck(principalId, "principalId");
        EntityBo entity = this.getEntityBoByPrincipalId(principalId);
        if (entity == null) {
            return null;
        }
        return EntityBo.to(entity);
    }

    public Entity getEntityByPrincipalName(String principalName) throws RiceIllegalArgumentException {
        this.incomingParamCheck(principalName, "principalName");
        EntityBo entity = this.getEntityBoByPrincipalName(principalName);
        if (entity == null) {
            return null;
        }
        return EntityBo.to(entity);
    }

    public Entity getEntityByEmployeeId(String employeeId) throws RiceIllegalArgumentException {
        this.incomingParamCheck(employeeId, "employeeId");
        EntityBo entity = this.getEntityBoByEmployeeId(employeeId);
        if (entity == null) {
            return null;
        }
        return EntityBo.to(entity);
    }

    public EntityDefault getEntityDefault(String entityId) throws RiceIllegalArgumentException {
        this.incomingParamCheck(entityId, "entityId");
        EntityBo entity = this.getEntityBo(entityId);
        if (entity == null) {
            return null;
        }
        return EntityBo.toDefault(entity);
    }

    public EntityDefault getEntityDefaultByPrincipalId(String principalId) throws RiceIllegalArgumentException {
        this.incomingParamCheck(principalId, "principalId");
        EntityBo entity = this.getEntityBoByPrincipalId(principalId);
        if (entity == null) {
            return null;
        }
        return EntityBo.toDefault(entity);
    }

    public EntityDefault getEntityDefaultByPrincipalName(String principalName) throws RiceIllegalArgumentException {
        this.incomingParamCheck(principalName, "principalName");
        EntityBo entity = this.getEntityBoByPrincipalName(principalName);
        if (entity == null) {
            return null;
        }
        return EntityBo.toDefault(entity);
    }

    public EntityDefault getEntityDefaultByEmployeeId(String employeeId) throws RiceIllegalArgumentException {
        this.incomingParamCheck(employeeId, "employeeId");
        EntityBo entity = this.getEntityBoByEmployeeId(employeeId);
        if (entity == null) {
            return null;
        }
        return EntityBo.toDefault(entity);
    }

    public Principal getPrincipalByPrincipalNameAndPassword(String principalName, String password) throws RiceIllegalArgumentException {
        this.incomingParamCheck(principalName, "principalName");
        this.incomingParamCheck(password, "password");
        HashMap<String, Object> criteria = new HashMap<String, Object>(3);
        criteria.put("principalName", principalName);
        criteria.put("password", password);
        criteria.put("active", Boolean.TRUE);
        QueryResults principals = this.dataObjectService.findMatching(PrincipalBo.class, QueryByCriteria.Builder.andAttributes(criteria).build());
        if (!principals.getResults().isEmpty()) {
            return PrincipalBo.to((PrincipalBo)((Object)principals.getResults().get(0)));
        }
        return null;
    }

    public Principal addPrincipalToEntity(Principal principal) throws RiceIllegalArgumentException, RiceIllegalStateException {
        this.incomingParamCheck(principal, "principal");
        if (StringUtils.isBlank((String)principal.getEntityId()) || StringUtils.isBlank((String)principal.getPrincipalName())) {
            throw new RiceIllegalStateException("Principal's entityId and PrincipalName must be populated before creation");
        }
        if (this.getPrincipalByPrincipalName(principal.getPrincipalName()) != null) {
            throw new RiceIllegalStateException("the Principal to create already exists: " + String.valueOf(principal));
        }
        PrincipalBo bo = PrincipalBo.from(principal);
        return PrincipalBo.to((PrincipalBo)((Object)this.dataObjectService.save((Object)bo, new PersistenceOption[0])));
    }

    public Principal updatePrincipal(Principal principal) throws RiceIllegalArgumentException, RiceIllegalStateException {
        this.incomingParamCheck(principal, "principal");
        PrincipalBo originalPrincipal = null;
        if (StringUtils.isBlank((String)principal.getEntityId()) || StringUtils.isBlank((String)principal.getPrincipalName())) {
            throw new RiceIllegalStateException("Principal's entityId and PrincipalName must be populated before update");
        }
        originalPrincipal = this.getPrincipalBo(principal.getPrincipalId());
        if (StringUtils.isBlank((String)principal.getPrincipalId()) || originalPrincipal == null) {
            throw new RiceIllegalStateException("the Principal to update does not exist: " + String.valueOf(principal));
        }
        PrincipalBo bo = PrincipalBo.from(principal);
        bo.setPassword(originalPrincipal.getPassword());
        PrincipalBo updatedPrincipal = (PrincipalBo)((Object)this.dataObjectService.save((Object)bo, new PersistenceOption[0]));
        if (originalPrincipal.isActive() && !updatedPrincipal.isActive()) {
            KimImplServiceLocator.getRoleInternalService().principalInactivated(updatedPrincipal.getPrincipalId());
        }
        return PrincipalBo.to(updatedPrincipal);
    }

    public Principal inactivatePrincipal(String principalId) throws RiceIllegalArgumentException, RiceIllegalStateException {
        this.incomingParamCheck(principalId, "principalId");
        Principal principal = this.getPrincipal(principalId);
        if (principal == null) {
            throw new RiceIllegalStateException("Principal with principalId: " + principalId + " does not exist");
        }
        PrincipalBo bo = PrincipalBo.from(principal);
        bo.setActive(false);
        return PrincipalBo.to((PrincipalBo)((Object)this.dataObjectService.save((Object)bo, new PersistenceOption[0])));
    }

    public Principal inactivatePrincipalByName(String principalName) throws RiceIllegalArgumentException, RiceIllegalStateException {
        this.incomingParamCheck(principalName, "principalName");
        Principal principal = this.getPrincipalByPrincipalName(principalName);
        if (principal == null) {
            throw new RiceIllegalStateException("Principal with principalName: " + principalName + " does not exist");
        }
        PrincipalBo bo = PrincipalBo.from(principal);
        bo.setActive(false);
        return PrincipalBo.to((PrincipalBo)((Object)this.dataObjectService.save((Object)bo, new PersistenceOption[0])));
    }

    public EntityTypeContactInfo addEntityTypeContactInfoToEntity(EntityTypeContactInfo entityTypeData) throws RiceIllegalArgumentException, RiceIllegalStateException {
        this.incomingParamCheck(entityTypeData, "entityTypeData");
        if (StringUtils.isBlank((String)entityTypeData.getEntityId()) || StringUtils.isBlank((String)entityTypeData.getEntityTypeCode())) {
            throw new RiceIllegalStateException("EntityTypeData's entityId and entityTypeCode must be populated before creation");
        }
        if (this.getEntityTypeDataBo(entityTypeData.getEntityId(), entityTypeData.getEntityTypeCode()) != null) {
            throw new RiceIllegalStateException("the entityTypeData to create already exists: " + String.valueOf(entityTypeData));
        }
        EntityTypeContactInfoBo bo = EntityTypeContactInfoBo.from(entityTypeData);
        return EntityTypeContactInfoBo.to((EntityTypeContactInfoBo)((Object)this.dataObjectService.save((Object)bo, new PersistenceOption[0])));
    }

    protected EntityTypeContactInfoBo getEntityTypeDataBo(String entityId, String entityTypeCode) {
        HashMap<String, Object> criteria = new HashMap<String, Object>(3);
        criteria.put("entityId", entityId);
        criteria.put("entityTypeCode", entityTypeCode);
        criteria.put("active", Boolean.TRUE);
        List results = this.dataObjectService.findMatching(EntityTypeContactInfoBo.class, QueryByCriteria.Builder.andAttributes(criteria).build()).getResults();
        if (results.isEmpty()) {
            return null;
        }
        return (EntityTypeContactInfoBo)((Object)results.get(0));
    }

    public EntityTypeContactInfo updateEntityTypeContactInfo(EntityTypeContactInfo entityTypeContactInfo) throws RiceIllegalArgumentException, RiceIllegalStateException {
        this.incomingParamCheck(entityTypeContactInfo, "entityTypeContactInfo");
        if (StringUtils.isBlank((String)entityTypeContactInfo.getEntityId()) || StringUtils.isBlank((String)entityTypeContactInfo.getEntityTypeCode())) {
            throw new RiceIllegalStateException("EntityTypeData's entityId and entityTypeCode must be populated before update");
        }
        if (this.getEntityTypeDataBo(entityTypeContactInfo.getEntityId(), entityTypeContactInfo.getEntityTypeCode()) == null) {
            throw new RiceIllegalStateException("the entityTypeData to update does not exist: " + String.valueOf(entityTypeContactInfo));
        }
        EntityTypeContactInfoBo bo = EntityTypeContactInfoBo.from(entityTypeContactInfo);
        return EntityTypeContactInfoBo.to((EntityTypeContactInfoBo)((Object)this.dataObjectService.save((Object)bo, new PersistenceOption[0])));
    }

    public EntityTypeContactInfo inactivateEntityTypeContactInfo(String entityId, String entityTypeCode) throws RiceIllegalArgumentException, RiceIllegalStateException {
        this.incomingParamCheck(entityId, "entityId");
        this.incomingParamCheck(entityTypeCode, "entityTypeCode");
        EntityTypeContactInfoBo bo = this.getEntityTypeDataBo(entityId, entityTypeCode);
        if (bo == null) {
            throw new RiceIllegalStateException("EntityTypeData with entityId: " + entityId + " entityTypeCode: " + entityTypeCode + " does not exist");
        }
        bo.setActive(false);
        return EntityTypeContactInfoBo.to((EntityTypeContactInfoBo)((Object)this.dataObjectService.save((Object)bo, new PersistenceOption[0])));
    }

    protected EntityAddressBo getEntityAddressBo(String entityId, String entityTypeCode, String addressTypeCode) {
        HashMap<String, Object> criteria = new HashMap<String, Object>(4);
        criteria.put("entityId", entityId);
        criteria.put("entityTypeCode", entityTypeCode);
        criteria.put("addressTypeCode", addressTypeCode);
        criteria.put("active", Boolean.TRUE);
        List results = this.dataObjectService.findMatching(EntityAddressBo.class, QueryByCriteria.Builder.andAttributes(criteria).build()).getResults();
        if (results.isEmpty()) {
            return null;
        }
        return (EntityAddressBo)((Object)results.get(0));
    }

    protected EntityAddressBo getEntityAddressBo(String addressId) {
        return (EntityAddressBo)((Object)this.dataObjectService.find(EntityAddressBo.class, (Object)addressId));
    }

    public EntityAddress addAddressToEntity(EntityAddress address) throws RiceIllegalArgumentException, RiceIllegalStateException {
        this.incomingParamCheck(address, "address");
        if (StringUtils.isBlank((String)address.getEntityId()) || StringUtils.isBlank((String)address.getEntityTypeCode())) {
            throw new RiceIllegalStateException("Address's entityId and entityTypeCode must be populated before creation");
        }
        if (address.getAddressType() == null) {
            throw new RiceIllegalStateException("Address's type must be populated before creation");
        }
        if (this.getEntityAddressBo(address.getEntityId(), address.getEntityTypeCode(), address.getAddressType().getCode()) != null) {
            throw new RiceIllegalStateException("the address to create already exists: " + String.valueOf(address));
        }
        EntityAddressBo bo = EntityAddressBo.from(address);
        return EntityAddressBo.to((EntityAddressBo)((Object)this.dataObjectService.save((Object)bo, new PersistenceOption[0])));
    }

    public EntityAddress updateAddress(EntityAddress address) throws RiceIllegalArgumentException, RiceIllegalStateException {
        this.incomingParamCheck(address, "address");
        if (StringUtils.isBlank((String)address.getEntityId()) || StringUtils.isBlank((String)address.getEntityTypeCode())) {
            throw new RiceIllegalStateException("Address's entityId and entityTypeCode must be populated before creation");
        }
        if (address.getAddressType() == null) {
            throw new RiceIllegalStateException("Address's type must be populated before creation");
        }
        if (StringUtils.isEmpty((String)address.getId()) || this.getEntityAddressBo(address.getEntityId(), address.getEntityTypeCode(), address.getAddressType().getCode()) == null) {
            throw new RiceIllegalStateException("the address to update does not exists: " + String.valueOf(address));
        }
        EntityAddressBo bo = EntityAddressBo.from(address);
        return EntityAddressBo.to((EntityAddressBo)((Object)this.dataObjectService.save((Object)bo, new PersistenceOption[0])));
    }

    public EntityAddress inactivateAddress(String addressId) throws RiceIllegalArgumentException, RiceIllegalStateException {
        this.incomingParamCheck(addressId, "addressId");
        EntityAddressBo bo = this.getEntityAddressBo(addressId);
        if (bo == null) {
            throw new RiceIllegalStateException("Address with addressId: " + addressId + " does not exist");
        }
        bo.setActive(false);
        return EntityAddressBo.to((EntityAddressBo)((Object)this.dataObjectService.save((Object)bo, new PersistenceOption[0])));
    }

    protected EntityEmailBo getEntityEmailBo(String entityId, String entityTypeCode, String emailTypeCode) {
        HashMap<String, Object> criteria = new HashMap<String, Object>(4);
        criteria.put("entityId", entityId);
        criteria.put("entityTypeCode", entityTypeCode);
        criteria.put("emailTypeCode", emailTypeCode);
        criteria.put("active", Boolean.TRUE);
        List results = this.dataObjectService.findMatching(EntityEmailBo.class, QueryByCriteria.Builder.andAttributes(criteria).build()).getResults();
        if (results.isEmpty()) {
            return null;
        }
        return (EntityEmailBo)((Object)results.get(0));
    }

    protected EntityEmailBo getEntityEmailBo(String emailId) {
        return (EntityEmailBo)((Object)this.dataObjectService.find(EntityEmailBo.class, (Object)emailId));
    }

    public EntityEmail addEmailToEntity(EntityEmail email) throws RiceIllegalArgumentException, RiceIllegalStateException {
        this.incomingParamCheck(email, "email");
        if (StringUtils.isBlank((String)email.getEntityId()) || StringUtils.isBlank((String)email.getEntityTypeCode())) {
            throw new RiceIllegalStateException("Email's entityId and entityTypeCode must be populated before creation");
        }
        if (email.getEmailType() == null) {
            throw new RiceIllegalStateException("Email's type must be populated before creation");
        }
        if (this.getEntityEmailBo(email.getEntityId(), email.getEntityTypeCode(), email.getEmailType().getCode()) != null) {
            throw new RiceIllegalStateException("the email to create already exists: " + String.valueOf(email));
        }
        EntityEmailBo bo = EntityEmailBo.from(email);
        return EntityEmailBo.to((EntityEmailBo)((Object)this.dataObjectService.save((Object)bo, new PersistenceOption[0])));
    }

    public EntityEmail updateEmail(EntityEmail email) throws RiceIllegalArgumentException, RiceIllegalStateException {
        this.incomingParamCheck(email, "email");
        if (StringUtils.isBlank((String)email.getEntityId()) || StringUtils.isBlank((String)email.getEntityTypeCode())) {
            throw new RiceIllegalStateException("Email's entityId and entityTypeCode must be populated before creation");
        }
        if (email.getEmailType() == null) {
            throw new RiceIllegalStateException("Email's type must be populated before creation");
        }
        if (StringUtils.isEmpty((String)email.getId()) || this.getEntityEmailBo(email.getEntityId(), email.getEntityTypeCode(), email.getEmailType().getCode()) == null) {
            throw new RiceIllegalStateException("the email to update does not exists: " + String.valueOf(email));
        }
        EntityEmailBo bo = EntityEmailBo.from(email);
        return EntityEmailBo.to((EntityEmailBo)((Object)this.dataObjectService.save((Object)bo, new PersistenceOption[0])));
    }

    public EntityEmail inactivateEmail(String emailId) throws RiceIllegalArgumentException, RiceIllegalStateException {
        this.incomingParamCheck(emailId, "emailId");
        EntityEmailBo bo = this.getEntityEmailBo(emailId);
        if (bo == null) {
            throw new RiceIllegalStateException("Email with emailId: " + emailId + " does not exist");
        }
        bo.setActive(false);
        return EntityEmailBo.to((EntityEmailBo)((Object)this.dataObjectService.save((Object)bo, new PersistenceOption[0])));
    }

    protected EntityPhoneBo getEntityPhoneBo(String entityId, String entityTypeCode, String phoneTypeCode) {
        HashMap<String, Object> criteria = new HashMap<String, Object>(4);
        criteria.put("entityId", entityId);
        criteria.put("entityTypeCode", entityTypeCode);
        criteria.put("phoneTypeCode", phoneTypeCode);
        criteria.put("active", Boolean.TRUE);
        List results = this.dataObjectService.findMatching(EntityPhoneBo.class, QueryByCriteria.Builder.andAttributes(criteria).build()).getResults();
        if (results.isEmpty()) {
            return null;
        }
        return (EntityPhoneBo)((Object)results.get(0));
    }

    protected EntityPhoneBo getEntityPhoneBo(String phoneId) {
        return (EntityPhoneBo)((Object)this.dataObjectService.find(EntityPhoneBo.class, (Object)phoneId));
    }

    public EntityPhone addPhoneToEntity(EntityPhone phone) throws RiceIllegalArgumentException, RiceIllegalStateException {
        this.incomingParamCheck(phone, "phone");
        if (StringUtils.isBlank((String)phone.getEntityId()) || StringUtils.isBlank((String)phone.getEntityTypeCode())) {
            throw new RiceIllegalStateException("Phone's entityId and entityTypeCode must be populated before creation");
        }
        if (phone.getPhoneType() == null) {
            throw new RiceIllegalStateException("Phone's type must be populated before creation");
        }
        if (this.getEntityPhoneBo(phone.getEntityId(), phone.getEntityTypeCode(), phone.getPhoneType().getCode()) != null) {
            throw new RiceIllegalStateException("the phone to create already exists: " + String.valueOf(phone));
        }
        EntityPhoneBo bo = EntityPhoneBo.from(phone);
        return EntityPhoneBo.to((EntityPhoneBo)((Object)this.dataObjectService.save((Object)bo, new PersistenceOption[0])));
    }

    public EntityPhone updatePhone(EntityPhone phone) throws RiceIllegalArgumentException, RiceIllegalStateException {
        this.incomingParamCheck(phone, "phone");
        if (StringUtils.isBlank((String)phone.getEntityId()) || StringUtils.isBlank((String)phone.getEntityTypeCode())) {
            throw new RiceIllegalStateException("Phone's entityId and entityTypeCode must be populated before creation");
        }
        if (phone.getPhoneType() == null) {
            throw new RiceIllegalStateException("Phone's type must be populated before creation");
        }
        if (StringUtils.isEmpty((String)phone.getId()) || this.getEntityPhoneBo(phone.getEntityId(), phone.getEntityTypeCode(), phone.getPhoneType().getCode()) == null) {
            throw new RiceIllegalStateException("the phone to update does not exists: " + String.valueOf(phone));
        }
        EntityPhoneBo bo = EntityPhoneBo.from(phone);
        return EntityPhoneBo.to((EntityPhoneBo)((Object)this.dataObjectService.save((Object)bo, new PersistenceOption[0])));
    }

    public EntityPhone inactivatePhone(String phoneId) throws RiceIllegalArgumentException, RiceIllegalStateException {
        this.incomingParamCheck(phoneId, "phoneId");
        EntityPhoneBo bo = this.getEntityPhoneBo(phoneId);
        if (bo == null) {
            throw new RiceIllegalStateException("Phone with phoneId: " + phoneId + " does not exist");
        }
        bo.setActive(false);
        return EntityPhoneBo.to((EntityPhoneBo)((Object)this.dataObjectService.save((Object)bo, new PersistenceOption[0])));
    }

    protected EntityExternalIdentifierBo getEntityExternalIdentifierBo(String entityId, String externalIdentifierTypeCode) {
        HashMap<String, String> criteria = new HashMap<String, String>(4);
        criteria.put("entityId", entityId);
        criteria.put("externalIdentifierTypeCode", externalIdentifierTypeCode);
        List results = this.dataObjectService.findMatching(EntityExternalIdentifierBo.class, QueryByCriteria.Builder.andAttributes(criteria).build()).getResults();
        if (results.isEmpty()) {
            return null;
        }
        return (EntityExternalIdentifierBo)((Object)results.get(0));
    }

    public EntityExternalIdentifier addExternalIdentifierToEntity(EntityExternalIdentifier externalId) throws RiceIllegalArgumentException, RiceIllegalStateException {
        this.incomingParamCheck(externalId, "externalId");
        if (StringUtils.isBlank((String)externalId.getEntityId()) || StringUtils.isBlank((String)externalId.getExternalIdentifierTypeCode())) {
            throw new RiceIllegalStateException("EntityExternalIdentifier's entityId and entityTypeCode must be populated before creation");
        }
        if (this.getEntityExternalIdentifierBo(externalId.getEntityId(), externalId.getExternalIdentifierTypeCode()) != null) {
            throw new RiceIllegalStateException("the EntityExternalIdentifier to create already exists: " + String.valueOf(externalId));
        }
        EntityExternalIdentifierBo bo = EntityExternalIdentifierBo.from(externalId);
        return EntityExternalIdentifierBo.to((EntityExternalIdentifierBo)((Object)this.dataObjectService.save((Object)bo, new PersistenceOption[0])));
    }

    public EntityExternalIdentifier updateExternalIdentifier(EntityExternalIdentifier externalId) throws RiceIllegalArgumentException, RiceIllegalStateException {
        this.incomingParamCheck(externalId, "externalId");
        if (StringUtils.isBlank((String)externalId.getEntityId()) || StringUtils.isBlank((String)externalId.getExternalIdentifierTypeCode())) {
            throw new RiceIllegalStateException("EntityExternalIdentifier's entityId and externalIdentifierTypeCode must be populated before creation");
        }
        if (StringUtils.isEmpty((String)externalId.getId()) || this.getEntityExternalIdentifierBo(externalId.getEntityId(), externalId.getExternalIdentifierTypeCode()) == null) {
            throw new RiceIllegalStateException("the external identifier to update does not exist: " + String.valueOf(externalId));
        }
        EntityExternalIdentifierBo bo = EntityExternalIdentifierBo.from(externalId);
        return EntityExternalIdentifierBo.to((EntityExternalIdentifierBo)((Object)this.dataObjectService.save((Object)bo, new PersistenceOption[0])));
    }

    protected EntityAffiliationBo getEntityAffiliationBo(String id) {
        return (EntityAffiliationBo)((Object)this.dataObjectService.find(EntityAffiliationBo.class, (Object)id));
    }

    public EntityAffiliation addAffiliationToEntity(EntityAffiliation affiliation) throws RiceIllegalArgumentException, RiceIllegalStateException {
        this.incomingParamCheck(affiliation, "affiliation");
        if (StringUtils.isBlank((String)affiliation.getEntityId())) {
            throw new RiceIllegalStateException("Affiliation's entityId must be populated before creation");
        }
        if (affiliation.getAffiliationType() == null) {
            throw new RiceIllegalStateException("EntityAffiliation's type must be populated before creation");
        }
        if (this.getEntityAffiliationBo(affiliation.getId()) != null) {
            throw new RiceIllegalStateException("the EntityAffiliation to create already exists: " + String.valueOf(affiliation));
        }
        EntityAffiliationBo bo = EntityAffiliationBo.from(affiliation);
        return EntityAffiliationBo.to((EntityAffiliationBo)((Object)this.dataObjectService.save((Object)bo, new PersistenceOption[0])));
    }

    public EntityAffiliation updateAffiliation(EntityAffiliation affiliation) throws RiceIllegalArgumentException, RiceIllegalStateException {
        this.incomingParamCheck(affiliation, "affiliation");
        if (StringUtils.isBlank((String)affiliation.getEntityId())) {
            throw new RiceIllegalStateException("Affiliation's entityId must be populated before creation");
        }
        if (affiliation.getAffiliationType() == null) {
            throw new RiceIllegalStateException("EntityAffiliation's type must be populated before creation");
        }
        if (StringUtils.isEmpty((String)affiliation.getId()) || this.getEntityAffiliationBo(affiliation.getId()) == null) {
            throw new RiceIllegalStateException("the EntityAffiliation to update already exists: " + String.valueOf(affiliation));
        }
        EntityAffiliationBo bo = EntityAffiliationBo.from(affiliation);
        return EntityAffiliationBo.to((EntityAffiliationBo)((Object)this.dataObjectService.save((Object)bo, new PersistenceOption[0])));
    }

    public EntityAffiliation inactivateAffiliation(String id) throws RiceIllegalArgumentException, RiceIllegalStateException {
        this.incomingParamCheck(id, "id");
        EntityAffiliationBo bo = this.getEntityAffiliationBo(id);
        if (bo == null) {
            throw new RiceIllegalStateException("EntityAffiliation with id: " + id + " does not exist");
        }
        bo.setActive(false);
        return EntityAffiliationBo.to((EntityAffiliationBo)((Object)this.dataObjectService.save((Object)bo, new PersistenceOption[0])));
    }

    public EntityQueryResults findEntities(QueryByCriteria queryByCriteria) throws RiceIllegalArgumentException {
        this.incomingParamCheck(queryByCriteria, "queryByCriteria");
        QueryResults results = this.dataObjectService.findMatching(EntityBo.class, queryByCriteria);
        EntityQueryResults.Builder builder = EntityQueryResults.Builder.create();
        builder.setMoreResultsAvailable(results.isMoreResultsAvailable());
        builder.setTotalRowCount(results.getTotalRowCount());
        ArrayList<Entity.Builder> ims = new ArrayList<Entity.Builder>();
        for (EntityBo bo : results.getResults()) {
            ims.add(Entity.Builder.create((EntityContract)bo));
        }
        builder.setResults(ims);
        return builder.build();
    }

    public EntityDefaultQueryResults findEntityDefaults(QueryByCriteria queryByCriteria) throws RiceIllegalArgumentException {
        this.incomingParamCheck(queryByCriteria, "queryByCriteria");
        QueryResults results = this.dataObjectService.findMatching(EntityBo.class, queryByCriteria);
        EntityDefaultQueryResults.Builder builder = EntityDefaultQueryResults.Builder.create();
        builder.setMoreResultsAvailable(results.isMoreResultsAvailable());
        builder.setTotalRowCount(results.getTotalRowCount());
        ArrayList<EntityDefault.Builder> ims = new ArrayList<EntityDefault.Builder>();
        for (EntityBo bo : results.getResults()) {
            ims.add(EntityDefault.Builder.create((EntityContract)bo));
        }
        builder.setResults(ims);
        return builder.build();
    }

    protected EntityNameQueryResults findNames(QueryByCriteria queryByCriteria) {
        this.incomingParamCheck(queryByCriteria, "queryByCriteria");
        QueryResults results = this.dataObjectService.findMatching(EntityNameBo.class, queryByCriteria);
        EntityNameQueryResults.Builder builder = EntityNameQueryResults.Builder.create();
        builder.setMoreResultsAvailable(results.isMoreResultsAvailable());
        builder.setTotalRowCount(results.getTotalRowCount());
        ArrayList<EntityName.Builder> ims = new ArrayList<EntityName.Builder>();
        for (EntityNameBo bo : results.getResults()) {
            ims.add(EntityName.Builder.create((EntityNameContract)bo));
        }
        builder.setResults(ims);
        return builder.build();
    }

    public EntityPrivacyPreferences getEntityPrivacyPreferences(String entityId) throws RiceIllegalArgumentException {
        this.incomingParamCheck(entityId, "entityId");
        return EntityPrivacyPreferencesBo.to((EntityPrivacyPreferencesBo)((Object)this.dataObjectService.find(EntityPrivacyPreferencesBo.class, (Object)entityId)));
    }

    public Principal getPrincipal(String principalId) throws RiceIllegalArgumentException {
        this.incomingParamCheck(principalId, "principalId");
        PrincipalBo principal = this.getPrincipalBo(principalId);
        if (principal == null) {
            return null;
        }
        if (StringUtils.isBlank((String)principal.getPrincipalName())) {
            principal.setPrincipalName(UNAVAILABLE);
        }
        return PrincipalBo.to(principal);
    }

    public List<Principal> getPrincipals(List<String> principalIds) {
        ArrayList<Principal> ret = new ArrayList<Principal>();
        for (String p : principalIds) {
            Principal principalInfo = this.getPrincipal(p);
            if (principalInfo == null) continue;
            ret.add(principalInfo);
        }
        return ret;
    }

    protected PrincipalBo getPrincipalBo(String principalId) {
        return (PrincipalBo)((Object)this.dataObjectService.find(PrincipalBo.class, (Object)principalId));
    }

    protected EntityBo getEntityBo(String entityId) {
        return (EntityBo)((Object)this.dataObjectService.find(EntityBo.class, (Object)entityId));
    }

    public Principal getPrincipalByPrincipalName(String principalName) throws RiceIllegalArgumentException {
        this.incomingParamCheck(principalName, "principalName");
        return PrincipalBo.to(this.getPrincipalBoByPrincipalName(principalName));
    }

    protected PrincipalBo getPrincipalBoByPrincipalName(String principalName) throws RiceIllegalArgumentException {
        QueryResults principals = this.dataObjectService.findMatching(PrincipalBo.class, QueryByCriteria.Builder.forAttribute((String)"principalName", (Object)principalName.toLowerCase()).build());
        if (!principals.getResults().isEmpty() && principals.getResults().size() == 1) {
            return (PrincipalBo)((Object)principals.getResults().get(0));
        }
        return null;
    }

    public List<Principal> getPrincipalsByEntityId(String entityId) throws RiceIllegalArgumentException {
        this.incomingParamCheck(entityId, "entityId");
        ArrayList<Principal> principals = new ArrayList<Principal>();
        HashMap<String, String> criteria = new HashMap<String, String>(1);
        criteria.put("entityId", entityId);
        QueryResults principalBos = this.dataObjectService.findMatching(PrincipalBo.class, QueryByCriteria.Builder.andAttributes(criteria).build());
        if (!principalBos.getResults().isEmpty()) {
            for (PrincipalBo principalBo : principalBos.getResults()) {
                Principal principal = PrincipalBo.to(principalBo);
                principals.add(principal);
            }
            return principals;
        }
        return null;
    }

    public List<Principal> getPrincipalsByEmployeeId(String employeeId) throws RiceIllegalArgumentException {
        this.incomingParamCheck(employeeId, "employeeId");
        ArrayList<Principal> principals = new ArrayList<Principal>();
        HashMap<String, String> criteria = new HashMap<String, String>(1);
        criteria.put("employeeId", employeeId);
        QueryResults entityEmploymentBos = this.dataObjectService.findMatching(EntityEmploymentBo.class, QueryByCriteria.Builder.andAttributes(criteria).build());
        if (!entityEmploymentBos.getResults().isEmpty()) {
            ArrayList<String> entityIds = new ArrayList<String>();
            for (EntityEmploymentBo entityEmploymentBo : entityEmploymentBos.getResults()) {
                String entityId = entityEmploymentBo.getEntityId();
                if (!StringUtils.isNotBlank((String)entityId) || entityIds.contains(entityId)) continue;
                entityIds.add(entityId);
            }
            for (String entityId : entityIds) {
                List<Principal> principalsForEntity = this.getPrincipalsByEntityId(entityId);
                if (principalsForEntity == null || principalsForEntity.isEmpty()) continue;
                principals.addAll(principalsForEntity);
            }
            if (!principals.isEmpty()) {
                return principals;
            }
        }
        return null;
    }

    protected EntityBo getEntityBoByPrincipalName(String principalName) {
        if (StringUtils.isBlank((String)principalName)) {
            return null;
        }
        return this.getEntityByKeyValue("principals.principalName", principalName.toLowerCase());
    }

    protected EntityBo getEntityBoByPrincipalId(String principalId) {
        if (StringUtils.isBlank((String)principalId)) {
            return null;
        }
        return this.getEntityByKeyValue("principals.principalId", principalId);
    }

    protected EntityBo getEntityBoByEmployeeId(String employeeId) {
        if (StringUtils.isBlank((String)employeeId)) {
            return null;
        }
        return this.getEntityByKeyValue("employmentInformation.employeeId", employeeId);
    }

    protected EntityBo getEntityByKeyValue(String key, String value) {
        List entities = this.dataObjectService.findMatching(EntityBo.class, QueryByCriteria.Builder.forAttribute((String)key, (Object)value).build()).getResults();
        if (entities.size() >= 1) {
            return (EntityBo)((Object)entities.get(0));
        }
        return null;
    }

    public CodedAttribute getAddressType(String code) throws RiceIllegalArgumentException {
        this.incomingParamCheck(code, "code");
        EntityAddressTypeBo impl = (EntityAddressTypeBo)((Object)this.dataObjectService.find(EntityAddressTypeBo.class, (Object)code));
        if (impl == null) {
            return null;
        }
        return EntityAddressTypeBo.to(impl);
    }

    public List<CodedAttribute> findAllAddressTypes() {
        List bos = this.dataObjectService.findMatching(EntityAddressTypeBo.class, QueryByCriteria.Builder.forAttribute((String)"active", (Object)Boolean.TRUE).build()).getResults();
        ArrayList<CodedAttribute> codedAttributes = new ArrayList<CodedAttribute>();
        for (EntityAddressTypeBo bo : bos) {
            codedAttributes.add(EntityAddressTypeBo.to(bo));
        }
        return Collections.unmodifiableList(codedAttributes);
    }

    public EntityAffiliationType getAffiliationType(String code) throws RiceIllegalArgumentException {
        this.incomingParamCheck(code, "code");
        EntityAffiliationTypeBo impl = (EntityAffiliationTypeBo)((Object)this.dataObjectService.find(EntityAffiliationTypeBo.class, (Object)code));
        if (impl == null) {
            return null;
        }
        return EntityAffiliationTypeBo.to(impl);
    }

    public List<EntityAffiliationType> findAllAffiliationTypes() {
        List bos = this.dataObjectService.findMatching(EntityAffiliationTypeBo.class, QueryByCriteria.Builder.forAttribute((String)"active", (Object)Boolean.TRUE).build()).getResults();
        ArrayList<EntityAffiliationType> codedAttributes = new ArrayList<EntityAffiliationType>();
        for (EntityAffiliationTypeBo bo : bos) {
            codedAttributes.add(EntityAffiliationTypeBo.to(bo));
        }
        return Collections.unmodifiableList(codedAttributes);
    }

    public CodedAttribute getCitizenshipStatus(String code) throws RiceIllegalArgumentException {
        this.incomingParamCheck(code, "code");
        EntityCitizenshipStatusBo impl = (EntityCitizenshipStatusBo)((Object)this.dataObjectService.find(EntityCitizenshipStatusBo.class, (Object)code));
        if (impl == null) {
            return null;
        }
        return EntityCitizenshipStatusBo.to(impl);
    }

    public List<CodedAttribute> findAllCitizenshipStatuses() {
        List bos = this.dataObjectService.findMatching(EntityCitizenshipStatusBo.class, QueryByCriteria.Builder.forAttribute((String)"active", (Object)Boolean.TRUE).build()).getResults();
        ArrayList<CodedAttribute> codedAttributes = new ArrayList<CodedAttribute>();
        for (EntityCitizenshipStatusBo bo : bos) {
            codedAttributes.add(EntityCitizenshipStatusBo.to(bo));
        }
        return Collections.unmodifiableList(codedAttributes);
    }

    public CodedAttribute getEmailType(String code) throws RiceIllegalArgumentException {
        this.incomingParamCheck(code, "code");
        EntityEmailTypeBo impl = (EntityEmailTypeBo)((Object)this.dataObjectService.find(EntityEmailTypeBo.class, (Object)code));
        if (impl == null) {
            return null;
        }
        return EntityEmailTypeBo.to(impl);
    }

    public List<CodedAttribute> findAllEmailTypes() {
        List bos = this.dataObjectService.findMatching(EntityEmailTypeBo.class, QueryByCriteria.Builder.forAttribute((String)"active", (Object)Boolean.TRUE).build()).getResults();
        ArrayList<CodedAttribute> codedAttributes = new ArrayList<CodedAttribute>();
        for (EntityEmailTypeBo bo : bos) {
            codedAttributes.add(EntityEmailTypeBo.to(bo));
        }
        return Collections.unmodifiableList(codedAttributes);
    }

    public PrincipalQueryResults findPrincipals(@WebParam(name="query") QueryByCriteria query) throws RiceIllegalArgumentException {
        this.incomingParamCheck(query, "query");
        QueryResults results = this.dataObjectService.findMatching(PrincipalBo.class, query);
        PrincipalQueryResults.Builder builder = PrincipalQueryResults.Builder.create();
        builder.setMoreResultsAvailable(results.isMoreResultsAvailable());
        builder.setTotalRowCount(results.getTotalRowCount());
        ArrayList<Principal.Builder> ims = new ArrayList<Principal.Builder>();
        for (PrincipalBo bo : results.getResults()) {
            ims.add(Principal.Builder.create((PrincipalContract)bo));
        }
        builder.setResults(ims);
        return builder.build();
    }

    public CodedAttribute getEmploymentStatus(String code) throws RiceIllegalArgumentException {
        this.incomingParamCheck(code, "code");
        EntityEmploymentStatusBo impl = (EntityEmploymentStatusBo)((Object)this.dataObjectService.find(EntityEmploymentStatusBo.class, (Object)code));
        if (impl == null) {
            return null;
        }
        return EntityEmploymentStatusBo.to(impl);
    }

    public List<CodedAttribute> findAllEmploymentStatuses() {
        List bos = this.dataObjectService.findMatching(EntityEmploymentStatusBo.class, QueryByCriteria.Builder.forAttribute((String)"active", (Object)Boolean.TRUE).build()).getResults();
        ArrayList<CodedAttribute> codedAttributes = new ArrayList<CodedAttribute>();
        for (EntityEmploymentStatusBo bo : bos) {
            codedAttributes.add(EntityEmploymentStatusBo.to(bo));
        }
        return Collections.unmodifiableList(codedAttributes);
    }

    public CodedAttribute getEmploymentType(String code) throws RiceIllegalArgumentException {
        this.incomingParamCheck(code, "code");
        EntityEmploymentTypeBo impl = (EntityEmploymentTypeBo)((Object)this.dataObjectService.find(EntityEmploymentTypeBo.class, (Object)code));
        if (impl == null) {
            return null;
        }
        return EntityEmploymentTypeBo.to(impl);
    }

    public List<CodedAttribute> findAllEmploymentTypes() {
        List bos = this.dataObjectService.findMatching(EntityEmploymentTypeBo.class, QueryByCriteria.Builder.forAttribute((String)"active", (Object)Boolean.TRUE).build()).getResults();
        ArrayList<CodedAttribute> codedAttributes = new ArrayList<CodedAttribute>();
        for (EntityEmploymentTypeBo bo : bos) {
            codedAttributes.add(EntityEmploymentTypeBo.to(bo));
        }
        return Collections.unmodifiableList(codedAttributes);
    }

    public CodedAttribute getNameType(String code) throws RiceIllegalArgumentException {
        this.incomingParamCheck(code, "code");
        EntityNameTypeBo impl = (EntityNameTypeBo)((Object)this.dataObjectService.find(EntityNameTypeBo.class, (Object)code));
        if (impl == null) {
            return null;
        }
        return EntityNameTypeBo.to(impl);
    }

    public List<CodedAttribute> findAllNameTypes() {
        List bos = this.dataObjectService.findMatching(EntityNameTypeBo.class, QueryByCriteria.Builder.forAttribute((String)"active", (Object)Boolean.TRUE).build()).getResults();
        ArrayList<CodedAttribute> codedAttributes = new ArrayList<CodedAttribute>();
        for (EntityNameTypeBo bo : bos) {
            codedAttributes.add(EntityNameTypeBo.to(bo));
        }
        return Collections.unmodifiableList(codedAttributes);
    }

    public CodedAttribute getEntityType(String code) throws RiceIllegalArgumentException {
        this.incomingParamCheck(code, "code");
        EntityTypeBo impl = (EntityTypeBo)((Object)this.dataObjectService.find(EntityTypeBo.class, (Object)code));
        if (impl == null) {
            return null;
        }
        return EntityTypeBo.to(impl);
    }

    public List<CodedAttribute> findAllEntityTypes() {
        List bos = this.dataObjectService.findMatching(EntityTypeBo.class, QueryByCriteria.Builder.forAttribute((String)"active", (Object)Boolean.TRUE).build()).getResults();
        ArrayList<CodedAttribute> codedAttributes = new ArrayList<CodedAttribute>();
        for (EntityTypeBo bo : bos) {
            codedAttributes.add(EntityTypeBo.to(bo));
        }
        return Collections.unmodifiableList(codedAttributes);
    }

    public EntityExternalIdentifierType getExternalIdentifierType(String code) throws RiceIllegalArgumentException {
        this.incomingParamCheck(code, "code");
        EntityExternalIdentifierTypeBo impl = (EntityExternalIdentifierTypeBo)((Object)this.dataObjectService.find(EntityExternalIdentifierTypeBo.class, (Object)code));
        if (impl == null) {
            return null;
        }
        return EntityExternalIdentifierTypeBo.to(impl);
    }

    public List<EntityExternalIdentifierType> findAllExternalIdendtifierTypes() {
        List bos = this.dataObjectService.findMatching(EntityExternalIdentifierTypeBo.class, QueryByCriteria.Builder.forAttribute((String)"active", (Object)Boolean.TRUE).build()).getResults();
        ArrayList<EntityExternalIdentifierType> codedAttributes = new ArrayList<EntityExternalIdentifierType>();
        for (EntityExternalIdentifierTypeBo bo : bos) {
            codedAttributes.add(EntityExternalIdentifierTypeBo.to(bo));
        }
        return Collections.unmodifiableList(codedAttributes);
    }

    public CodedAttribute getPhoneType(String code) throws RiceIllegalArgumentException {
        this.incomingParamCheck(code, "code");
        EntityPhoneTypeBo impl = (EntityPhoneTypeBo)((Object)this.dataObjectService.find(EntityPhoneTypeBo.class, (Object)code));
        if (impl == null) {
            return null;
        }
        return EntityPhoneTypeBo.to(impl);
    }

    public List<CodedAttribute> findAllPhoneTypes() {
        List bos = this.dataObjectService.findMatching(EntityPhoneTypeBo.class, QueryByCriteria.Builder.forAttribute((String)"active", (Object)Boolean.TRUE).build()).getResults();
        ArrayList<CodedAttribute> codedAttributes = new ArrayList<CodedAttribute>();
        for (EntityPhoneTypeBo bo : bos) {
            codedAttributes.add(EntityPhoneTypeBo.to(bo));
        }
        return Collections.unmodifiableList(codedAttributes);
    }

    public Entity createEntity(Entity entity) throws RiceIllegalArgumentException, RiceIllegalStateException {
        this.incomingParamCheck(entity, "entity");
        if (StringUtils.isNotBlank((String)entity.getId()) && this.getEntity(entity.getId()) != null) {
            throw new RiceIllegalStateException("the Entity to create already exists: " + String.valueOf(entity));
        }
        EntityBo bo = EntityBo.from(entity);
        return EntityBo.to((EntityBo)((Object)this.dataObjectService.save((Object)bo, new PersistenceOption[0])));
    }

    public Entity updateEntity(Entity entity) throws RiceIllegalArgumentException, RiceIllegalStateException {
        this.incomingParamCheck(entity, "entity");
        EntityBo oldBo = null;
        HashMap<String, String> passwdMap = new HashMap<String, String>();
        if (StringUtils.isBlank((String)entity.getId())) {
            throw new RiceIllegalStateException("the Entity does not exist: " + String.valueOf(entity));
        }
        oldBo = this.getEntityBo(entity.getId());
        if (oldBo == null) {
            throw new RiceIllegalStateException("the Entity does not exist: " + String.valueOf(entity));
        }
        for (PrincipalBo principalBo : oldBo.getPrincipals()) {
            passwdMap.put(principalBo.getPrincipalId(), principalBo.getPassword());
        }
        EntityBo bo = EntityBo.from(entity);
        for (PrincipalBo principal : bo.getPrincipals()) {
            principal.setPassword((String)passwdMap.get(principal.getPrincipalId()));
        }
        return EntityBo.to((EntityBo)((Object)this.dataObjectService.save((Object)bo, new PersistenceOption[0])));
    }

    public Entity inactivateEntity(String entityId) throws RiceIllegalArgumentException, RiceIllegalStateException {
        this.incomingParamCheck(entityId, "entityId");
        EntityBo entity = this.getEntityBo(entityId);
        if (entity == null) {
            throw new RiceIllegalStateException("an Entity does not exist for entityId: " + entityId);
        }
        entity.setActive(false);
        return EntityBo.to((EntityBo)((Object)this.dataObjectService.save((Object)entity, new PersistenceOption[0])));
    }

    public EntityPrivacyPreferences addPrivacyPreferencesToEntity(EntityPrivacyPreferences privacyPreferences) throws RiceIllegalArgumentException, RiceIllegalStateException {
        this.incomingParamCheck(privacyPreferences, "privacyPreferences");
        if (StringUtils.isBlank((String)privacyPreferences.getEntityId())) {
            throw new RiceIllegalStateException("PrivacyPreferences' entityId must be populated before creation");
        }
        if (this.getEntityPrivacyPreferences(privacyPreferences.getEntityId()) != null) {
            throw new RiceIllegalStateException("the PrivacyPreferences to create already exists: " + String.valueOf(privacyPreferences));
        }
        EntityPrivacyPreferencesBo bo = EntityPrivacyPreferencesBo.from(privacyPreferences);
        return EntityPrivacyPreferencesBo.to((EntityPrivacyPreferencesBo)((Object)this.dataObjectService.save((Object)bo, new PersistenceOption[0])));
    }

    public EntityPrivacyPreferences updatePrivacyPreferences(EntityPrivacyPreferences privacyPreferences) throws RiceIllegalArgumentException, RiceIllegalStateException {
        this.incomingParamCheck(privacyPreferences, "privacyPreferences");
        if (StringUtils.isBlank((String)privacyPreferences.getEntityId())) {
            throw new RiceIllegalStateException("PrivacyPreferences' entityId must be populated before update");
        }
        if (this.getEntityPrivacyPreferences(privacyPreferences.getEntityId()) == null) {
            throw new RiceIllegalStateException("the PrivacyPreferences to update does not exist: " + String.valueOf(privacyPreferences));
        }
        EntityPrivacyPreferencesBo bo = EntityPrivacyPreferencesBo.from(privacyPreferences);
        return EntityPrivacyPreferencesBo.to((EntityPrivacyPreferencesBo)((Object)this.dataObjectService.save((Object)bo, new PersistenceOption[0])));
    }

    protected EntityCitizenshipBo getEntityCitizenshipBo(String entityId, String citizenshipStatusCode) {
        if (StringUtils.isEmpty((String)entityId) || StringUtils.isEmpty((String)citizenshipStatusCode)) {
            return null;
        }
        HashMap<String, Object> criteria = new HashMap<String, Object>(4);
        criteria.put("entityId", entityId);
        criteria.put("statusCode", citizenshipStatusCode);
        criteria.put("active", Boolean.TRUE);
        List results = this.dataObjectService.findMatching(EntityCitizenshipBo.class, QueryByCriteria.Builder.andAttributes(criteria).build()).getResults();
        if (results.isEmpty()) {
            return null;
        }
        return (EntityCitizenshipBo)((Object)results.get(0));
    }

    protected EntityCitizenshipBo getEntityCitizenshipBo(String id) {
        if (StringUtils.isEmpty((String)id)) {
            return null;
        }
        HashMap<String, Object> criteria = new HashMap<String, Object>();
        criteria.put("id", id);
        criteria.put("active", Boolean.TRUE);
        List results = this.dataObjectService.findMatching(EntityCitizenshipBo.class, QueryByCriteria.Builder.andAttributes(criteria).build()).getResults();
        if (results.isEmpty()) {
            return null;
        }
        return (EntityCitizenshipBo)((Object)results.get(0));
    }

    public EntityCitizenship addCitizenshipToEntity(EntityCitizenship citizenship) throws RiceIllegalArgumentException, RiceIllegalStateException {
        this.incomingParamCheck(citizenship, "citizenship");
        if (StringUtils.isBlank((String)citizenship.getEntityId())) {
            throw new RiceIllegalStateException("Citizenship's entityId must be populated before creation");
        }
        if (citizenship.getStatus() == null) {
            throw new RiceIllegalStateException("Citizenship's status must be populated before creation");
        }
        if (this.getEntityCitizenshipBo(citizenship.getEntityId(), citizenship.getStatus().getCode()) != null) {
            throw new RiceIllegalStateException("the EntityCitizenship to create already exists: " + String.valueOf(citizenship));
        }
        EntityCitizenshipBo bo = EntityCitizenshipBo.from(citizenship);
        return EntityCitizenshipBo.to((EntityCitizenshipBo)((Object)this.dataObjectService.save((Object)bo, new PersistenceOption[0])));
    }

    public EntityCitizenship updateCitizenship(EntityCitizenship citizenship) throws RiceIllegalArgumentException, RiceIllegalStateException {
        this.incomingParamCheck(citizenship, "citizenship");
        if (StringUtils.isBlank((String)citizenship.getEntityId())) {
            throw new RiceIllegalStateException("Email's entityId must be populated before creation");
        }
        if (citizenship.getStatus() == null) {
            throw new RiceIllegalStateException("Citizenship's status must be populated before creation");
        }
        if (this.getEntityCitizenshipBo(citizenship.getEntityId(), citizenship.getStatus().getCode()) == null) {
            throw new RiceIllegalStateException("the EntityCitizenship to update does not exist: " + String.valueOf(citizenship));
        }
        EntityCitizenshipBo bo = EntityCitizenshipBo.from(citizenship);
        return EntityCitizenshipBo.to((EntityCitizenshipBo)((Object)this.dataObjectService.save((Object)bo, new PersistenceOption[0])));
    }

    public EntityCitizenship inactivateCitizenship(String id) throws RiceIllegalArgumentException, RiceIllegalStateException {
        this.incomingParamCheck(id, "id");
        EntityCitizenshipBo bo = this.getEntityCitizenshipBo(id);
        if (bo == null) {
            throw new RiceIllegalStateException("the EntityCitizenship with id: " + id + " does not exist");
        }
        bo.setActive(false);
        return EntityCitizenshipBo.to((EntityCitizenshipBo)((Object)this.dataObjectService.save((Object)bo, new PersistenceOption[0])));
    }

    protected EntityEthnicityBo getEntityEthnicityBo(String ethnicityId) {
        if (StringUtils.isEmpty((String)ethnicityId)) {
            return null;
        }
        return (EntityEthnicityBo)((Object)this.dataObjectService.find(EntityEthnicityBo.class, (Object)ethnicityId));
    }

    public EntityEthnicity addEthnicityToEntity(EntityEthnicity ethnicity) throws RiceIllegalArgumentException {
        this.incomingParamCheck(ethnicity, "ethnicity");
        if (StringUtils.isBlank((String)ethnicity.getEntityId())) {
            throw new RiceIllegalStateException("Ethnicity's entityId must be populated before creation");
        }
        if (StringUtils.isNotEmpty((String)ethnicity.getId()) && this.getEntityEthnicityBo(ethnicity.getId()) != null) {
            throw new RiceIllegalStateException("the EntityEthnicity to create already exists: " + String.valueOf(ethnicity));
        }
        EntityEthnicityBo bo = EntityEthnicityBo.from(ethnicity);
        return EntityEthnicityBo.to((EntityEthnicityBo)((Object)this.dataObjectService.save((Object)bo, new PersistenceOption[0])));
    }

    public EntityEthnicity updateEthnicity(EntityEthnicity ethnicity) throws RiceIllegalArgumentException, RiceIllegalStateException {
        this.incomingParamCheck(ethnicity, "ethnicity");
        if (StringUtils.isBlank((String)ethnicity.getEntityId())) {
            throw new RiceIllegalStateException("Ethnicity's entityId must be populated before creation");
        }
        if (StringUtils.isEmpty((String)ethnicity.getId()) || this.getEntityEthnicityBo(ethnicity.getId()) == null) {
            throw new RiceIllegalStateException("the EntityEthnicity to update does not exist: " + String.valueOf(ethnicity));
        }
        EntityEthnicityBo bo = EntityEthnicityBo.from(ethnicity);
        return EntityEthnicityBo.to((EntityEthnicityBo)((Object)this.dataObjectService.save((Object)bo, new PersistenceOption[0])));
    }

    protected EntityResidencyBo getEntityResidencyBo(String residencyId) {
        if (StringUtils.isEmpty((String)residencyId)) {
            return null;
        }
        return (EntityResidencyBo)((Object)this.dataObjectService.find(EntityResidencyBo.class, (Object)residencyId));
    }

    public EntityResidency addResidencyToEntity(EntityResidency residency) throws RiceIllegalArgumentException, RiceIllegalStateException {
        this.incomingParamCheck(residency, "residency");
        if (StringUtils.isBlank((String)residency.getEntityId())) {
            throw new RiceIllegalStateException("Residency's entityId must be populated before creation");
        }
        if (StringUtils.isNotEmpty((String)residency.getId()) && this.getEntityResidencyBo(residency.getId()) != null) {
            throw new RiceIllegalStateException("the EntityResidency to create already exists: " + String.valueOf(residency));
        }
        EntityResidencyBo bo = EntityResidencyBo.from(residency);
        return EntityResidencyBo.to((EntityResidencyBo)((Object)this.dataObjectService.save((Object)bo, new PersistenceOption[0])));
    }

    public EntityResidency updateResidency(EntityResidency residency) throws RiceIllegalArgumentException, RiceIllegalStateException {
        this.incomingParamCheck(residency, "residency");
        if (StringUtils.isBlank((String)residency.getEntityId())) {
            throw new RiceIllegalStateException("Residency's entityId must be populated before creation");
        }
        if (StringUtils.isEmpty((String)residency.getId()) || this.getEntityResidencyBo(residency.getId()) == null) {
            throw new RiceIllegalStateException("the EntityResidency to update does not exist: " + String.valueOf(residency));
        }
        EntityResidencyBo bo = EntityResidencyBo.from(residency);
        return EntityResidencyBo.to((EntityResidencyBo)((Object)this.dataObjectService.save((Object)bo, new PersistenceOption[0])));
    }

    protected EntityVisaBo getEntityVisaBo(String visaId) {
        if (StringUtils.isEmpty((String)visaId)) {
            return null;
        }
        return (EntityVisaBo)((Object)this.dataObjectService.find(EntityVisaBo.class, (Object)visaId));
    }

    public EntityVisa addVisaToEntity(EntityVisa visa) throws RiceIllegalArgumentException, RiceIllegalStateException {
        this.incomingParamCheck(visa, "visa");
        if (StringUtils.isBlank((String)visa.getEntityId())) {
            throw new RiceIllegalStateException("Visa's entityId must be populated before creation");
        }
        if (StringUtils.isNotEmpty((String)visa.getId()) && this.getEntityVisaBo(visa.getId()) != null) {
            throw new RiceIllegalStateException("the EntityVisa to create already exists: " + String.valueOf(visa));
        }
        EntityVisaBo bo = EntityVisaBo.from(visa);
        return EntityVisaBo.to((EntityVisaBo)((Object)this.dataObjectService.save((Object)bo, new PersistenceOption[0])));
    }

    public EntityVisa updateVisa(EntityVisa visa) throws RiceIllegalArgumentException, RiceIllegalStateException {
        this.incomingParamCheck(visa, "visa");
        if (StringUtils.isBlank((String)visa.getEntityId())) {
            throw new RiceIllegalStateException("Visa's entityId must be populated before creation");
        }
        if (StringUtils.isEmpty((String)visa.getId()) || this.getEntityVisaBo(visa.getId()) == null) {
            throw new RiceIllegalStateException("the EntityVisa to update does not exist: " + String.valueOf(visa));
        }
        EntityVisaBo bo = EntityVisaBo.from(visa);
        return EntityVisaBo.to((EntityVisaBo)((Object)this.dataObjectService.save((Object)bo, new PersistenceOption[0])));
    }

    protected EntityNameBo getEntityNameBo(String entityId, String nameTypeCode) {
        if (StringUtils.isEmpty((String)entityId) || StringUtils.isEmpty((String)nameTypeCode)) {
            return null;
        }
        HashMap<String, Object> criteria = new HashMap<String, Object>();
        criteria.put("entityId", entityId);
        criteria.put("nameCode", nameTypeCode);
        criteria.put("active", Boolean.TRUE);
        List results = this.dataObjectService.findMatching(EntityNameBo.class, QueryByCriteria.Builder.andAttributes(criteria).build()).getResults();
        if (results.isEmpty()) {
            return null;
        }
        return (EntityNameBo)((Object)results.get(0));
    }

    protected EntityNameBo getEntityNameBo(String id) {
        if (StringUtils.isEmpty((String)id)) {
            return null;
        }
        HashMap<String, Object> criteria = new HashMap<String, Object>();
        criteria.put("id", id);
        criteria.put("active", Boolean.TRUE);
        List results = this.dataObjectService.findMatching(EntityNameBo.class, QueryByCriteria.Builder.andAttributes(criteria).build()).getResults();
        if (results.isEmpty()) {
            return null;
        }
        return (EntityNameBo)((Object)results.get(0));
    }

    public EntityNamePrincipalName getDefaultNamesForPrincipalId(String principalId) {
        PrincipalBo principal = (PrincipalBo)((Object)this.dataObjectService.find(PrincipalBo.class, (Object)principalId));
        if (null != principal) {
            EntityNamePrincipalName.Builder nameBuilder = EntityNamePrincipalName.Builder.create();
            nameBuilder.setPrincipalName(principal.getPrincipalName());
            HashMap<String, Object> criteria = new HashMap<String, Object>();
            criteria.put("entityId", principal.getEntityId());
            criteria.put("defaultValue", Boolean.TRUE);
            criteria.put("active", Boolean.TRUE);
            List results = this.dataObjectService.findMatching(EntityNameBo.class, QueryByCriteria.Builder.andAttributes(criteria).build()).getResults();
            if (results.isEmpty()) {
                EntityName.Builder defaultNameBuilder = EntityName.Builder.create();
                defaultNameBuilder.setLastName(principal.getPrincipalName().toUpperCase());
                nameBuilder.setDefaultName(defaultNameBuilder);
            } else {
                nameBuilder.setDefaultName(EntityName.Builder.create((EntityNameContract)((EntityNameContract)results.get(0))));
            }
            EntityNamePrincipalName entityNamePrincipalName = nameBuilder.build();
            return entityNamePrincipalName;
        }
        return null;
    }

    public Map<String, EntityNamePrincipalName> getDefaultNamesForPrincipalIds(List<String> principalIds) {
        return this.getIdentityServiceDao().getDefaultNamesByPrincipalIds(principalIds);
    }

    public EntityPrivacyPreferences getPrivacyPreferencesForPrincipalId(String principalId) {
        PrincipalBo principal = (PrincipalBo)((Object)this.dataObjectService.find(PrincipalBo.class, (Object)principalId));
        if (principal != null) {
            EntityPrivacyPreferencesBo privacyPrefs = (EntityPrivacyPreferencesBo)((Object)this.dataObjectService.find(EntityPrivacyPreferencesBo.class, (Object)principal.getEntityId()));
            if (privacyPrefs != null) {
                return EntityPrivacyPreferencesBo.to(privacyPrefs);
            }
            return EntityPrivacyPreferences.Builder.create((String)principal.getEntityId()).build();
        }
        return null;
    }

    public EntityName addNameToEntity(EntityName name) throws RiceIllegalArgumentException, RiceIllegalStateException {
        this.incomingParamCheck(name, "name");
        if (StringUtils.isBlank((String)name.getEntityId())) {
            throw new RiceIllegalStateException("Name's entityId must be populated before creation");
        }
        if (name.getNameType() == null) {
            throw new RiceIllegalStateException("EntityName's type must be populated before creation");
        }
        if (this.getEntityNameBo(name.getEntityId(), name.getNameType().getCode()) != null) {
            throw new RiceIllegalStateException("the EntityName to create already exists: " + String.valueOf(name));
        }
        EntityNameBo bo = EntityNameBo.from(name);
        return EntityNameBo.to((EntityNameBo)((Object)this.dataObjectService.save((Object)bo, new PersistenceOption[0])));
    }

    public EntityName updateName(EntityName name) throws RiceIllegalArgumentException, RiceIllegalStateException {
        this.incomingParamCheck(name, "name");
        if (StringUtils.isBlank((String)name.getEntityId())) {
            throw new RiceIllegalStateException("Name's entityId must be populated before update");
        }
        if (name.getNameType() == null) {
            throw new RiceIllegalStateException("EntityName's type must be populated before update");
        }
        if (StringUtils.isEmpty((String)name.getId()) || this.getEntityNameBo(name.getId()) == null) {
            throw new RiceIllegalStateException("the EntityName to update does not exist: " + String.valueOf(name));
        }
        EntityNameBo bo = EntityNameBo.from(name);
        return EntityNameBo.to((EntityNameBo)((Object)this.dataObjectService.save((Object)bo, new PersistenceOption[0])));
    }

    public EntityName inactivateName(String id) throws RiceIllegalArgumentException, RiceIllegalStateException {
        this.incomingParamCheck(id, "id");
        EntityNameBo bo = this.getEntityNameBo(id);
        if (bo == null) {
            throw new RiceIllegalStateException("the EntityName to inactivate does not exist");
        }
        bo.setActive(false);
        return EntityNameBo.to((EntityNameBo)((Object)this.dataObjectService.save((Object)bo, new PersistenceOption[0])));
    }

    protected EntityEmploymentBo getEntityEmploymentBo(String entityId, String employmentTypeCode, String employmentStatusCode, String employmentAffiliationId) {
        if (StringUtils.isEmpty((String)entityId) || StringUtils.isEmpty((String)employmentTypeCode) || StringUtils.isEmpty((String)employmentStatusCode) || StringUtils.isEmpty((String)employmentAffiliationId)) {
            return null;
        }
        HashMap<String, Object> criteria = new HashMap<String, Object>();
        criteria.put("entityId", entityId);
        criteria.put("employeeTypeCode", employmentTypeCode);
        criteria.put("employeeStatusCode", employmentStatusCode);
        criteria.put("entityAffiliationId", employmentAffiliationId);
        criteria.put("active", Boolean.TRUE);
        List results = this.dataObjectService.findMatching(EntityEmploymentBo.class, QueryByCriteria.Builder.andAttributes(criteria).build()).getResults();
        if (results.isEmpty()) {
            return null;
        }
        return (EntityEmploymentBo)((Object)results.get(0));
    }

    protected EntityEmploymentBo getEntityEmploymentBo(String id) {
        if (StringUtils.isEmpty((String)id)) {
            return null;
        }
        HashMap<String, Object> criteria = new HashMap<String, Object>();
        criteria.put("id", id);
        criteria.put("active", Boolean.TRUE);
        List results = this.dataObjectService.findMatching(EntityEmploymentBo.class, QueryByCriteria.Builder.andAttributes(criteria).build()).getResults();
        if (results.isEmpty()) {
            return null;
        }
        return (EntityEmploymentBo)((Object)results.get(0));
    }

    public EntityEmployment addEmploymentToEntity(EntityEmployment employment) throws RiceIllegalArgumentException, RiceIllegalStateException {
        this.incomingParamCheck(employment, "employment");
        if (StringUtils.isBlank((String)employment.getEntityId())) {
            throw new RiceIllegalStateException("EntityEmployment's entityId must be populated before creation");
        }
        if (employment.getEmployeeType() == null || employment.getEmployeeStatus() == null || employment.getEntityAffiliation() == null) {
            throw new RiceIllegalStateException("EntityEmployment's status, type, and entity affiliation must be populated before creation");
        }
        if (this.getEntityEmploymentBo(employment.getEntityId(), employment.getEmployeeType().getCode(), employment.getEmployeeStatus().getCode(), employment.getEntityAffiliation().getId()) != null) {
            throw new RiceIllegalStateException("the EntityEmployment to create already exists: " + String.valueOf(employment));
        }
        EntityEmploymentBo bo = EntityEmploymentBo.from(employment);
        return EntityEmploymentBo.to((EntityEmploymentBo)((Object)this.dataObjectService.save((Object)bo, new PersistenceOption[0])));
    }

    public EntityEmployment updateEmployment(EntityEmployment employment) throws RiceIllegalArgumentException, RiceIllegalStateException {
        this.incomingParamCheck(employment, "employment");
        if (StringUtils.isBlank((String)employment.getEntityId())) {
            throw new RiceIllegalStateException("EntityEmployment's entityId must be populated before update");
        }
        if (employment.getEmployeeType() == null || employment.getEmployeeStatus() == null || employment.getEntityAffiliation() == null) {
            throw new RiceIllegalStateException("EntityEmployment's status, type, and entity affiliation must be populated before update");
        }
        if (this.getEntityEmploymentBo(employment.getEntityId(), employment.getEmployeeType().getCode(), employment.getEmployeeStatus().getCode(), employment.getEntityAffiliation().getId()) == null) {
            throw new RiceIllegalStateException("the EntityEmployment to udpate does not exist: " + String.valueOf(employment));
        }
        EntityEmploymentBo bo = EntityEmploymentBo.from(employment);
        return EntityEmploymentBo.to((EntityEmploymentBo)((Object)this.dataObjectService.save((Object)bo, new PersistenceOption[0])));
    }

    public EntityEmployment inactivateEmployment(String id) throws RiceIllegalArgumentException, RiceIllegalStateException {
        this.incomingParamCheck(id, "id");
        EntityEmploymentBo bo = this.getEntityEmploymentBo(id);
        if (bo == null) {
            throw new RiceIllegalStateException("the EntityEmployment to inactivate does not exist");
        }
        bo.setActive(false);
        return EntityEmploymentBo.to((EntityEmploymentBo)((Object)this.dataObjectService.save((Object)bo, new PersistenceOption[0])));
    }

    protected EntityBioDemographicsBo getEntityBioDemographicsBo(String entityId) {
        if (StringUtils.isEmpty((String)entityId)) {
            return null;
        }
        return (EntityBioDemographicsBo)((Object)this.dataObjectService.find(EntityBioDemographicsBo.class, (Object)entityId));
    }

    public EntityBioDemographics addBioDemographicsToEntity(EntityBioDemographics bioDemographics) throws RiceIllegalArgumentException, RiceIllegalStateException {
        this.incomingParamCheck(bioDemographics, "bioDemographics");
        if (StringUtils.isBlank((String)bioDemographics.getEntityId())) {
            throw new RiceIllegalStateException("BioDemographics' entityId must be populated before creation");
        }
        if (this.getEntityBioDemographicsBo(bioDemographics.getEntityId()) != null) {
            throw new RiceIllegalStateException("the EntityBioDemographics to create already exists: " + String.valueOf(bioDemographics));
        }
        EntityBioDemographicsBo bo = EntityBioDemographicsBo.from(bioDemographics);
        return EntityBioDemographicsBo.to((EntityBioDemographicsBo)((Object)this.dataObjectService.save((Object)bo, new PersistenceOption[0])));
    }

    public EntityBioDemographics updateBioDemographics(EntityBioDemographics bioDemographics) throws RiceIllegalArgumentException, RiceIllegalStateException {
        this.incomingParamCheck(bioDemographics, "bioDemographics");
        if (this.getEntityBioDemographicsBo(bioDemographics.getEntityId()) == null) {
            throw new RiceIllegalStateException("the EntityBioDemographics to update does not exist: " + String.valueOf(bioDemographics));
        }
        EntityBioDemographicsBo bo = EntityBioDemographicsBo.from(bioDemographics);
        return EntityBioDemographicsBo.to((EntityBioDemographicsBo)((Object)this.dataObjectService.save((Object)bo, new PersistenceOption[0])));
    }

    protected void incomingParamCheck(Object object, String name) {
        if (object == null) {
            throw new RiceIllegalArgumentException(name + " was null");
        }
        if (object instanceof String && StringUtils.isBlank((String)((String)object))) {
            throw new RiceIllegalArgumentException(name + " was blank");
        }
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    public IdentityServiceDao getIdentityServiceDao() {
        return this.identityServiceDao;
    }

    public void setIdentityServiceDao(IdentityServiceDao identityServiceDao) {
        this.identityServiceDao = identityServiceDao;
    }
}

