/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kim.impl.identity.email;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

import org.eclipse.persistence.annotations.JoinFetch;
import org.eclipse.persistence.annotations.JoinFetchType;
import org.kuali.rice.kim.api.identity.email.EntityEmail;
import org.kuali.rice.krad.data.jpa.PortableSequenceGenerator;

/**
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
@Entity
@Table(name = "KRIM_ENTITY_EMAIL_T")
public class EntityEmailBo extends EntityEmailBase {

    private static final long serialVersionUID = 1L;

    @PortableSequenceGenerator(name = "KRIM_ENTITY_EMAIL_ID_S")
    @GeneratedValue(generator = "KRIM_ENTITY_EMAIL_ID_S")
    @Id
    @Column(name = "ENTITY_EMAIL_ID")
    private String id;

    @JoinFetch(value= JoinFetchType.OUTER)
    @ManyToOne(targetEntity = EntityEmailTypeBo.class, cascade = { CascadeType.REFRESH })
    @JoinColumn(name = "EMAIL_TYP_CD", referencedColumnName = "EMAIL_TYP_CD", insertable = false, updatable = false)
    private EntityEmailTypeBo emailType;

    public static EntityEmail to(EntityEmailBo bo) {
        if (bo == null) {
            return null;
        }
        return EntityEmail.Builder.create(bo).build();
    }

    /**
     * Creates a EntityEmailBo business object from an immutable representation of a EntityEmail.
     *
     * @param immutable an immutable EntityEmail
     * @return a EntityEmailBo
     */
    public static EntityEmailBo from(EntityEmail immutable) {
        if (immutable == null) {
            return null;
        }
        EntityEmailBo bo = new EntityEmailBo();
        bo.setId(immutable.getId());
        bo.setActive(immutable.isActive());
        bo.setEntityId(immutable.getEntityId());
        bo.setEntityTypeCode(immutable.getEntityTypeCode());
        if (immutable.getEmailType() != null) {
            bo.setEmailTypeCode(immutable.getEmailType().getCode());
        }
        bo.setEmailAddress(immutable.getEmailAddressUnmasked());
        bo.setEmailType(EntityEmailTypeBo.from(immutable.getEmailType()));
        bo.setDefaultValue(immutable.isDefaultValue());
        bo.setVersionNumber(immutable.getVersionNumber());
        bo.setObjectId(immutable.getObjectId());
        return bo;
    }

    @Override
    public EntityEmailTypeBo getEmailType() {
        return this.emailType;
    }

    public void setEmailType(EntityEmailTypeBo emailType) {
        this.emailType = emailType;
    }

    @Override
    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }
}
