/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.util;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BufferedLogger {
    private static final CharSequence getMessage(Object ... objs) {
        StringBuilder retval = new StringBuilder();
        for (Object obj : objs) {
            retval.append(obj);
        }
        return retval;
    }

    private static final Logger getLogger() {
        try {
            return LogManager.getLogger(Class.forName(new Throwable().getStackTrace()[2].getClassName()));
        }
        catch (Exception e) {
            return LogManager.getLogger(BufferedLogger.class);
        }
    }

    public static final Logger logger() {
        try {
            return LogManager.getLogger(Class.forName(new Throwable().getStackTrace()[1].getClassName()));
        }
        catch (Exception e) {
            return LogManager.getLogger(BufferedLogger.class);
        }
    }

    public static final void trace(Object ... objs) {
        Logger log = BufferedLogger.getLogger();
        if (log.isTraceEnabled()) {
            log.trace(BufferedLogger.getMessage(objs));
        }
    }

    public static final void debug(Object ... objs) {
        Logger log = BufferedLogger.getLogger();
        if (log.isDebugEnabled()) {
            log.debug(BufferedLogger.getMessage(objs));
        }
    }

    public static final void info(Object ... objs) {
        Logger log = BufferedLogger.getLogger();
        if (log.isInfoEnabled()) {
            log.info(BufferedLogger.getMessage(objs));
        }
    }

    public static final void warn(Object ... objs) {
        Logger log = BufferedLogger.getLogger();
        if (log.isEnabled(Level.WARN)) {
            log.warn(BufferedLogger.getMessage(objs));
        }
    }

    public static final void error(Object ... objs) {
        Logger log = BufferedLogger.getLogger();
        if (log.isEnabled(Level.ERROR)) {
            BufferedLogger.getLogger().error(BufferedLogger.getMessage(objs));
        }
    }

    public static final void fatal(Object ... objs) {
        Logger log = BufferedLogger.getLogger();
        if (log.isEnabled(Level.FATAL)) {
            log.fatal(BufferedLogger.getMessage(objs));
        }
    }
}

