/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kns.datadictionary.validation;

import java.beans.PropertyDescriptor;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.core.api.uif.RemotableAttributeError;
import org.kuali.rice.core.api.uif.RemotableAttributeField;
import org.kuali.rice.core.api.util.Truth;
import org.kuali.rice.core.api.util.type.TypeUtils;
import org.kuali.rice.core.web.format.Formatter;
import org.kuali.rice.kns.service.DictionaryValidationService;
import org.kuali.rice.kns.service.KNSServiceLocator;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.datadictionary.PrimitiveAttributeDefinition;
import org.kuali.rice.krad.datadictionary.RelationshipDefinition;
import org.kuali.rice.krad.service.DataDictionaryRemoteFieldService;
import org.kuali.rice.krad.service.DataDictionaryService;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.util.ErrorMessage;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.KRADUtils;
import org.kuali.rice.krad.util.ObjectUtils;
import org.springframework.util.AutoPopulatingList;

public abstract class AttributeValidatingTypeServiceBase {
    private static final Logger LOG = Logger.getLogger(AttributeValidatingTypeServiceBase.class);
    private static final String ANY_CHAR_PATTERN_S = ".*";
    private static final Pattern ANY_CHAR_PATTERN = Pattern.compile(".*");
    private DictionaryValidationService dictionaryValidationService;
    private DataDictionaryService dataDictionaryService;
    private DataDictionaryRemoteFieldService dataDictionaryRemoteFieldService;

    protected abstract List<TypeAttributeDefinition> getTypeAttributeDefinitions(String var1);

    protected abstract List<RemotableAttributeError> validateNonDataDictionaryAttribute(RemotableAttributeField var1, String var2, String var3);

    public List<RemotableAttributeError> validateAttributes(String typeId, Map<String, String> attributes) {
        if (StringUtils.isBlank((String)typeId)) {
            throw new RiceIllegalArgumentException("typeId was null or blank");
        }
        if (attributes == null) {
            throw new RiceIllegalArgumentException("attributes was null or blank");
        }
        List<TypeAttributeDefinition> definitions = this.getTypeAttributeDefinitions(typeId);
        Map<String, TypeAttributeDefinition> typeAttributeDefinitionMap = this.buildTypeAttributeDefinitionMapByName(definitions);
        ArrayList<RemotableAttributeError> validationErrors = new ArrayList<RemotableAttributeError>();
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            List<RemotableAttributeError> attributeErrors;
            TypeAttributeDefinition typeAttributeDefinition = typeAttributeDefinitionMap.get(entry.getKey());
            if (!ObjectUtils.isNotNull((Object)typeAttributeDefinition) || (attributeErrors = typeAttributeDefinition.getComponentName() == null ? this.validateNonDataDictionaryAttribute(typeAttributeDefinition.getField(), entry.getKey(), entry.getValue()) : this.validateDataDictionaryAttribute(typeAttributeDefinition, entry.getKey(), entry.getValue())) == null) continue;
            validationErrors.addAll(attributeErrors);
        }
        List<RemotableAttributeError> referenceCheckErrors = this.validateReferencesExistAndActive(typeAttributeDefinitionMap, attributes, validationErrors);
        validationErrors.addAll(referenceCheckErrors);
        return Collections.unmodifiableList(validationErrors);
    }

    private Map<String, TypeAttributeDefinition> buildTypeAttributeDefinitionMapByName(List<TypeAttributeDefinition> definitions) {
        Map<String, TypeAttributeDefinition> typeAttributeDefinitionMap;
        if (definitions == null || definitions.size() == 0) {
            typeAttributeDefinitionMap = Collections.emptyMap();
        } else {
            typeAttributeDefinitionMap = new HashMap<String, TypeAttributeDefinition>();
            for (TypeAttributeDefinition definition : definitions) {
                typeAttributeDefinitionMap.put(definition.getName(), definition);
            }
        }
        return typeAttributeDefinitionMap;
    }

    protected List<RemotableAttributeError> validateReferencesExistAndActive(Map<String, TypeAttributeDefinition> typeAttributeDefinitionMap, Map<String, String> attributes, List<RemotableAttributeError> previousValidationErrors) {
        HashMap<String, BusinessObject> componentClassInstances = new HashMap<String, BusinessObject>();
        ArrayList<RemotableAttributeError> errors = new ArrayList<RemotableAttributeError>();
        for (String string : attributes.keySet()) {
            TypeAttributeDefinition attr = typeAttributeDefinitionMap.get(string);
            if (!ObjectUtils.isNotNull((Object)attr) || !StringUtils.isNotBlank((String)attr.getComponentName()) || componentClassInstances.containsKey(attr.getComponentName())) continue;
            try {
                Class<?> componentClass = Class.forName(attr.getComponentName());
                if (!BusinessObject.class.isAssignableFrom(componentClass)) {
                    LOG.warn((Object)("Class " + componentClass.getName() + " does not implement BusinessObject.  Unable to perform reference existence and active validation"));
                    continue;
                }
                BusinessObject componentInstance = (BusinessObject)componentClass.newInstance();
                componentClassInstances.put(attr.getComponentName(), componentInstance);
            }
            catch (Exception e) {
                LOG.error((Object)("Unable to instantiate class for attribute: " + string), (Throwable)e);
            }
        }
        for (Map.Entry entry : attributes.entrySet()) {
            if (RemotableAttributeError.containsAttribute((String)((String)entry.getKey()), previousValidationErrors)) continue;
            for (BusinessObject componentInstance : componentClassInstances.values()) {
                try {
                    ObjectUtils.setObjectProperty((Object)componentInstance, (String)((String)entry.getKey()), entry.getValue());
                }
                catch (NoSuchMethodException e) {
                }
                catch (Exception e) {
                    LOG.error((Object)("Unable to set object property class: " + componentInstance.getClass().getName() + " property: " + (String)entry.getKey()), (Throwable)e);
                }
            }
        }
        for (Map.Entry entry : componentClassInstances.entrySet()) {
            List relationships = this.getDataDictionaryService().getDataDictionary().getBusinessObjectEntry((String)entry.getKey()).getRelationships();
            if (relationships == null) continue;
            for (RelationshipDefinition relationshipDefinition : relationships) {
                List<String> extractedErrors;
                List primitiveAttributes = relationshipDefinition.getPrimitiveAttributes();
                String attributeToHighlightOnFail = ((PrimitiveAttributeDefinition)primitiveAttributes.get(primitiveAttributes.size() - 1)).getSourceName();
                if (!attributes.containsKey(attributeToHighlightOnFail)) continue;
                TypeAttributeDefinition attr = typeAttributeDefinitionMap.get(attributeToHighlightOnFail);
                if (attr != null) {
                    String attributeDisplayLabel = StringUtils.isNotBlank((String)attr.getComponentName()) ? this.getDataDictionaryService().getAttributeLabel(attr.getComponentName(), attributeToHighlightOnFail) : attr.getLabel();
                    this.getDictionaryValidationService().validateReferenceExistsAndIsActive((BusinessObject)entry.getValue(), relationshipDefinition.getObjectAttributeName(), attributeToHighlightOnFail, attributeDisplayLabel);
                }
                if (!CollectionUtils.isNotEmpty(extractedErrors = this.extractErrorsFromGlobalVariablesErrorMap(attributeToHighlightOnFail))) continue;
                errors.add(RemotableAttributeError.Builder.create((String)attributeToHighlightOnFail, extractedErrors).build());
            }
        }
        return errors;
    }

    protected static String getAttributeErrorLabel(RemotableAttributeField definition) {
        String longAttributeLabel = definition.getLongLabel();
        String shortAttributeLabel = definition.getShortLabel();
        return longAttributeLabel + " (" + shortAttributeLabel + ")";
    }

    protected String createErrorString(String errorKey, String ... params) {
        String errorString = this.getConfigurationService().getPropertyValueAsString(errorKey);
        if (StringUtils.isEmpty((String)errorString)) {
            StringBuilder s = new StringBuilder(errorKey).append(':');
            if (params != null) {
                for (String p : params) {
                    if (p == null) continue;
                    s.append(p);
                    s.append(';');
                }
            }
            errorString = s.toString();
        } else {
            errorString = MessageFormat.format(errorString, params);
        }
        return errorString;
    }

    protected List<RemotableAttributeError> validatePrimitiveAttributeFromDescriptor(TypeAttributeDefinition typeAttributeDefinition, String componentName, Object object, PropertyDescriptor propertyDescriptor) {
        ArrayList<RemotableAttributeError> errors = new ArrayList<RemotableAttributeError>();
        if (null != propertyDescriptor && this.getDataDictionaryService().isAttributeDefined(componentName, propertyDescriptor.getName()).booleanValue()) {
            Object value = ObjectUtils.getPropertyValue((Object)object, (String)propertyDescriptor.getName());
            Class<?> propertyType = propertyDescriptor.getPropertyType();
            if (TypeUtils.isStringClass(propertyType) || TypeUtils.isIntegralClass(propertyType) || TypeUtils.isDecimalClass(propertyType) || TypeUtils.isTemporalClass(propertyType)) {
                if (value != null && StringUtils.isNotBlank((String)value.toString())) {
                    if (!TypeUtils.isTemporalClass(propertyType)) {
                        errors.addAll(this.validateAttributeFormat(typeAttributeDefinition.getField(), componentName, propertyDescriptor.getName(), value.toString(), propertyDescriptor.getName()));
                    }
                } else {
                    errors.addAll(this.validateAttributeRequired(typeAttributeDefinition.getField(), componentName, propertyDescriptor.getName(), value, propertyDescriptor.getName()));
                }
            }
        }
        return errors;
    }

    protected List<RemotableAttributeError> validateAttributeRequired(RemotableAttributeField field, String objectClassName, String attributeName, Object attributeValue, String errorKey) {
        boolean required;
        ArrayList<RemotableAttributeError> errors = new ArrayList<RemotableAttributeError>();
        if ((attributeValue == null || attributeValue instanceof String && StringUtils.isBlank((String)((String)attributeValue))) && (required = field.isRequired())) {
            String errorLabel = AttributeValidatingTypeServiceBase.getAttributeErrorLabel(field);
            errors.add(RemotableAttributeError.Builder.create((String)errorKey, (String[])new String[]{this.createErrorString("error.required", errorLabel)}).build());
        }
        return errors;
    }

    protected Pattern getAttributeValidatingExpression(RemotableAttributeField field) {
        if (field == null || StringUtils.isBlank((String)field.getRegexConstraint())) {
            return ANY_CHAR_PATTERN;
        }
        return Pattern.compile(field.getRegexConstraint());
    }

    protected Formatter getAttributeFormatter(RemotableAttributeField field) {
        if (field.getDataType() == null) {
            return null;
        }
        return Formatter.getFormatter((Class)field.getDataType().getType());
    }

    protected List<RemotableAttributeError> validateAttributeFormat(RemotableAttributeField field, String objectClassName, String attributeName, String attributeValue, String errorKey) {
        ArrayList<RemotableAttributeError> errors = new ArrayList<RemotableAttributeError>();
        String errorLabel = AttributeValidatingTypeServiceBase.getAttributeErrorLabel(field);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("(bo, attributeName, attributeValue) = (" + objectClassName + "," + attributeName + "," + attributeValue + ")"));
        }
        if (StringUtils.isNotBlank((String)attributeValue)) {
            Double max;
            Double min;
            Integer maxLength = field.getMaxLength();
            if (maxLength != null && maxLength < attributeValue.length()) {
                errors.add(RemotableAttributeError.Builder.create((String)errorKey, (String[])new String[]{this.createErrorString("error.maxLength", errorLabel, maxLength.toString())}).build());
                return errors;
            }
            Integer minLength = field.getMinLength();
            if (minLength != null && minLength > attributeValue.length()) {
                errors.add(RemotableAttributeError.Builder.create((String)errorKey, (String[])new String[]{this.createErrorString("error.minLength", errorLabel, minLength.toString())}).build());
                return errors;
            }
            Pattern validationExpression = this.getAttributeValidatingExpression(field);
            if (!ANY_CHAR_PATTERN_S.equals(validationExpression.pattern())) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("(bo, attributeName, validationExpression) = (" + objectClassName + "," + attributeName + "," + validationExpression + ")"));
                }
                if (!validationExpression.matcher(attributeValue).matches()) {
                    boolean isError = true;
                    Formatter formatter = this.getAttributeFormatter(field);
                    if (formatter != null) {
                        Object o = formatter.format((Object)attributeValue);
                        boolean bl = isError = !validationExpression.matcher(String.valueOf(o)).matches();
                    }
                    if (isError) {
                        errors.add(RemotableAttributeError.Builder.create((String)errorKey, (String[])new String[]{this.createErrorString(field.getRegexContraintMsg(), errorLabel)}).build());
                    }
                    return errors;
                }
            }
            if ((min = field.getMinValue()) != null) {
                try {
                    if (Double.parseDouble(attributeValue) < min) {
                        errors.add(RemotableAttributeError.Builder.create((String)errorKey, (String[])new String[]{this.createErrorString("error.inclusiveMin", errorLabel, min.toString())}).build());
                        return errors;
                    }
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            if ((max = field.getMaxValue()) != null) {
                try {
                    if (Double.parseDouble(attributeValue) > max) {
                        errors.add(RemotableAttributeError.Builder.create((String)errorKey, (String[])new String[]{this.createErrorString("error.inclusiveMax", errorLabel, max.toString())}).build());
                        return errors;
                    }
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
        }
        return errors;
    }

    protected List<String> extractErrorsFromGlobalVariablesErrorMap(String attributeName) {
        AutoPopulatingList results = GlobalVariables.getMessageMap().getErrorMessagesForProperty(attributeName);
        ArrayList<String> errors = new ArrayList<String>();
        if (results instanceof String) {
            errors.add(this.createErrorString((String)results, new String[0]));
        } else if (results != null) {
            if (results instanceof List) {
                List errorList = (List)results;
                for (Object msg : errorList) {
                    ErrorMessage errorMessage = (ErrorMessage)msg;
                    errors.add(this.createErrorString(errorMessage.getErrorKey(), errorMessage.getMessageParameters()));
                }
            } else {
                String[] temp;
                for (String string : temp = (String[])results) {
                    errors.add(this.createErrorString(string, new String[0]));
                }
            }
        }
        GlobalVariables.getMessageMap().removeAllErrorMessagesForProperty(attributeName);
        return errors;
    }

    protected List<RemotableAttributeError> validateDataDictionaryAttribute(TypeAttributeDefinition typeAttributeDefinition, String attributeName, String value) {
        try {
            PropertyDescriptor propertyDescriptor;
            Object componentObject = Class.forName(typeAttributeDefinition.getComponentName()).newInstance();
            if (attributeName != null && (propertyDescriptor = PropertyUtils.getPropertyDescriptor(componentObject, (String)attributeName)) != null) {
                Object attributeValue = this.getAttributeValue(propertyDescriptor, value);
                propertyDescriptor.getWriteMethod().invoke(componentObject, attributeValue);
                return this.validatePrimitiveAttributeFromDescriptor(typeAttributeDefinition, typeAttributeDefinition.getComponentName(), componentObject, propertyDescriptor);
            }
        }
        catch (Exception e) {
            throw new TypeAttributeValidationException(e);
        }
        return Collections.emptyList();
    }

    private Object getAttributeValue(PropertyDescriptor propertyDescriptor, String attributeValue) {
        Object attributeValueObject = null;
        if (propertyDescriptor != null && attributeValue != null) {
            Class<?> propertyType = propertyDescriptor.getPropertyType();
            if (String.class.equals(propertyType)) {
                attributeValueObject = attributeValue;
            } else if (Boolean.class.equals(propertyType) || Boolean.TYPE.equals(propertyType)) {
                attributeValueObject = Truth.strToBooleanIgnoreCase((String)attributeValue);
            } else {
                attributeValueObject = KRADUtils.createObject(propertyType, (Class[])new Class[]{String.class}, (Object[])new Object[]{attributeValue});
                if (attributeValueObject == null) {
                    attributeValueObject = attributeValue;
                }
            }
        }
        return attributeValueObject;
    }

    protected DictionaryValidationService getDictionaryValidationService() {
        return DictionaryValidationServiceHolder.dictionaryValidationService;
    }

    protected DataDictionaryService getDataDictionaryService() {
        return DataDictionaryServiceHolder.dataDictionaryService;
    }

    protected DataDictionaryRemoteFieldService getDataDictionaryRemoteFieldService() {
        return DataDictionaryRemoteFieldServiceHolder.dataDictionaryRemoteFieldService;
    }

    protected ConfigurationService getConfigurationService() {
        return ConfigurationServiceHolder.configurationService;
    }

    protected static class TypeAttributeDefinition {
        private final RemotableAttributeField field;
        private final String name;
        private final String componentName;
        private final String label;
        private final Map<String, String> properties;

        public TypeAttributeDefinition(RemotableAttributeField field, String name, String componentName, String label, Map<String, String> properties) {
            if (field == null) {
                throw new RiceIllegalArgumentException("field must not be null");
            }
            if (StringUtils.isEmpty((String)name)) {
                throw new RiceIllegalArgumentException("name must not be empty or null");
            }
            this.field = field;
            this.name = name;
            this.componentName = componentName;
            this.label = label;
            if (properties == null || properties.isEmpty()) {
                this.properties = Collections.emptyMap();
            } else {
                properties = new HashMap<String, String>(properties);
                this.properties = Collections.unmodifiableMap(properties);
            }
        }

        public RemotableAttributeField getField() {
            return this.field;
        }

        public String getName() {
            return this.name;
        }

        public String getComponentName() {
            return this.componentName;
        }

        public String getLabel() {
            return this.label;
        }

        public Map<String, String> getProperties() {
            return this.properties;
        }
    }

    protected static class TypeAttributeValidationException
    extends RuntimeException {
        private static final long serialVersionUID = 8220618846321607801L;

        protected TypeAttributeValidationException(String message) {
            super(message);
        }

        protected TypeAttributeValidationException(Throwable cause) {
            super(cause);
        }
    }

    private static class ConfigurationServiceHolder {
        public static ConfigurationService configurationService = CoreApiServiceLocator.getKualiConfigurationService();

        private ConfigurationServiceHolder() {
        }
    }

    private static class DataDictionaryRemoteFieldServiceHolder {
        public static DataDictionaryRemoteFieldService dataDictionaryRemoteFieldService = KRADServiceLocatorWeb.getDataDictionaryRemoteFieldService();

        private DataDictionaryRemoteFieldServiceHolder() {
        }
    }

    private static class DataDictionaryServiceHolder {
        public static DataDictionaryService dataDictionaryService = KRADServiceLocatorWeb.getDataDictionaryService();

        private DataDictionaryServiceHolder() {
        }
    }

    private static class DictionaryValidationServiceHolder {
        public static DictionaryValidationService dictionaryValidationService = KNSServiceLocator.getKNSDictionaryValidationService();

        private DictionaryValidationServiceHolder() {
        }
    }
}

