/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kns.web.struts.action;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.rice.kns.web.struts.form.KualiExceptionIncidentForm;
import org.kuali.rice.krad.exception.KualiExceptionIncident;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.KualiExceptionIncidentService;

public class KualiExceptionHandlerAction
extends Action {
    private static final Logger LOG = Logger.getLogger(KualiExceptionHandlerAction.class);

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.executeException(mapping, form, request, response);
    }

    public ActionForward executeException(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (LOG.isDebugEnabled()) {
            String lm = String.format("ENTRY %s%n%s", form.getClass().getSimpleName(), request.getRequestURI());
            LOG.debug((Object)lm);
        }
        Exception e = (Exception)request.getAttribute("org.apache.struts.action.EXCEPTION");
        ActionForward returnForward = null;
        if (e == null) {
            if (form instanceof KualiExceptionIncidentForm) {
                KualiExceptionIncidentForm formObject = (KualiExceptionIncidentForm)form;
                if (!formObject.isCancel()) {
                    KualiExceptionIncidentService reporterService = KRADServiceLocatorWeb.getKualiExceptionIncidentService();
                    HashMap<String, String> reducedMap = new HashMap<String, String>();
                    Enumeration names = request.getParameterNames();
                    while (names.hasMoreElements()) {
                        String name = (String)names.nextElement();
                        reducedMap.put(name, request.getParameter(name));
                    }
                    KualiExceptionIncident exceptionIncident = reporterService.getExceptionIncident(reducedMap);
                    reporterService.report(exceptionIncident);
                } else {
                    ActionForward cancelForward = mapping.findForward("cancel");
                    if (cancelForward == null) {
                        cancelForward = returnForward;
                    } else {
                        returnForward = cancelForward;
                    }
                }
            }
        } else {
            returnForward = this.processException(mapping, form, request, e);
        }
        if (returnForward == null) {
            returnForward = mapping.findForward("close");
        }
        if (LOG.isDebugEnabled()) {
            String lm = String.format("EXIT %s", returnForward == null ? "null" : returnForward.getPath());
            LOG.debug((Object)lm);
        }
        return returnForward;
    }

    protected ActionForward processException(ActionMapping mapping, ActionForm form, HttpServletRequest request, Exception exception) throws Exception {
        KualiExceptionIncidentService reporterService = KRADServiceLocatorWeb.getKualiExceptionIncidentService();
        Map properties = (Map)request.getAttribute("exceptionProperties");
        KualiExceptionIncident ei = reporterService.getExceptionIncident(exception, properties);
        request.setAttribute(KualiExceptionHandlerAction.class.getSimpleName(), (Object)ei.toProperties());
        return mapping.findForward("basic");
    }
}

