/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.framework.persistence.platform;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.accesslayer.LookupException;
import org.kuali.rice.core.framework.persistence.platform.ANSISqlDatabasePlatform;

public class MySQLDatabasePlatform
extends ANSISqlDatabasePlatform {
    private static final Pattern APOS_PAT = Pattern.compile("'");
    private static final Pattern BSLASH_PAT = Pattern.compile(Matcher.quoteReplacement("\\"));

    public String getLockRouteHeaderQuerySQL(String documentId, boolean wait) {
        return "SELECT DOC_HDR_ID FROM KREW_DOC_HDR_T WHERE DOC_HDR_ID=? FOR UPDATE";
    }

    public String getStrToDateFunction() {
        return "STR_TO_DATE";
    }

    public String getCurTimeFunction() {
        return "NOW()";
    }

    public String applyLimitSql(Integer limit) {
        if (limit != null) {
            return " 1 LIMIT 0," + limit;
        }
        return null;
    }

    @Override
    protected Long getNextValSqlJdbc(String sequenceName, Connection connection) {
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.prepareStatement("INSERT INTO " + sequenceName + " VALUES (NULL);");
            statement.executeUpdate();
            statement = connection.prepareStatement("SELECT LAST_INSERT_ID()");
            resultSet = statement.executeQuery();
            if (!resultSet.next()) {
                throw new RuntimeException("Error retrieving next option id for action list from sequence.");
            }
            Long l = new Long(resultSet.getLong(1));
            return l;
        }
        catch (SQLException e) {
            throw new RuntimeException("Error retrieving next option id for action list from sequence.", e);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {}
            }
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException e) {}
            }
        }
    }

    @Override
    protected Long getNextValSqlOjb(String sequenceName, PersistenceBroker persistenceBroker) {
        try {
            Connection connection = persistenceBroker.serviceConnectionManager().getConnection();
            return this.getNextValSqlJdbc(sequenceName, connection);
        }
        catch (LookupException e) {
            throw new RuntimeException("Error retrieving next option id for action list from sequence.", e);
        }
    }

    public boolean isSITCacheSupported() {
        return false;
    }

    @Override
    public String toString() {
        return "[MySQLDatabasePlatform]";
    }

    public String getSelectForUpdateSuffix(long waitMillis) {
        return "for update";
    }

    public String getDateFormatString(String dateFormatString) {
        String newString = "";
        if ("yyyy-mm-dd".equalsIgnoreCase(dateFormatString)) {
            newString = "'%Y-%m-%d'";
        } else if ("DD/MM/YYYY HH12:MI:SS PM".equalsIgnoreCase(dateFormatString)) {
            newString = "'%d/%m/%Y %r'";
        }
        return newString;
    }

    public String escapeString(String sqlString) {
        return sqlString != null ? BSLASH_PAT.matcher(APOS_PAT.matcher(sqlString).replaceAll("''")).replaceAll(Matcher.quoteReplacement("\\\\")) : null;
    }
}

