/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kns.lookup;

import java.io.IOException;
import java.io.Writer;

import javax.servlet.jsp.JspException;

import org.displaytag.export.XmlView;
import org.displaytag.model.TableModel;
import org.kuali.rice.kns.lookup.ExportViewHelper;
import org.kuali.rice.krad.util.KRADConstants;

/**
 * This class allows for plugging in custom XML export into the Display Tag library.
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 *
 * @deprecated KNS Struts deprecated, use KRAD and the Spring MVC framework.
 */
@Deprecated
public class CustomXmlExportView extends XmlView {

	private ExportViewHelper helper;
	
	@Override
	public void setParameters(TableModel tableModel, boolean exportFullList, boolean includeHeader, boolean decorateValues) {
		this.helper = new ExportViewHelper(tableModel);
		super.setParameters(tableModel, exportFullList, includeHeader, decorateValues);
	}
	
	@Override
	public void doExport(Writer writer) throws IOException, JspException {
		if (!helper.attemptCustomExport(writer, KRADConstants.XML_FORMAT)) {
           // KULRICE-12281: Turn off the ability to export results from the certain lookups
            helper.checkPermission();
			super.doExport(writer);
		}
	}

}
