/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.dao;

import org.kuali.rice.krad.util.LegacyDataFramework;

import java.util.Collection;
import java.util.Map;

/**
 * Defines basic methods that Lookup Dao's must provide
 * @deprecated use new KRAD Data framework {@link org.kuali.rice.krad.data.DataObjectService}
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
@Deprecated
@LegacyDataFramework
public interface LookupDao {
    /**
     * Retrieves a collection of objects for the businessObjectClass based on the other information passed into the
     * method.
     *
     * @param businessObjectClass - business object being queried on
     * @param formProps - map of form properties
     * @param unbounded - indicates if the search should be unbounded
     * @param usePrimaryKeyValuesOnly - indicates if only primary key values should be used
     * @return Object returned from the search
     */
    @Deprecated
	public <T extends Object> Collection<T> findCollectionBySearchHelper(
			Class<T> businessObjectClass, Map<String, String> formProps, boolean unbounded,
			boolean usePrimaryKeyValuesOnly);

    /**
     * Retrieves a collection of objects for the businessObjectClass based on the other information passed into the
     * method.
     *
     * @param businessObjectClass - business object being queried on
     * @param formProps - map of form properties
     * @param unbounded - indicates if the search should be unbounded
     * @param usePrimaryKeyValuesOnly - indicates if only primary key values should be used
     * @param searchResultsLimit - used to limit the number of items returned
     * @return Object returned from the search
     */
    @Deprecated
    public <T extends Object> Collection<T> findCollectionBySearchHelper(
            Class<T> businessObjectClass, Map<String, String> formProps, boolean unbounded,
            boolean usePrimaryKeyValuesOnly, Integer searchResultsLimit);

	/**
	 * Retrieves a Object based on the search criteria, which should uniquely
	 * identify a record.
	 * 
	 * @return Object returned from the search
	 */
    @Deprecated
	public <T extends Object> T findObjectByMap(Class<T> type, Map<String, String> formProps);

	/**
	 * Returns a count of objects based on the given search parameters.
	 * 
	 * @return Long returned from the search
	 */
	public Long findCountByMap(Object example, Map<String, String> formProps);

	/**
	 * Create OJB criteria based on business object, search field and value
	 * 
	 * @return true if the criteria is created successfully; otherwise, return
	 *         false
	 */
    @Deprecated
	public boolean createCriteria(Object example, String searchValue,
			String propertyName, Object criteria);

	/**
	 * Create OJB criteria based on business object, search field and value
	 * 
	 * @return true if the criteria is created successfully; otherwise, return
	 *         false
	 */
    @Deprecated
	public boolean createCriteria(Object example, String searchValue,
			String propertyName, boolean caseInsensitive,
			boolean treatWildcardsAndOperatorsAsLiteral, Object criteria);
}
