/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kns.datadictionary;

import org.apache.commons.lang.StringUtils;
import org.kuali.rice.kns.datadictionary.FieldDefinitionI;
import org.kuali.rice.kns.service.BusinessObjectMetaDataService;
import org.kuali.rice.kns.service.KNSServiceLocator;
import org.kuali.rice.krad.datadictionary.DataDictionaryDefinitionBase;
import org.kuali.rice.krad.datadictionary.DataDictionaryPropertyUtils;
import org.kuali.rice.krad.datadictionary.RelationshipDefinition;
import org.kuali.rice.krad.datadictionary.exception.AttributeValidationException;
import org.kuali.rice.krad.datadictionary.exception.ClassValidationException;
import org.kuali.rice.krad.datadictionary.mask.Mask;
import org.kuali.rice.krad.valuefinder.ValueFinder;

@Deprecated
public class FieldDefinition
extends DataDictionaryDefinitionBase
implements FieldDefinitionI {
    private static final long serialVersionUID = -3426603523049661524L;
    protected String attributeName;
    protected boolean required = false;
    protected boolean forceInquiry = false;
    protected boolean noInquiry = false;
    protected boolean noDirectInquiry = false;
    protected boolean forceLookup = false;
    protected boolean noLookup = false;
    protected boolean useShortLabel = false;
    protected String defaultValue;
    protected Class<? extends ValueFinder> defaultValueFinderClass;
    protected String quickfinderParameterString;
    protected Class<? extends ValueFinder> quickfinderParameterStringBuilderClass;
    protected Integer maxLength = null;
    protected String displayEditMode;
    protected Mask displayMask;
    protected boolean hidden = false;
    protected boolean readOnly = false;
    protected boolean treatWildcardsAndOperatorsAsLiteral = false;
    protected String alternateDisplayAttributeName;
    protected String additionalDisplayAttributeName;
    protected boolean triggerOnChange;
    protected boolean total = false;

    public String getAttributeName() {
        return this.attributeName;
    }

    public void setAttributeName(String attributeName) {
        if (StringUtils.isBlank((String)attributeName)) {
            throw new IllegalArgumentException("invalid (blank) attributeName");
        }
        this.attributeName = attributeName;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public boolean isForceInquiry() {
        return this.forceInquiry;
    }

    public void setForceInquiry(boolean forceInquiry) {
        this.forceInquiry = forceInquiry;
    }

    public boolean isForceLookup() {
        return this.forceLookup;
    }

    public void setForceLookup(boolean forceLookup) {
        this.forceLookup = forceLookup;
    }

    public boolean isNoInquiry() {
        return this.noInquiry;
    }

    public boolean isNoDirectInquiry() {
        return this.noDirectInquiry;
    }

    public void setNoInquiry(boolean noInquiry) {
        this.noInquiry = noInquiry;
    }

    public void setNoDirectInquiry(boolean noDirectInquiry) {
        this.noDirectInquiry = noDirectInquiry;
    }

    public boolean isNoLookup() {
        return this.noLookup;
    }

    public void setNoLookup(boolean noLookup) {
        this.noLookup = noLookup;
    }

    public boolean isUseShortLabel() {
        return this.useShortLabel;
    }

    public void setUseShortLabel(boolean useShortLabel) {
        this.useShortLabel = useShortLabel;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getQuickfinderParameterString() {
        return this.quickfinderParameterString;
    }

    public void setQuickfinderParameterString(String quickfinderParameterString) {
        this.quickfinderParameterString = quickfinderParameterString;
    }

    public Class<? extends ValueFinder> getQuickfinderParameterStringBuilderClass() {
        return this.quickfinderParameterStringBuilderClass;
    }

    public void setQuickfinderParameterStringBuilderClass(Class<? extends ValueFinder> quickfinderParameterStringBuilderClass) {
        if (quickfinderParameterStringBuilderClass == null) {
            throw new IllegalArgumentException("invalid (null) quickfinderParameterStringBuilderClass");
        }
        this.quickfinderParameterStringBuilderClass = quickfinderParameterStringBuilderClass;
    }

    public void completeValidation(Class rootBusinessObjectClass, Class otherBusinessObjectClass) {
        BusinessObjectMetaDataService boMetadataService = KNSServiceLocator.getBusinessObjectMetaDataService();
        if (!DataDictionaryPropertyUtils.isPropertyOf((Class)rootBusinessObjectClass, (String)this.getAttributeName())) {
            throw new AttributeValidationException("unable to find attribute '" + this.attributeName + "' in rootBusinessObjectClass '" + rootBusinessObjectClass.getName() + "' ()");
        }
        if (StringUtils.isNotBlank((String)this.getAlternateDisplayAttributeName()) && !DataDictionaryPropertyUtils.isPropertyOf((Class)rootBusinessObjectClass, (String)this.getAlternateDisplayAttributeName())) {
            throw new AttributeValidationException("unable to find attribute named '" + this.getName() + "' in rootBusinessObjectClass '" + rootBusinessObjectClass.getName() + "' ()");
        }
        if (StringUtils.isNotBlank((String)this.getAdditionalDisplayAttributeName()) && !DataDictionaryPropertyUtils.isPropertyOf((Class)rootBusinessObjectClass, (String)this.getAdditionalDisplayAttributeName())) {
            throw new AttributeValidationException("unable to find attribute named '" + this.getName() + "' in rootBusinessObjectClass '" + rootBusinessObjectClass.getName() + "' ()");
        }
        if (this.defaultValueFinderClass != null && this.defaultValue != null) {
            throw new AttributeValidationException("Both defaultValue and defaultValueFinderClass can not be specified on attribute " + this.getAttributeName() + " in rootBusinessObjectClass " + rootBusinessObjectClass.getName());
        }
        this.validateQuickfinderParameters(rootBusinessObjectClass, boMetadataService);
        if (this.forceInquiry && this.noInquiry) {
            throw new AttributeValidationException("Both forceInquiry and noInquiry can not be set to true on attribute " + this.getAttributeName() + " in rootBusinessObjectClass " + rootBusinessObjectClass.getName());
        }
        if (this.forceLookup && this.noLookup) {
            throw new AttributeValidationException("Both forceLookup and noLookup can not be set to true on attribute " + this.getAttributeName() + " in rootBusinessObjectClass " + rootBusinessObjectClass.getName());
        }
    }

    private void validateQuickfinderParameters(Class rootBusinessObjectClass, BusinessObjectMetaDataService boMetadataService) {
        if (this.quickfinderParameterStringBuilderClass != null && this.quickfinderParameterString != null) {
            throw new AttributeValidationException("Both quickfinderParameterString and quickfinderParameterStringBuilderClass can not be specified on attribute " + this.getAttributeName() + " in rootBusinessObjectClass " + rootBusinessObjectClass.getName());
        }
        Object quickfinderParameterStringSource = "quickfinderParameterString";
        if (this.quickfinderParameterStringBuilderClass != null) {
            try {
                quickfinderParameterStringSource = "quickfinderParameterStringBuilderClass " + this.quickfinderParameterStringBuilderClass.getCanonicalName();
                this.quickfinderParameterString = this.quickfinderParameterStringBuilderClass.newInstance().getValue();
            }
            catch (InstantiationException e) {
                throw new ClassValidationException("unable to create new instance of " + (String)quickfinderParameterStringSource + " while validating rootBusinessObjectClass '" + rootBusinessObjectClass.getName() + "'", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new ClassValidationException("unable to create new instance of " + (String)quickfinderParameterStringSource + " while validating rootBusinessObjectClass '" + rootBusinessObjectClass.getName() + "'", (Throwable)e);
            }
        }
        if (!StringUtils.isEmpty((String)this.quickfinderParameterString)) {
            for (String quickfinderParam : this.quickfinderParameterString.split(",")) {
                if (quickfinderParam.contains("=")) {
                    String propertyName = quickfinderParam.split("=")[0];
                    RelationshipDefinition relationship = boMetadataService.getBusinessObjectRelationshipDefinition(rootBusinessObjectClass, this.attributeName);
                    Class targetClass = relationship.getTargetClass();
                    if (DataDictionaryPropertyUtils.isPropertyOf((Class)targetClass, (String)propertyName)) continue;
                    throw new ClassValidationException("malformed parameter string  '" + this.quickfinderParameterString + "' from " + (String)quickfinderParameterStringSource + ", '" + propertyName + "' is not a property of " + String.valueOf(targetClass) + "' for rootBusinessObjectClass '" + rootBusinessObjectClass.getName() + "'");
                }
                throw new ClassValidationException("malformed parameter string '" + this.quickfinderParameterString + "' from " + (String)quickfinderParameterStringSource + " for rootBusinessObjectClass '" + rootBusinessObjectClass.getName() + "'");
            }
        }
    }

    public String toString() {
        return "FieldDefinition for attribute " + this.getAttributeName();
    }

    @Override
    public String getName() {
        return this.attributeName;
    }

    public String getDisplayEditMode() {
        return this.displayEditMode;
    }

    public void setDisplayEditMode(String displayEditMode) {
        this.displayEditMode = displayEditMode;
    }

    public Mask getDisplayMask() {
        return this.displayMask;
    }

    public void setDisplayMask(Mask displayMask) {
        this.displayMask = displayMask;
    }

    @Override
    public boolean isReadOnlyAfterAdd() {
        return false;
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(Integer maxLength) {
        this.maxLength = maxLength;
    }

    public Class<? extends ValueFinder> getDefaultValueFinderClass() {
        return this.defaultValueFinderClass;
    }

    public void setDefaultValueFinderClass(Class<? extends ValueFinder> defaultValueFinderClass) {
        if (defaultValueFinderClass == null) {
            throw new IllegalArgumentException("invalid (null) defaultValueFinderClass");
        }
        this.defaultValueFinderClass = defaultValueFinderClass;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean isTriggerOnChange() {
        return this.triggerOnChange;
    }

    public void setTriggerOnChange(boolean triggerOnChange) {
        this.triggerOnChange = triggerOnChange;
    }

    public boolean isTreatWildcardsAndOperatorsAsLiteral() {
        return this.treatWildcardsAndOperatorsAsLiteral;
    }

    public void setTreatWildcardsAndOperatorsAsLiteral(boolean treatWildcardsAndOperatorsAsLiteralOnLookups) {
        this.treatWildcardsAndOperatorsAsLiteral = treatWildcardsAndOperatorsAsLiteralOnLookups;
    }

    @Override
    public String getAlternateDisplayAttributeName() {
        return this.alternateDisplayAttributeName;
    }

    public void setAlternateDisplayAttributeName(String alternateDisplayAttributeName) {
        this.alternateDisplayAttributeName = alternateDisplayAttributeName;
    }

    @Override
    public String getAdditionalDisplayAttributeName() {
        return this.additionalDisplayAttributeName;
    }

    public void setAdditionalDisplayAttributeName(String additionalDisplayAttributeName) {
        this.additionalDisplayAttributeName = additionalDisplayAttributeName;
    }

    public boolean isTotal() {
        return this.total;
    }

    public void setTotal(boolean total) {
        this.total = total;
    }
}

