/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kns.datadictionary.control;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.kuali.rice.core.api.util.ClassLoaderUtils;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.datadictionary.DataDictionaryDefinitionBase;
import org.kuali.rice.krad.datadictionary.control.ControlDefinition;
import org.kuali.rice.krad.datadictionary.exception.ClassValidationException;
import org.kuali.rice.krad.datadictionary.exception.CompletionException;
import org.kuali.rice.krad.keyvalues.KeyValuesFinder;
import org.springframework.util.CollectionUtils;

@Deprecated
public abstract class ControlDefinitionBase
extends DataDictionaryDefinitionBase
implements ControlDefinition {
    private static final long serialVersionUID = 4372435175782501152L;
    private static final String BUSINESS_OBJECT_CLASS = "businessObjectClass";
    private static final String INCLUDE_BLANK_ROW = "includeBlankRow";
    private static final String INCLUDE_KEY_IN_LABEL = "includeKeyInLabel";
    private static final String KEY_ATTRIBUTE = "keyAttribute";
    private static final String LABEL_ATTRIBUTE = "labelAttribute";
    protected boolean datePicker;
    protected String datePickerFormat;
    protected boolean expandedTextArea;
    protected String script;
    protected String valuesFinderClass;
    protected Map<String, Object> valuesFinderProperties = new HashMap<String, Object>();
    protected Integer size;
    protected Integer rows;
    protected Integer cols;
    protected boolean ranged = true;

    public boolean isDatePicker() {
        return this.datePicker;
    }

    public void setDatePicker(boolean datePicker) {
        this.datePicker = datePicker;
    }

    public String getDatePickerFormat() {
        return this.datePickerFormat;
    }

    public void setDatePickerFormat(String datePickerFormat) {
        this.datePickerFormat = datePickerFormat;
    }

    public boolean isExpandedTextArea() {
        return this.expandedTextArea;
    }

    public void setExpandedTextArea(boolean eTextArea) {
        this.expandedTextArea = eTextArea;
    }

    public boolean isCheckbox() {
        return false;
    }

    public boolean isHidden() {
        return false;
    }

    public boolean isRadio() {
        return false;
    }

    public boolean isSelect() {
        return false;
    }

    public boolean isMultiselect() {
        return false;
    }

    public boolean isText() {
        return false;
    }

    public boolean isTextarea() {
        return false;
    }

    public boolean isCurrency() {
        return false;
    }

    public boolean isKualiUser() {
        return false;
    }

    public boolean isWorkflowWorkgroup() {
        return false;
    }

    public boolean isFile() {
        return false;
    }

    public boolean isLookupHidden() {
        return false;
    }

    public boolean isLookupReadonly() {
        return false;
    }

    public boolean isButton() {
        return false;
    }

    public boolean isLink() {
        return false;
    }

    public void setValuesFinderClass(String valuesFinderClass) {
        if (valuesFinderClass == null) {
            throw new IllegalArgumentException("invalid (null) valuesFinderClass");
        }
        this.valuesFinderClass = valuesFinderClass;
    }

    public void setValuesFinderProperties(Map<String, Object> valuesFinderProperties) {
        this.valuesFinderProperties = valuesFinderProperties;
    }

    public String getBusinessObjectClass() {
        Object v = this.valuesFinderProperties.get(BUSINESS_OBJECT_CLASS);
        return v != null ? v.toString() : null;
    }

    public void setBusinessObjectClass(String businessObjectClass) {
        if (businessObjectClass == null) {
            throw new IllegalArgumentException("invalid (null) dataObjectClass");
        }
        this.valuesFinderProperties.put(BUSINESS_OBJECT_CLASS, businessObjectClass);
    }

    public Boolean getIncludeBlankRow() {
        Object v = this.valuesFinderProperties.get(INCLUDE_BLANK_ROW);
        return v != null && Boolean.parseBoolean(v.toString());
    }

    public void setIncludeBlankRow(Boolean includeBlankRow) {
        this.valuesFinderProperties.put(INCLUDE_BLANK_ROW, includeBlankRow.toString());
    }

    public Boolean getIncludeKeyInLabel() {
        Object v = this.valuesFinderProperties.get(INCLUDE_KEY_IN_LABEL);
        return v != null && Boolean.parseBoolean(v.toString());
    }

    public void setIncludeKeyInLabel(Boolean includeKeyInLabel) {
        this.valuesFinderProperties.put(INCLUDE_KEY_IN_LABEL, includeKeyInLabel.toString());
    }

    public String getKeyAttribute() {
        Object v = this.valuesFinderProperties.get(KEY_ATTRIBUTE);
        return v != null ? v.toString() : null;
    }

    public void setKeyAttribute(String keyAttribute) {
        this.valuesFinderProperties.put(KEY_ATTRIBUTE, keyAttribute);
    }

    public String getLabelAttribute() {
        Object v = this.valuesFinderProperties.get(LABEL_ATTRIBUTE);
        return v != null ? v.toString() : null;
    }

    public void setLabelAttribute(String labelAttribute) {
        this.valuesFinderProperties.put(LABEL_ATTRIBUTE, labelAttribute);
    }

    public String getValuesFinderClass() {
        return this.valuesFinderClass;
    }

    public Map<String, Object> getValuesFinderProperties() {
        return this.valuesFinderProperties;
    }

    public void setSize(Integer size) {
        this.size = size;
    }

    public Integer getSize() {
        return this.size;
    }

    public boolean hasScript() {
        return false;
    }

    public void setRows(Integer rows) {
        this.rows = rows;
    }

    public Integer getRows() {
        return this.rows;
    }

    public void setCols(Integer cols) {
        this.cols = cols;
    }

    public Integer getCols() {
        return this.cols;
    }

    public void completeValidation(Class<?> rootBusinessObjectClass, Class<?> otherBusinessObjectClass) {
        if (!(this.isCheckbox() || this.isHidden() || this.isRadio() || this.isSelect() || this.isMultiselect() || this.isText() || this.isTextarea() || this.isCurrency() || this.isKualiUser() || this.isLookupHidden() || this.isLookupReadonly() || this.isWorkflowWorkgroup() || this.isFile() || this.isButton() || this.isLink())) {
            throw new CompletionException("error validating " + rootBusinessObjectClass.getName() + " control: unknown control type in control definition ()");
        }
        if (this.valuesFinderClass != null) {
            try {
                Class valuesFinderClassObject = ClassUtils.getClass((ClassLoader)ClassLoaderUtils.getDefaultClassLoader(), (String)this.getValuesFinderClass());
                if (!KeyValuesFinder.class.isAssignableFrom(valuesFinderClassObject)) {
                    throw new ClassValidationException("valuesFinderClass is not a valid instance of " + KeyValuesFinder.class.getName() + " instead was: " + valuesFinderClassObject.getName());
                }
                if (!CollectionUtils.isEmpty(this.valuesFinderProperties)) {
                    Object finder = valuesFinderClassObject.newInstance();
                    Set invalid = this.valuesFinderProperties.keySet().stream().filter(k -> !PropertyUtils.isWriteable((Object)finder, (String)k)).collect(Collectors.toSet());
                    if (!invalid.isEmpty()) {
                        throw new ClassValidationException(valuesFinderClassObject.getName() + " does not have the following writable properties: " + String.valueOf(invalid));
                    }
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new ClassValidationException("valuesFinderClass could not be found: " + this.getValuesFinderClass(), (Throwable)e);
            }
        }
        if (this.getBusinessObjectClass() != null) {
            try {
                Class businessObjectClassObject = ClassUtils.getClass((ClassLoader)ClassLoaderUtils.getDefaultClassLoader(), (String)this.getBusinessObjectClass());
                if (!BusinessObject.class.isAssignableFrom(businessObjectClassObject)) {
                    throw new ClassValidationException("dataObjectClass is not a valid instance of " + BusinessObject.class.getName() + " instead was: " + businessObjectClassObject.getName());
                }
            }
            catch (ClassNotFoundException e) {
                throw new ClassValidationException("dataObjectClass could not be found: " + this.getBusinessObjectClass(), (Throwable)e);
            }
        }
    }

    public String getScript() {
        return this.script;
    }

    public void setScript(String script) {
        this.script = script;
    }

    public boolean isRanged() {
        return this.ranged;
    }

    public void setRanged(boolean ranged) {
        this.ranged = ranged;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ControlDefinitionBase)) {
            return false;
        }
        ControlDefinitionBase rhs = (ControlDefinitionBase)((Object)object);
        return new EqualsBuilder().append((Object)this.cols, (Object)rhs.cols).append((Object)this.valuesFinderClass, (Object)rhs.valuesFinderClass).append(this.valuesFinderProperties, rhs.valuesFinderProperties).append((Object)this.rows, (Object)rhs.rows).append((Object)this.script, (Object)rhs.script).append((Object)this.size, (Object)rhs.size).append(this.datePicker, rhs.datePicker).append(this.ranged, rhs.ranged).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.cols).append((Object)this.valuesFinderClass).append(this.valuesFinderProperties).append((Object)this.rows).append((Object)this.script).append((Object)this.size).append(this.datePicker).append(this.ranged).toHashCode();
    }
}

