/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kns.lookup;

import org.kuali.rice.krad.bo.BusinessObject;

import java.util.Collection;

/**
 * Classes that implement this interface will refresh
 *
 * @deprecated Only used in KNS classes, use KRAD.
 */
@Deprecated
public interface SelectiveReferenceRefresher {
    /**
     * Returns a list of references that must be refreshed after a lookup performed on an attribute is performed.
     *
     * A lookup on an attribute may cause many attribute values to be updated upon return from lookup.  Generally,
     * the returned attributes are the PK of the BO being looked up.  For example,
     * a lookup on an account number attribute will cause the chart of accounts code and account code to be returned.
     *
     * These returned attributes may cause other references on the page to be returned.  For example, an account number lookup
     * may cause the chart code to change, and if there is also an ObjectCode reference in the BO, then any change in the chart code will cause the
     * referenced ObjectCode BO to be changed.
     *
     * @param attributeName the name of the attribute with a quickfinder of the maintained BO.
     *
     * @return a list of reference names that could be affected by lookup return values
     */
    public Collection<String> getAffectedReferencesFromLookup(BusinessObject baseBO, String attributeName, String collectionPrefix);
}
