/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kns.datadictionary.validation.charlevel;

import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.datadictionary.exporter.ExportMap;
import org.kuali.rice.krad.datadictionary.validation.CharacterLevelValidationPattern;

import java.util.regex.Pattern;

/**
 * Pattern for matching any character in the given list (String)
 * 
 * @deprecated Use {@link org.kuali.rice.krad.datadictionary.validation.constraint.CharsetPatternConstraint}.
 */
@Deprecated
public class CharsetValidationPattern extends CharacterLevelValidationPattern {
    protected String validChars;

    /**
     * @return String containing all valid chars for this charset
     */
    public String getValidChars() {
        return validChars;
    }

    /**
     * @param validChars for this charset
     */
    public void setValidChars(String validChars) {
        if (StringUtils.isEmpty(validChars)) {
            throw new IllegalArgumentException("invalid (empty) validChars");
        }

        this.validChars = validChars;
    }


    /**
     * Escapes every special character I could think of, to limit potential misuse of this pattern.
     * 
     * @see org.kuali.rice.krad.datadictionary.validation.ValidationPattern#getRegexString()
     */
    @Override
    protected String getRegexString() {
        if (StringUtils.isEmpty(validChars)) {
            throw new IllegalStateException("validChars is empty");
        }

        // filter out and escape chars which would confuse the pattern-matcher
        Pattern filteringChars = Pattern.compile("([\\-\\[\\]\\{\\}\\$\\.\\^\\(\\)\\*\\&\\|])");
        String filteredChars = filteringChars.matcher(validChars).replaceAll("\\\\$1");

        StringBuffer regexString = new StringBuffer("[");
        regexString.append(filteredChars);
        if (filteredChars.endsWith("\\")) {
            regexString.append("\\");
        }
        regexString.append("]");

        return regexString.toString();
    }


    @Override
    public void extendExportMap(ExportMap exportMap) {
        exportMap.set("type", "charset");

        exportMap.set("validChars", getValidChars());
    }

	@Override
	public String[] getValidationErrorMessageParameters(String attributeLabel) {
		// build character list
		StringBuilder buf = new StringBuilder();
		for (int i = 0; i < validChars.length(); i++) {
			buf.append(validChars.charAt(i));
			if (i != validChars.length() - 1) {
				buf.append(", ");
			}
		}
		String characterList = buf.toString();
		
		if (getMaxLength() != -1) {
			return new String[] {attributeLabel, String.valueOf(getMaxLength()), characterList};
		}
		if (getExactLength() != -1) {
			return new String[] {attributeLabel, String.valueOf(getExactLength()), characterList};
		}
		return new String[] {attributeLabel, "0", characterList};
	}
}
