/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.service;

import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.bo.PersistableBusinessObjectBase;
import org.kuali.rice.krad.bo.PersistableBusinessObjectExtension;

@Deprecated
/**
 *  Provides an interface to the legacy adapter for continued use in PersistableBusinessObject
 *
 *  @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface LegacyAppFrameworkAdapterService {

    /**
     * Refresh persistableBusinessObject
     * @param persistableBusinessObjectBase
     */
    void refresh(PersistableBusinessObjectBase persistableBusinessObjectBase);

    /**
     * Refresh Nonupdateable references
     * @param persistableBusinessObjectBase
     */
    void refreshNonUpdateableReferences(PersistableBusinessObjectBase persistableBusinessObjectBase);

    /**
     * Retrieve reference object for persistable business object
     * @param persistableBusinessObject
     * @param referenceObjectName
     */
    void retrieveReferenceObject(PersistableBusinessObject persistableBusinessObject, String referenceObjectName);

    /**
     * Returns if the class is persistable or not
     * @param objectClass
     * @return
     */
    boolean isPersistable(Class<?> objectClass);

    /**
     * Creates an instance of the extension for the given business object class.
     */
    PersistableBusinessObjectExtension getExtension(Class<? extends PersistableBusinessObject> businessObjectClass)
            throws InstantiationException, IllegalAccessException;

    /**
     * Refreshes the specified reference object on the given business object.
     */
    void refreshReferenceObject(PersistableBusinessObject businessObject, String referenceObjectName);

}
