/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.dao.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.apache.ojb.broker.query.QueryFactory;
import org.kuali.rice.core.framework.persistence.ojb.dao.PlatformAwareDaoBaseOjb;
import org.kuali.rice.kns.service.KNSServiceLocator;
import org.kuali.rice.krad.bo.DataObjectBase;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.dao.BusinessObjectDao;
import org.kuali.rice.krad.dao.DocumentDao;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.DocumentAdHocService;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.util.OjbCollectionAware;
import org.kuali.rice.krad.service.util.OjbCollectionHelper;
import org.springframework.dao.DataAccessException;

@Deprecated
public class DocumentDaoOjb
extends PlatformAwareDaoBaseOjb
implements DocumentDao,
OjbCollectionAware {
    private static final Logger LOG = LogManager.getLogger(DocumentDaoOjb.class);
    protected BusinessObjectDao businessObjectDao;
    protected DocumentAdHocService documentAdHocService;
    private OjbCollectionHelper ojbCollectionHelper;

    public DocumentDaoOjb(BusinessObjectDao businessObjectDao, DocumentAdHocService documentAdHocService) {
        this.businessObjectDao = businessObjectDao;
        this.documentAdHocService = documentAdHocService;
    }

    @Override
    public <T extends Document> T save(T document) throws DataAccessException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("About to store document: " + String.valueOf(document), new Throwable());
        }
        T retrievedDocument = this.findByDocumentHeaderId(document.getClass(), document.getDocumentNumber());
        if (document instanceof PersistableBusinessObject && retrievedDocument != null && retrievedDocument instanceof PersistableBusinessObject) {
            this.getOjbCollectionHelper().processCollections(this, (PersistableBusinessObject)document, (PersistableBusinessObject)retrievedDocument);
        }
        if (document instanceof DataObjectBase) {
            if (StringUtils.isEmpty((String)document.getObjectId())) {
                ((DataObjectBase)document).setObjectId(UUID.randomUUID().toString());
            }
            document.setDocumentHeader(KRADServiceLocatorWeb.getDocumentHeaderService().saveDocumentHeader(document.getDocumentHeader()));
        }
        this.getPersistenceBrokerTemplate().store(document);
        return document;
    }

    @Override
    public <T extends Document> T findByDocumentHeaderId(Class<T> clazz, String id) {
        ArrayList<String> idList = new ArrayList<String>();
        idList.add(id);
        List<T> documentList = this.findByDocumentHeaderIds(clazz, idList);
        Document document = null;
        if (null != documentList && documentList.size() > 0) {
            document = (Document)documentList.get(0);
        }
        return (T)document;
    }

    @Override
    public <T extends Document> List<T> findByDocumentHeaderIds(Class<T> clazz, List<String> idList) {
        Criteria criteria = new Criteria();
        criteria.addIn("documentNumber", idList);
        QueryByCriteria query = QueryFactory.newQuery(clazz, (Criteria)criteria);
        ArrayList tempList = new ArrayList(this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query));
        for (Document doc : tempList) {
            this.documentAdHocService.addAdHocs(doc);
        }
        return tempList;
    }

    @Override
    public BusinessObjectDao getBusinessObjectDao() {
        return this.businessObjectDao;
    }

    public void setBusinessObjectDao(BusinessObjectDao businessObjectDao) {
        this.businessObjectDao = businessObjectDao;
    }

    @Override
    public DocumentAdHocService getDocumentAdHocService() {
        return this.documentAdHocService;
    }

    public void setDocumentAdHocService(DocumentAdHocService dahs) {
        this.documentAdHocService = dahs;
    }

    protected OjbCollectionHelper getOjbCollectionHelper() {
        if (this.ojbCollectionHelper == null) {
            this.ojbCollectionHelper = KNSServiceLocator.getOjbCollectionHelper();
        }
        return this.ojbCollectionHelper;
    }

    public void setOjbCollectionHelper(OjbCollectionHelper ojbCollectionHelper) {
        this.ojbCollectionHelper = ojbCollectionHelper;
    }
}

