/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kns.document.authorization;

import java.util.HashSet;
import java.util.Set;

import org.kuali.rice.kns.document.authorization.FieldRestriction;
import org.kuali.rice.kns.document.authorization.InquiryOrMaintenanceDocumentRestrictionsBase;
import org.kuali.rice.kns.document.authorization.MaintenanceDocumentRestrictions;
import org.kuali.rice.kns.web.ui.Field;

/**
 * @deprecated Only used in KNS classes, use KRAD.
 */
@Deprecated
public class MaintenanceDocumentRestrictionsBase extends InquiryOrMaintenanceDocumentRestrictionsBase implements MaintenanceDocumentRestrictions {
	private Set<String> readOnlyFields;
	private Set<String> readOnlySectionIds;
	
	public MaintenanceDocumentRestrictionsBase() {
	}
	
	@Override
    public void addReadOnlyField(String fieldName) {
		readOnlyFields.add(fieldName);
	}

	@Override
    public void addReadOnlySectionId(String sectionId) {
		readOnlySectionIds.add(sectionId);
	}

	@Override
    public Set<String> getReadOnlySectionIds() {
		return readOnlySectionIds;
	}

	@Override
	public FieldRestriction getFieldRestriction(String fieldName) {
		FieldRestriction fieldRestriction = super
				.getFieldRestriction(fieldName);
		if (fieldRestriction == null && isReadOnlyField(fieldName)) {
			fieldRestriction = new FieldRestriction(fieldName, Field.READONLY);
		}
		// TODO: next block could probably be removed since the superclass would return null for a read-only field 
		if (Field.EDITABLE
				.equals(fieldRestriction.getKualiFieldDisplayFlag())
				&& isReadOnlyField(fieldName)) {
			fieldRestriction = new FieldRestriction(fieldName,
					Field.READONLY);
		}
		return fieldRestriction;
	}

	@Override
	public void clearAllRestrictions() {
		super.clearAllRestrictions();
		readOnlyFields = new HashSet<String>();
		readOnlySectionIds = new HashSet<String>();
	}

	protected boolean isReadOnlyField(String fieldName) {
		String normalizedFieldName = normalizeFieldName(fieldName);
		return readOnlyFields.contains(normalizedFieldName);
	}

	/**
	 * @see org.kuali.rice.krad.authorization.InquiryOrMaintenanceDocumentRestrictionsBase#hasAnyFieldRestrictions()
	 */
	@Override
	public boolean hasAnyFieldRestrictions() {
		return super.hasAnyFieldRestrictions() || !readOnlyFields.isEmpty();
	}

	/**
	 * @see org.kuali.rice.krad.authorization.InquiryOrMaintenanceDocumentRestrictionsBase#hasRestriction(java.lang.String)
	 */
	@Override
	public boolean hasRestriction(String fieldName) {
		return super.hasRestriction(fieldName) || isReadOnlyField(fieldName);
	}
	
	/**
	 * @see org.kuali.rice.kns.document.authorization.MaintenanceDocumentRestrictions#isReadOnlySectionId(java.lang.String)
	 */
	@Override
    public boolean isReadOnlySectionId(String sectionId) {
		return readOnlySectionIds.contains(sectionId);
	}
}
