/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.service.impl;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

import org.apache.commons.beanutils.PropertyUtils;
import org.kuali.rice.krad.exception.IntrospectionException;
import org.kuali.rice.krad.util.LegacyDataFramework;

@Deprecated
@LegacyDataFramework
public class PersistenceServiceImplBase extends PersistenceServiceStructureImplBase {

	/**
	 * @see org.kuali.rice.krad.service.PersistenceMetadataService#getPrimaryKeyFields(java.lang.Object)
	 */
	public Map getPrimaryKeyFieldValues(Object persistableObject) {
		return getPrimaryKeyFieldValues(persistableObject, false);
	}

	/**
	 * @see org.kuali.rice.krad.service.PersistenceMetadataService#getPrimaryKeyFields(java.lang.Object,
	 *      boolean)
	 */
	public Map getPrimaryKeyFieldValues(Object persistableObject, boolean sortFieldNames) {
		if (persistableObject == null) {
			throw new IllegalArgumentException("invalid (null) persistableObject");
		}

		Map keyValueMap = null;
		if (sortFieldNames) {
			keyValueMap = new TreeMap();
		} else {
			keyValueMap = new HashMap();
		}

		String className = null;
		String fieldName = null;
		try {
			List fields = listPrimaryKeyFieldNames(persistableObject.getClass());
			for (Iterator i = fields.iterator(); i.hasNext();) {
				fieldName = (String) i.next();
				className = persistableObject.getClass().getName();
				Object fieldValue = PropertyUtils.getSimpleProperty(persistableObject, fieldName);

				keyValueMap.put(fieldName, fieldValue);
			}
		} catch (IllegalAccessException e) {
			throw new IntrospectionException("problem accessing property '" + className + "." + fieldName + "'", e);
		} catch (NoSuchMethodException e) {
			throw new IntrospectionException("unable to invoke getter for property '" + className + "." + fieldName + "'", e);
		} catch (InvocationTargetException e) {
			throw new IntrospectionException("problem invoking getter for property '" + className + "." + fieldName + "'", e);
		}

		return keyValueMap;
	}

}
