/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.kuali.rice.krad.util.ErrorMessage;
import org.kuali.rice.krad.util.GrowlMessage;
import org.springframework.util.AutoPopulatingList;

public class MessageMap
implements Serializable {
    private static final long serialVersionUID = -2328635367656516150L;
    private final List<String> errorPath;
    private final Map<String, List<ErrorMessage>> errorMessages;
    private final Map<String, List<ErrorMessage>> warningMessages;
    private final Map<String, List<ErrorMessage>> infoMessages;
    private final List<GrowlMessage> growlMessages;

    public MessageMap() {
        this.errorPath = Collections.synchronizedList(new ArrayList());
        this.errorMessages = Collections.synchronizedMap(new LinkedHashMap());
        this.warningMessages = Collections.synchronizedMap(new LinkedHashMap());
        this.infoMessages = Collections.synchronizedMap(new LinkedHashMap());
        this.growlMessages = Collections.synchronizedList(new AutoPopulatingList(GrowlMessage.class));
    }

    public MessageMap(MessageMap messageMap) {
        this.errorPath = messageMap.errorPath;
        this.errorMessages = messageMap.errorMessages;
        this.warningMessages = messageMap.warningMessages;
        this.infoMessages = messageMap.infoMessages;
        this.growlMessages = Collections.synchronizedList(new AutoPopulatingList(GrowlMessage.class));
    }

    public void merge(MessageMap messageMap) {
        if (messageMap != null) {
            if (messageMap.hasErrors()) {
                this.merge(messageMap.getErrorMessages(), this.errorMessages);
            }
            if (messageMap.hasInfo()) {
                this.merge(messageMap.getInfoMessages(), this.infoMessages);
            }
            if (messageMap.hasWarnings()) {
                this.merge(messageMap.getWarningMessages(), this.warningMessages);
            }
            if (messageMap.getGrowlMessages() != null) {
                this.growlMessages.addAll(messageMap.getGrowlMessages());
            }
        }
    }

    public void merge(Map<String, List<ErrorMessage>> messagesFrom, Map<String, List<ErrorMessage>> messagesTo) {
        for (String key : messagesFrom.keySet()) {
            if (messagesTo.containsKey(key)) {
                List<ErrorMessage> tal = messagesFrom.get(key);
                List<ErrorMessage> parentList = messagesTo.get(key);
                for (ErrorMessage o : tal) {
                    if (parentList.contains(o)) continue;
                    parentList.add(o);
                }
                continue;
            }
            messagesTo.put(key, messagesFrom.get(key));
        }
    }

    public List<ErrorMessage> putError(String propertyName, String errorKey, String ... errorParameters) {
        ErrorMessage message = new ErrorMessage(errorKey, errorParameters);
        return this.putMessageInMap(this.errorMessages, propertyName, message, true, true);
    }

    public List<ErrorMessage> putWarning(String propertyName, String messageKey, String ... messageParameters) {
        ErrorMessage message = new ErrorMessage(messageKey, messageParameters);
        return this.putMessageInMap(this.warningMessages, propertyName, message, true, true);
    }

    public List<ErrorMessage> putInfo(String propertyName, String messageKey, String ... messageParameters) {
        ErrorMessage message = new ErrorMessage(messageKey, messageParameters);
        return this.putMessageInMap(this.infoMessages, propertyName, message, true, true);
    }

    public List<ErrorMessage> putError(String propertyName, ErrorMessage message) {
        return this.putMessageInMap(this.errorMessages, propertyName, message, true, true);
    }

    public List<ErrorMessage> putWarning(String propertyName, ErrorMessage message) {
        return this.putMessageInMap(this.warningMessages, propertyName, message, true, true);
    }

    public List<ErrorMessage> putInfo(String propertyName, ErrorMessage message) {
        return this.putMessageInMap(this.infoMessages, propertyName, message, true, true);
    }

    public List<ErrorMessage> putErrorWithoutFullErrorPath(String propertyName, String errorKey, String ... errorParameters) {
        ErrorMessage message = new ErrorMessage(errorKey, errorParameters);
        return this.putMessageInMap(this.errorMessages, propertyName, message, false, true);
    }

    public List<ErrorMessage> putWarningWithoutFullErrorPath(String propertyName, String messageKey, String ... messageParameters) {
        ErrorMessage message = new ErrorMessage(messageKey, messageParameters);
        return this.putMessageInMap(this.warningMessages, propertyName, message, false, true);
    }

    public List<ErrorMessage> putInfoWithoutFullErrorPath(String propertyName, String messageKey, String ... messageParameters) {
        ErrorMessage message = new ErrorMessage(messageKey, messageParameters);
        return this.putMessageInMap(this.infoMessages, propertyName, message, false, true);
    }

    public List<ErrorMessage> putErrorWithoutFullErrorPath(String propertyName, ErrorMessage message) {
        return this.putMessageInMap(this.errorMessages, propertyName, message, false, true);
    }

    public List<ErrorMessage> putWarningWithoutFullErrorPath(String propertyName, ErrorMessage message) {
        return this.putMessageInMap(this.warningMessages, propertyName, message, false, true);
    }

    public List<ErrorMessage> putInfoWithoutFullErrorPath(String propertyName, ErrorMessage message) {
        return this.putMessageInMap(this.infoMessages, propertyName, message, false, true);
    }

    public List<ErrorMessage> putErrorForSectionId(String sectionId, String errorKey, String ... errorParameters) {
        return this.putErrorWithoutFullErrorPath(sectionId, errorKey, errorParameters);
    }

    public List<ErrorMessage> putWarningForSectionId(String sectionId, String messageKey, String ... messageParameters) {
        return this.putWarningWithoutFullErrorPath(sectionId, messageKey, messageParameters);
    }

    public List<ErrorMessage> putInfoForSectionId(String sectionId, String messageKey, String ... messageParameters) {
        return this.putInfoWithoutFullErrorPath(sectionId, messageKey, messageParameters);
    }

    public List<ErrorMessage> putErrorForSectionId(String sectionId, ErrorMessage message) {
        return this.putErrorWithoutFullErrorPath(sectionId, message);
    }

    public List<ErrorMessage> putWarningForSectionId(String sectionId, ErrorMessage message) {
        return this.putWarningWithoutFullErrorPath(sectionId, message);
    }

    public List<ErrorMessage> putInfoForSectionId(String sectionId, ErrorMessage message) {
        return this.putInfoWithoutFullErrorPath(sectionId, message);
    }

    public List<ErrorMessage> putError(String propertyName, String errorKey, Boolean escapeHtmlMessageParameters, String ... errorParameters) {
        ErrorMessage message = new ErrorMessage(errorKey, errorParameters);
        return this.putMessageInMap(this.errorMessages, propertyName, message, true, escapeHtmlMessageParameters);
    }

    public List<ErrorMessage> putWarning(String propertyName, String messageKey, Boolean escapeHtmlMessageParameters, String ... messageParameters) {
        ErrorMessage message = new ErrorMessage(messageKey, messageParameters);
        return this.putMessageInMap(this.warningMessages, propertyName, message, true, escapeHtmlMessageParameters);
    }

    public List<ErrorMessage> putInfo(String propertyName, String messageKey, Boolean escapeHtmlMessageParameters, String ... messageParameters) {
        ErrorMessage message = new ErrorMessage(messageKey, messageParameters);
        return this.putMessageInMap(this.infoMessages, propertyName, message, true, escapeHtmlMessageParameters);
    }

    public void addGrowlMessage(String growlTitle, String messageKey, String ... messageParameters) {
        GrowlMessage growl = new GrowlMessage();
        growl.setTitle(growlTitle);
        growl.setMessageKey(messageKey);
        growl.setMessageParameters(messageParameters);
        this.growlMessages.add(growl);
    }

    public void addGrowlMessage(GrowlMessage growl) {
        this.growlMessages.add(growl);
    }

    protected List<ErrorMessage> putMessageInMap(Map<String, List<ErrorMessage>> messagesMap, String propertyName, ErrorMessage errorMessage, boolean prependFullErrorPath, boolean escapeHtmlMessageParameters) {
        if (StringUtils.isBlank((String)propertyName)) {
            throw new IllegalArgumentException("invalid (blank) propertyName");
        }
        if (StringUtils.isBlank((String)errorMessage.getErrorKey())) {
            throw new IllegalArgumentException("invalid (blank) errorKey");
        }
        List<ErrorMessage> errorList = null;
        String propertyKey = this.getKeyPath(propertyName, prependFullErrorPath);
        errorList = messagesMap.containsKey(propertyKey) ? messagesMap.get(propertyKey) : Collections.synchronizedList(new AutoPopulatingList(ErrorMessage.class));
        if (escapeHtmlMessageParameters) {
            int i;
            String[] filteredMessageParameters;
            if (errorMessage.getMessageParameters() != null) {
                filteredMessageParameters = new String[errorMessage.getMessageParameters().length];
                for (i = 0; i < errorMessage.getMessageParameters().length; ++i) {
                    filteredMessageParameters[i] = StringEscapeUtils.escapeHtml((String)errorMessage.getMessageParameters()[i]);
                }
                errorMessage.setMessageParameters(filteredMessageParameters);
            }
            if (errorMessage.getMessagePrefixParameters() != null) {
                filteredMessageParameters = new String[errorMessage.getMessagePrefixParameters().length];
                for (i = 0; i < errorMessage.getMessagePrefixParameters().length; ++i) {
                    filteredMessageParameters[i] = StringEscapeUtils.escapeHtml((String)errorMessage.getMessagePrefixParameters()[i]);
                }
                errorMessage.setMessagePrefixParameters(filteredMessageParameters);
            }
            if (errorMessage.getMessageSuffixParameters() != null) {
                filteredMessageParameters = new String[errorMessage.getMessageSuffixParameters().length];
                for (i = 0; i < errorMessage.getMessageSuffixParameters().length; ++i) {
                    filteredMessageParameters[i] = StringEscapeUtils.escapeHtml((String)errorMessage.getMessageSuffixParameters()[i]);
                }
                errorMessage.setMessageSuffixParameters(filteredMessageParameters);
            }
        }
        boolean alreadyAdded = false;
        for (ErrorMessage e : errorList) {
            if (!e.equals(errorMessage)) continue;
            alreadyAdded = true;
            break;
        }
        if (!alreadyAdded) {
            errorList.add(errorMessage);
        }
        return messagesMap.put(propertyKey, errorList);
    }

    public boolean replaceError(String propertyName, String targetKey, String replaceKey, String ... replaceParameters) {
        return this.replaceError(propertyName, targetKey, true, replaceKey, replaceParameters);
    }

    public boolean replaceErrorWithoutFullErrorPath(String propertyName, String targetKey, String replaceKey, String ... replaceParameters) {
        return this.replaceError(propertyName, targetKey, false, replaceKey, replaceParameters);
    }

    private boolean replaceError(String propertyName, String targetKey, boolean withFullErrorPath, String replaceKey, String ... replaceParameters) {
        boolean replaced = false;
        if (StringUtils.isBlank((String)propertyName)) {
            throw new IllegalArgumentException("invalid (blank) propertyName");
        }
        if (StringUtils.isBlank((String)targetKey)) {
            throw new IllegalArgumentException("invalid (blank) targetKey");
        }
        if (StringUtils.isBlank((String)replaceKey)) {
            throw new IllegalArgumentException("invalid (blank) replaceKey");
        }
        List<ErrorMessage> errorList = null;
        String propertyKey = this.getKeyPath(propertyName, withFullErrorPath);
        if (this.errorMessages.containsKey(propertyKey)) {
            errorList = this.errorMessages.get(propertyKey);
            for (int i = 0; i < errorList.size(); ++i) {
                ErrorMessage em = errorList.get(i);
                if (!em.getErrorKey().equals(targetKey)) continue;
                ErrorMessage rm = new ErrorMessage(replaceKey, replaceParameters);
                errorList.set(i, rm);
                replaced = true;
            }
        }
        return replaced;
    }

    public boolean fieldHasMessage(String fieldName, String errorKey) {
        boolean found = false;
        List<ErrorMessage> fieldMessages = this.errorMessages.get(fieldName);
        if (fieldMessages != null) {
            Iterator<ErrorMessage> i = fieldMessages.iterator();
            while (!found && i.hasNext()) {
                ErrorMessage errorMessage = i.next();
                found = errorMessage.getErrorKey().equals(errorKey);
            }
        }
        return found;
    }

    public int countFieldMessages(String fieldName) {
        int count = 0;
        List<ErrorMessage> fieldMessages = this.errorMessages.get(fieldName);
        if (fieldMessages != null) {
            count = fieldMessages.size();
        }
        return count;
    }

    public boolean containsMessageKey(String messageKey) {
        ErrorMessage foundMessage = null;
        if (!this.hasNoErrors()) {
            Iterator<Map.Entry<String, List<ErrorMessage>>> i = this.getAllPropertiesAndErrors().iterator();
            while (foundMessage == null && i.hasNext()) {
                Map.Entry<String, List<ErrorMessage>> e = i.next();
                List<ErrorMessage> entryErrorList = e.getValue();
                for (ErrorMessage em : entryErrorList) {
                    if (!messageKey.equals(em.getErrorKey())) continue;
                    foundMessage = em;
                }
            }
        }
        return foundMessage != null;
    }

    private int getMessageCount(Map<String, List<ErrorMessage>> messageMap) {
        int messageCount = 0;
        for (String errorKey : messageMap.keySet()) {
            List<ErrorMessage> errors = messageMap.get(errorKey);
            messageCount += errors.size();
        }
        return messageCount;
    }

    public int getErrorCount() {
        return this.getMessageCount(this.errorMessages);
    }

    public int getWarningCount() {
        return this.getMessageCount(this.warningMessages);
    }

    public int getInfoCount() {
        return this.getMessageCount(this.infoMessages);
    }

    public List<ErrorMessage> getMessages(String path) {
        return this.errorMessages.get(path);
    }

    public void addToErrorPath(String parentName) {
        this.errorPath.add(parentName);
    }

    public List<String> getErrorPath() {
        return this.errorPath;
    }

    public boolean removeFromErrorPath(String parentName) {
        return this.errorPath.remove(parentName);
    }

    public void clearErrorPath() {
        this.errorPath.clear();
    }

    public String getKeyPath(String propertyName, boolean prependFullErrorPath) {
        String keyPath = "";
        if ("GLOBAL_ERRORS".equals(propertyName)) {
            return "GLOBAL_ERRORS";
        }
        if (!this.errorPath.isEmpty() && prependFullErrorPath) {
            keyPath = StringUtils.join(this.errorPath.iterator(), (String)".");
            keyPath = keyPath + (keyPath != null && keyPath.endsWith(".") ? propertyName : "." + propertyName);
        } else {
            keyPath = propertyName;
        }
        return keyPath;
    }

    public List<String> getPropertiesWithErrors() {
        ArrayList<String> properties = new ArrayList<String>();
        Iterator<String> iter = this.errorMessages.keySet().iterator();
        while (iter.hasNext()) {
            properties.add(iter.next());
        }
        return properties;
    }

    public List<String> getPropertiesWithWarnings() {
        ArrayList<String> properties = new ArrayList<String>(this.warningMessages.keySet());
        return properties;
    }

    public List<String> getPropertiesWithInfo() {
        ArrayList<String> properties = new ArrayList<String>(this.infoMessages.keySet());
        return properties;
    }

    public void clearErrorMessages() {
        this.errorMessages.clear();
    }

    public boolean doesPropertyHaveError(String key) {
        return this.errorMessages.containsKey(key);
    }

    public boolean containsKeyMatchingPattern(String pattern) {
        ArrayList<String> simplePatterns = new ArrayList<String>();
        ArrayList<String> wildcardPatterns = new ArrayList<String>();
        String[] patterns = pattern.split(",");
        for (int i = 0; i < patterns.length; ++i) {
            String s = patterns[i];
            if (s.endsWith("*")) {
                wildcardPatterns.add(s.substring(0, s.length() - 1));
                continue;
            }
            simplePatterns.add(s);
        }
        for (String key : this.errorMessages.keySet()) {
            if (simplePatterns.contains(key)) {
                return true;
            }
            for (String wildcard : wildcardPatterns) {
                if (!key.startsWith(wildcard)) continue;
                return true;
            }
        }
        return false;
    }

    public Set<Map.Entry<String, List<ErrorMessage>>> getAllPropertiesAndErrors() {
        return this.errorMessages.entrySet();
    }

    public List<ErrorMessage> getErrorMessagesForProperty(String propertyName) {
        return this.errorMessages.get(propertyName);
    }

    public List<ErrorMessage> getWarningMessagesForProperty(String propertyName) {
        return this.warningMessages.get(propertyName);
    }

    public List<ErrorMessage> getInfoMessagesForProperty(String propertyName) {
        return this.infoMessages.get(propertyName);
    }

    public List<List<ErrorMessage>> getErrorMessagesForProperty(String propertyName, boolean allowWildcard) {
        ArrayList<List<ErrorMessage>> foundMessages = new ArrayList<List<ErrorMessage>>();
        if (allowWildcard) {
            boolean wildcard = false;
            if (propertyName.endsWith("*")) {
                wildcard = true;
                propertyName = propertyName.substring(0, propertyName.length() - 1);
            }
            for (String key : this.errorMessages.keySet()) {
                if (!wildcard && propertyName.equals(key)) {
                    foundMessages.add(this.errorMessages.get(key));
                    break;
                }
                if (!wildcard || !key.startsWith(propertyName)) continue;
                foundMessages.add(this.errorMessages.get(key));
            }
        } else {
            foundMessages.add(this.getErrorMessagesForProperty(propertyName));
        }
        return foundMessages;
    }

    public List<List<ErrorMessage>> getWarningMessagesForProperty(String propertyName, boolean allowWildcard) {
        ArrayList<List<ErrorMessage>> foundMessages = new ArrayList<List<ErrorMessage>>();
        if (allowWildcard) {
            boolean wildcard = false;
            if (propertyName.endsWith("*")) {
                wildcard = true;
                propertyName = propertyName.substring(0, propertyName.length() - 1);
            }
            for (String key : this.warningMessages.keySet()) {
                if (!wildcard && propertyName.equals(key)) {
                    foundMessages.add(this.warningMessages.get(key));
                    break;
                }
                if (!wildcard || !key.startsWith(propertyName)) continue;
                foundMessages.add(this.warningMessages.get(key));
            }
        } else {
            foundMessages.add(this.getWarningMessagesForProperty(propertyName));
        }
        return foundMessages;
    }

    public List<List<ErrorMessage>> getInfoMessagesForProperty(String propertyName, boolean allowWildcard) {
        ArrayList<List<ErrorMessage>> foundMessages = new ArrayList<List<ErrorMessage>>();
        if (allowWildcard) {
            boolean wildcard = false;
            if (propertyName.endsWith("*")) {
                wildcard = true;
                propertyName = propertyName.substring(0, propertyName.length() - 1);
            }
            for (String key : this.infoMessages.keySet()) {
                if (!wildcard && propertyName.equals(key)) {
                    foundMessages.add(this.infoMessages.get(key));
                    break;
                }
                if (!wildcard || !key.startsWith(propertyName)) continue;
                foundMessages.add(this.infoMessages.get(key));
            }
        } else {
            foundMessages.add(this.getInfoMessagesForProperty(propertyName));
        }
        return foundMessages;
    }

    public boolean hasErrors() {
        return !this.errorMessages.isEmpty();
    }

    public boolean hasNoErrors() {
        return this.errorMessages.isEmpty();
    }

    public boolean hasWarnings() {
        return !this.warningMessages.isEmpty();
    }

    public boolean hasNoWarnings() {
        return this.warningMessages.isEmpty();
    }

    public boolean hasInfo() {
        return !this.infoMessages.isEmpty();
    }

    public boolean hasNoInfo() {
        return this.infoMessages.isEmpty();
    }

    public boolean hasMessages() {
        return !this.errorMessages.isEmpty() || !this.warningMessages.isEmpty() || !this.infoMessages.isEmpty();
    }

    public boolean hasNoMessages() {
        return this.errorMessages.isEmpty() && this.warningMessages.isEmpty() && this.infoMessages.isEmpty();
    }

    public Set<String> getAllPropertiesWithErrors() {
        return this.errorMessages.keySet();
    }

    public Set<String> getAllPropertiesWithWarnings() {
        return this.warningMessages.keySet();
    }

    public Set<String> getAllPropertiesWithInfo() {
        return this.infoMessages.keySet();
    }

    public List<ErrorMessage> removeAllErrorMessagesForProperty(String property) {
        return this.errorMessages.remove(property);
    }

    public List<ErrorMessage> removeAllWarningMessagesForProperty(String property) {
        return this.warningMessages.remove(property);
    }

    public List<ErrorMessage> removeAllInfoMessagesForProperty(String property) {
        return this.infoMessages.remove(property);
    }

    public int getNumberOfPropertiesWithErrors() {
        return this.errorMessages.size();
    }

    public Map<String, List<ErrorMessage>> getErrorMessages() {
        return this.errorMessages;
    }

    public Map<String, List<ErrorMessage>> getWarningMessages() {
        return this.warningMessages;
    }

    public Map<String, List<ErrorMessage>> getInfoMessages() {
        return this.infoMessages;
    }

    public List<GrowlMessage> getGrowlMessages() {
        return this.growlMessages;
    }

    public boolean equals(Object o) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)o);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

