/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.service;

import org.kuali.rice.krad.bo.DocumentHeader;

/**
 * Provides basic functions for interacting with the DocumentHeader object in the Rice application framework.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface DocumentHeaderService {

    /**
     * This method retrieves a document header using the given documentHeaderId
     *
     * @param documentHeaderId - the id of the document to retrieve the document header for
     * @return the document header associated with the given document header id
     */
    public DocumentHeader getDocumentHeaderById(String documentHeaderId);


    /**
     * This method saves a document header object and returns the copy after the save.
     * Any code using the document header must use the instance returned from this method
     * for any future operations.
     *
     * @param documentHeader - the document header object to save
     */
    public DocumentHeader saveDocumentHeader(DocumentHeader documentHeader);

    /**
     * This method deletes a document header object
     *
     * @param documentHeader - the document header to be removed
     */
    public void deleteDocumentHeader(DocumentHeader documentHeader);

}
