/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.service;

/**
 * This interface defines methods that an XmlObjectSerializer Service must provide. This will wrap our needs for xml to object and
 * object to xml functionality.
 * 
 * 
 */
public interface XmlObjectSerializerService {
    /**
     * Marshals out XML from an object instance.
     * 
     * @param object
     * @return
     */
    public String toXml(Object object);

    /**
     * Retrieves an Object instance from a String of XML - unmarshals.
     * 
     * @param xml
     * @return
     */
    public Object fromXml(String xml);

}
