/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.util;

import org.kuali.rice.krad.data.DataObjectWrapper;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;

/**
 * This class is a token-style class, that is write-once, then read-only for all consumers of the class. It is often used as a
 * return value from various PersistenceStructureService methods.
 *
 * The object represents the state of the foreign-key fields of a reference object. For example, if Account is the bo, and
 * organization is the reference object, then chartOfAccountsCode and organizationCode are the foreign key fields. Their state,
 * rather they are all filled out, whether any of them are filled out, and which ones are not filled out, is what this class
 * represents.
 *
 * @deprecated Replaced with methods on {@link DataObjectWrapper}
 */
@Deprecated
public final class ForeignKeyFieldsPopulationState implements Serializable {

    private final boolean allFieldsPopulated;
    private final boolean anyFieldsPopulated;
    private final List<String> unpopulatedFieldNames;

    public ForeignKeyFieldsPopulationState(boolean allFieldsPopulated, boolean anyFieldsPopulated, List<String> unpopulatedFieldNames) {
        this.allFieldsPopulated = allFieldsPopulated;
        this.anyFieldsPopulated = anyFieldsPopulated;
        this.unpopulatedFieldNames = unpopulatedFieldNames;
    }

    public boolean isAllFieldsPopulated() {
        return allFieldsPopulated;
    }

    public boolean isAnyFieldsPopulated() {
        return anyFieldsPopulated;
    }

    public List<String> getUnpopulatedFieldNames() {
        return unpopulatedFieldNames;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ForeignKeyFieldsPopulationState that = (ForeignKeyFieldsPopulationState) o;
        return allFieldsPopulated == that.allFieldsPopulated &&
                anyFieldsPopulated == that.anyFieldsPopulated &&
                Objects.equals(unpopulatedFieldNames, that.unpopulatedFieldNames);
    }

    @Override
    public int hashCode() {
        return Objects.hash(allFieldsPopulated, anyFieldsPopulated, unpopulatedFieldNames);
    }

    @Override
    public String toString() {
        return "ForeignKeyFieldsPopulationState{" +
                "allFieldsPopulated=" + allFieldsPopulated +
                ", anyFieldsPopulated=" + anyFieldsPopulated +
                ", unpopulatedFieldNames=" + unpopulatedFieldNames +
                '}';
    }
}
