/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.bo;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;

import org.eclipse.persistence.annotations.Index;

/**
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
@Entity
@Table(name="KRNS_MAINT_DOC_ATT_LST_T",uniqueConstraints= {
        @UniqueConstraint(name="KRNS_MAINT_DOC_ATT_LST_TC0",columnNames="OBJ_ID")
})
public class MultiDocumentAttachment extends PersistableAttachmentBase {
    private static final long serialVersionUID = 1L;

    @Id
    @Column(name="ATT_ID",length=40)
    private String id;

    @Column(name="DOC_HDR_ID",length=14)
    @Index(name="KRNS_MAINT_DOC_ATT_LST_TI1")
    private String documentNumber;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getDocumentNumber() {
        return this.documentNumber;
    }

    public void setDocumentNumber(String documentNumber) {
        this.documentNumber = documentNumber;
    }

}
