/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.service;

import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.core.framework.persistence.platform.DatabasePlatform;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.metadata.MetadataRepository;
import org.kuali.rice.krad.data.provider.ProviderRegistry;
import org.kuali.rice.krad.service.AttachmentService;
import org.kuali.rice.krad.service.BusinessObjectSerializerService;
import org.kuali.rice.krad.service.InactivateableFromToService;
import org.kuali.rice.krad.service.LegacyDataAppAdapter;
import org.kuali.rice.krad.service.NoteService;
import org.kuali.rice.krad.service.XmlObjectSerializerService;

public class KRADServiceLocator {
    public static final String ATTACHMENT_SERVICE = "attachmentService";
    public static final String NOTE_SERVICE = "noteService";
    public static final String ENTITY_MANAGER_FACTORY = "entityManagerFactory";
    public static final String APPLICATION_ENTITY_MANAGER_FACTORY = "kradApplicationEntityManagerFactory";
    public static final String XML_OBJECT_SERIALIZER_SERVICE = "xmlObjectSerializerService";
    public static final String XML_OBJECT_SERIALIZER_IGNORE_MISSING_FIELDS_SERVICE = "xmlObjectSerializerIgnoreMissingFieldsService";
    public static final String KNS_SERIALIZER_SERVICE = "businessObjectSerializerService";
    public static final String KRAD_SERIALIZER_SERVICE = "dataObjectSerializerService";
    public static final String DB_PLATFORM = "dbPlatform";
    public static final String INACTIVATEABLE_FROM_TO_SERVICE = "inactivateableFromToService";
    public static final String DATA_OBJECT_SERVICE = "dataObjectService";
    public static final String METADATA_REPOSITORY = "metadataRepository";
    public static final String PROVIDER_REGISTRY = "providerRegistry";
    public static final String KRAD_APPLICATION_DATA_SOURCE = "kradApplicationDataSource";
    public static final String LEGACY_DATA_ADAPTER = "legacyDataAdapter";

    static <T> T getService(String serviceName) {
        return (T)GlobalResourceLoader.getService((String)serviceName);
    }

    public static AttachmentService getAttachmentService() {
        return (AttachmentService)KRADServiceLocator.getService(ATTACHMENT_SERVICE);
    }

    public static NoteService getNoteService() {
        return (NoteService)KRADServiceLocator.getService(NOTE_SERVICE);
    }

    public static EntityManagerFactory getEntityManagerFactory() {
        return (EntityManagerFactory)KRADServiceLocator.getService(ENTITY_MANAGER_FACTORY);
    }

    public static EntityManagerFactory getApplicationEntityManagerFactory() {
        return (EntityManagerFactory)KRADServiceLocator.getService(APPLICATION_ENTITY_MANAGER_FACTORY);
    }

    public static XmlObjectSerializerService getXmlObjectSerializerService() {
        return (XmlObjectSerializerService)KRADServiceLocator.getService(XML_OBJECT_SERIALIZER_SERVICE);
    }

    public static XmlObjectSerializerService getXmlObjectSerializerIgnoreMissingFieldsService() {
        return (XmlObjectSerializerService)KRADServiceLocator.getService(XML_OBJECT_SERIALIZER_IGNORE_MISSING_FIELDS_SERVICE);
    }

    public static BusinessObjectSerializerService getBusinessObjectSerializerService() {
        return (BusinessObjectSerializerService)KRADServiceLocator.getService(KNS_SERIALIZER_SERVICE);
    }

    public static BusinessObjectSerializerService getDataObjectSerializerService() {
        return (BusinessObjectSerializerService)KRADServiceLocator.getService(KRAD_SERIALIZER_SERVICE);
    }

    public static DatabasePlatform getDatabasePlatform() {
        return (DatabasePlatform)KRADServiceLocator.getService(DB_PLATFORM);
    }

    public static InactivateableFromToService getInactivateableFromToService() {
        return (InactivateableFromToService)KRADServiceLocator.getService(INACTIVATEABLE_FROM_TO_SERVICE);
    }

    public static DataObjectService getDataObjectService() {
        return (DataObjectService)KRADServiceLocator.getService(DATA_OBJECT_SERVICE);
    }

    public static MetadataRepository getMetadataRepository() {
        return (MetadataRepository)KRADServiceLocator.getService(METADATA_REPOSITORY);
    }

    public static ProviderRegistry getProviderRegistry() {
        return (ProviderRegistry)KRADServiceLocator.getService(PROVIDER_REGISTRY);
    }

    public static DataSource getKradApplicationDataSource() {
        return (DataSource)KRADServiceLocator.getService(KRAD_APPLICATION_DATA_SOURCE);
    }

    @Deprecated
    public static LegacyDataAppAdapter getLegacyDataAdapter() {
        return (LegacyDataAppAdapter)KRADServiceLocator.getService(LEGACY_DATA_ADAPTER);
    }
}

