/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.exception;

/**
 * Represents an exception that is thrown when the persistence layer attempts to manipulate a class which has not been
 * marked as persistable
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class ClassNotPersistableException extends RuntimeException {

    private static final long serialVersionUID = 6240754565898373530L;

    /**
     * @param message
     */
    public ClassNotPersistableException(String message) {
        super(message);
    }

    /**
     * @param message
     */
    public ClassNotPersistableException(String message, Throwable t) {
        super(message, t);
    }
}
