/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.bo;

import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Transient;

import org.apache.commons.lang.StringUtils;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;

/**
 * Ad Hoc Route Person Business Object
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
@Entity
@Table(name = "KRNS_ADHOC_RTE_ACTN_RECIP_T")
public class AdHocRoutePerson extends AdHocRouteRecipient {
    private static final long serialVersionUID = 1L;

    @Transient
    private transient Person person;

    public AdHocRoutePerson() {
        setType(PERSON_TYPE);
    }

    @Override
    public void setType(Integer type) {
        if (!PERSON_TYPE.equals(type)) {
            throw new IllegalArgumentException("cannot change type to " + type);
        }
        super.setType(type);
    }

    @Override
    public void setId(String id) {
        super.setId(id);

        if (StringUtils.isNotBlank(id)) {
            person = KimApiServiceLocator.getPersonService().getPersonByPrincipalName(id);
            setPerson(person);
        }
    }

    @Override
    public void setName(String name) {
        super.setName(name);

        if (StringUtils.isNotBlank(name) && getId() != null &&
                ((person != null) && !StringUtils.equals(person.getName(), name))) {
            person = KimApiServiceLocator.getPersonService().getPersonByPrincipalName(getId());
            setPerson(person);
        }
    }

    public Person getPerson() {
        if ((person == null) || !StringUtils.equals(person.getPrincipalName(), getId())) {
            person = KimApiServiceLocator.getPersonService().getPersonByPrincipalName(getId());

            if (person == null) {
                try {
                    person = (Person) KimApiServiceLocator.getPersonService().getPersonImplementationClass()
                            .newInstance();
                } catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }

        return person;
    }

    public void setPerson(Person person) {
        this.person = person;

        if (person != null) {
            this.id = person.getPrincipalName();
            this.name = person.getName();
        }
    }

}
