/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.data.provider.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Identifies the annotated class as an extension object for the given baseline class.
 * 
 * <p>Inclusion of this annotation will perform the necessary wiring within JPA.</p>
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 * 
 */
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface ExtensionFor {

	/**
     * (Required) The class for which this one is an extension.
     *
     * @return the class for which this one is an extension.
     */
	Class<?> value();

	/**
     * (Optional) The name of the property on the source object which will hold the extension object.
     *
     * @return the name of the property on the source object which will hold the extension object.
     */
	String extensionPropertyName() default "extension";
}
