/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.data.jpa;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.criteria.Subquery;
import org.apache.commons.lang.StringUtils;
import org.eclipse.persistence.internal.jpa.querydef.PathImpl;

class TranslationContext {
    CriteriaBuilder builder;
    CriteriaQuery<?> query;
    Root root;
    List<Predicate> predicates = new ArrayList<Predicate>();
    TranslationContext parentTranslationContext;

    public static TranslationContext createCriteria(EntityManager entityManager, Class<?> queryClass) {
        return new TranslationContext(entityManager, queryClass, false);
    }

    public static TranslationContext createCriteriaForSubQuery(EntityManager entityManager, Class<?> queryClass, TranslationContext parentContext) {
        return new TranslationContext(entityManager, queryClass, parentContext);
    }

    public static TranslationContext createInnerCriteria(TranslationContext parent) {
        return new TranslationContext(parent);
    }

    public static TranslationContext createCriteriaForCount(EntityManager entityManager, Class<?> queryClass) {
        return new TranslationContext(entityManager, queryClass, true);
    }

    private TranslationContext(EntityManager entityManager, Class<?> queryClass, boolean count) {
        this.builder = entityManager.getCriteriaBuilder();
        if (count) {
            CriteriaQuery q = this.builder.createQuery(Long.class);
            Root r = q.from(queryClass);
            q.select((Selection)this.builder.count((Expression)r));
            this.query = q;
            this.root = r;
        } else {
            this.query = this.builder.createQuery(queryClass);
            this.root = this.query.from(this.query.getResultType());
        }
    }

    private TranslationContext(EntityManager entityManager, Class<?> queryClass, TranslationContext parentContext) {
        this(entityManager, queryClass, false);
        this.parentTranslationContext = parentContext;
    }

    private TranslationContext(TranslationContext parent) {
        this.builder = parent.builder;
        this.query = parent.query;
        this.root = parent.root;
        this.parentTranslationContext = parent.parentTranslationContext;
    }

    void addPredicate(Predicate predicate) {
        this.predicates.add(predicate);
    }

    void and(TranslationContext predicate) {
        this.addPredicate(predicate.getCriteriaPredicate());
    }

    void addExistsSubquery(Subquery<?> subquery) {
        this.predicates.add(this.builder.exists(subquery));
    }

    void or(TranslationContext predicate) {
        ArrayList<Predicate> newpredicates = new ArrayList<Predicate>();
        Predicate criteriaPredicate = this.getCriteriaPredicate();
        Predicate orPredicate = criteriaPredicate != null ? this.builder.or(new Predicate[]{predicate.getCriteriaPredicate(), this.getCriteriaPredicate()}) : this.builder.or(new Predicate[]{predicate.getCriteriaPredicate()});
        newpredicates.add(orPredicate);
        this.predicates = newpredicates;
    }

    Predicate getCriteriaPredicate() {
        if (this.predicates.size() == 1) {
            return this.predicates.get(0);
        }
        if (this.predicates.size() > 1) {
            return this.builder.and(this.predicates.toArray(new Predicate[0]));
        }
        return null;
    }

    <T> Expression<T> attr(String attr) {
        if (StringUtils.isBlank((String)attr)) {
            throw new IllegalArgumentException("Encountered an empty attribute path");
        }
        Root path = this.root;
        if (!attr.contains(".")) {
            path = path.get(attr);
        } else {
            String[] attrArray = attr.split("\\.");
            if (attrArray.length > 0 && StringUtils.equals((String)attrArray[0], (String)"parent") && this.parentTranslationContext != null) {
                return this.parentTranslationContext.attr(StringUtils.substringAfter((String)attr, (String)"."));
            }
            for (String attrElement : attrArray) {
                if (StringUtils.isBlank((String)attrElement)) {
                    throw new IllegalArgumentException("Encountered an empty path element in property path: " + attr);
                }
                boolean existingJoinFoundForThisAttrElement = false;
                ArrayList listOfJoins = new ArrayList(this.root.getJoins());
                for (PathImpl existingJoin : listOfJoins) {
                    if (!existingJoin.getCurrentNode().getName().equalsIgnoreCase(attrElement)) continue;
                    path = existingJoin;
                    existingJoinFoundForThisAttrElement = true;
                }
                if (existingJoinFoundForThisAttrElement) continue;
                path = path.get(attrElement);
            }
        }
        return path;
    }
}

