/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.data.metadata.impl;

import org.kuali.rice.krad.data.metadata.DataObjectAttribute;

/**
 * Interface implemented by the classes within the provider, but that we don't want to expose to use outside of the
 * krad-data module.
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface DataObjectAttributeInternal extends DataObjectAttribute, MetadataCommonInternal {
	/**
    * If this data object attribute is wrapping another (generated by a lower metadata provider), return that.
    *
    * @return <b>null</b> if this attribute is not wrapping another.
    */
	DataObjectAttribute getEmbeddedAttribute();

    /**
    * Sets embedded attribute.
    *
    * @param embeddedAttribute embedded attribute.
    */
	void setEmbeddedAttribute(DataObjectAttribute embeddedAttribute);
}
