/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.data.jpa.converters;

import javax.persistence.AttributeConverter;
import javax.persistence.Converter;
import java.math.BigDecimal;

/**
 * Converts values of 0 or 1 to and from false or true where the field is stored as a Decimal numeric type.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
@Converter
public class Boolean01BigDecimalConverter implements AttributeConverter<Boolean, BigDecimal> {

    /**
     * {@inheritDoc}
     *
     * This implementation will convert from a false or true value to a 0 or 1 Decimal numeric type value.
     */
    @Override
    public BigDecimal convertToDatabaseColumn(Boolean objectValue) {
        if (objectValue == null) {
            return BigDecimal.ZERO;
        }
        return objectValue ? BigDecimal.ONE : BigDecimal.ZERO;
    }

    /**
     * {@inheritDoc}
     *
     * This implementation will convert from a 0 or 1 Decimal numeric type value to a false or true value.
     */
    @Override
    public Boolean convertToEntityAttribute(BigDecimal dataValue){
        if(dataValue == null){
            return false;
        }
        return dataValue.compareTo(BigDecimal.ONE) == 0;
    }

}
