/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.data.metadata.impl;

import org.kuali.rice.krad.data.metadata.MetadataCommon;

/**
 * Interface implemented by the classes within the provider, but that we don't want to expose to use outside of the
 * krad-data module.
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface MetadataCommonInternal extends MetadataCommon {
	/**
	 * If this data object instance is wrapping another (generated by a lower metadata provider), return that.
	 * 
	 * Returns null if this instance is not wrapping another.
	 */
	MetadataCommon getEmbeddedCommonMetadata();

	void setEmbeddedCommonMetadata(MetadataCommon embeddedCommonMetadata);

	/**
	 * An object representing the object for purposes of merging. This should return an attribute name or a unique data
	 * type object.
	 * 
	 * Whatever the class, it must have proper hashCode() and equals() semantics and not rely on object identity.
	 * 
	 * This method must not return null;
	 */
	Object getUniqueKeyForMerging();

}
