/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.data.provider.impl;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.krad.data.metadata.DataObjectAttribute;
import org.kuali.rice.krad.data.metadata.DataObjectMetadata;
import org.kuali.rice.krad.data.metadata.MetadataMergeAction;
import org.kuali.rice.krad.data.metadata.impl.DataObjectAttributeInternal;
import org.kuali.rice.krad.data.metadata.impl.DataObjectMetadataInternal;
import org.kuali.rice.krad.data.provider.CompositeMetadataProvider;
import org.kuali.rice.krad.data.provider.MetadataProvider;
import org.kuali.rice.krad.data.provider.impl.MetadataProviderBase;

public class CompositeMetadataProviderImpl
extends MetadataProviderBase
implements CompositeMetadataProvider {
    private static final Logger LOG = LogManager.getLogger(CompositeMetadataProviderImpl.class);
    protected List<MetadataProvider> providers;

    @Override
    protected synchronized void initializeMetadata(Collection<Class<?>> types) {
        if (LOG.isInfoEnabled()) {
            LOG.info("Initializing Metadata from sources: " + String.valueOf(this.providers));
        }
        this.masterMetadataMap.clear();
        if (!this.providers.isEmpty()) {
            for (MetadataProvider provider : this.providers) {
                if (LOG.isInfoEnabled()) {
                    LOG.info(" *** Processing MetadataProvider: " + String.valueOf(provider));
                }
                Map<Class<?>, DataObjectMetadata> metadata = null;
                metadata = provider.requiresListOfExistingTypes() ? provider.provideMetadataForTypes(this.masterMetadataMap.keySet()) : provider.provideMetadata();
                for (Class<?> dataObjectType : metadata.keySet()) {
                    DataObjectMetadata existingMetadata = (DataObjectMetadata)this.masterMetadataMap.get(dataObjectType);
                    DataObjectMetadata newMetadata = metadata.get(dataObjectType);
                    this.mergeMetadataForType(newMetadata, existingMetadata);
                }
            }
            this.mergeInheritedAttributes();
        }
    }

    protected void mergeInheritedAttributes() {
        for (DataObjectMetadata metadata : this.masterMetadataMap.values()) {
            for (DataObjectAttribute attr : metadata.getAttributes()) {
                DataObjectAttribute originalDataObjectAttribute;
                if (!attr.isInherited()) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Processing inherited attribute on " + String.valueOf(metadata.getType()) + "." + attr.getName() + " : " + String.valueOf(attr.getInheritedFromType()) + " / " + attr.getInheritedFromParentAttributeName() + "." + attr.getInheritedFromAttributeName());
                }
                if ((originalDataObjectAttribute = attr.getOriginalDataObjectAttribute()) == null) {
                    LOG.error("originalDataObjectAttribute was null for " + String.valueOf(attr));
                    continue;
                }
                if (!(originalDataObjectAttribute instanceof DataObjectAttributeInternal)) {
                    LOG.warn("The originalDataObjectAttribute does not implement the DataObjectAttributeInternal interface, we have no access to the embeddedAttribute property: " + String.valueOf(originalDataObjectAttribute));
                }
                Class<?> inheritedFromType = originalDataObjectAttribute.getInheritedFromType();
                String inheritedFromAttributeName = originalDataObjectAttribute.getInheritedFromAttributeName();
                if (inheritedFromType == null || StringUtils.isBlank((String)inheritedFromAttributeName)) {
                    LOG.error("inheritedFromType/inheritedFromAttributeName not completely populated for " + String.valueOf(originalDataObjectAttribute));
                    continue;
                }
                DataObjectMetadata inheritedMetadata = (DataObjectMetadata)this.masterMetadataMap.get(inheritedFromType);
                if (inheritedMetadata == null) {
                    LOG.warn("The metadata object for the inheritance does not exist, skipping: " + String.valueOf(inheritedFromType));
                    continue;
                }
                DataObjectAttribute inheritedAttribute = inheritedMetadata.getAttribute(inheritedFromAttributeName);
                if (inheritedAttribute == null) {
                    LOG.warn("The attribute on the metadata object for the inheritance does not exist, skipping: " + String.valueOf(inheritedFromType) + "." + inheritedFromAttributeName);
                    continue;
                }
                ((DataObjectAttributeInternal)originalDataObjectAttribute).setEmbeddedAttribute(inheritedAttribute);
            }
        }
    }

    protected void mergeMetadataForType(DataObjectMetadata newMetadata, DataObjectMetadata existingMetadata) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Type: " + String.valueOf(newMetadata.getType()) + " : " + String.valueOf(newMetadata));
        }
        if (existingMetadata == null) {
            if (newMetadata.getMergeAction() != MetadataMergeAction.REMOVE) {
                LOG.debug("New Type - Adding metadata to masterMetadataMap");
                this.masterMetadataMap.put(newMetadata.getType(), newMetadata);
            } else {
                LOG.warn("Attempt to REMOVE a DataObjectMetadata which did not exist: " + String.valueOf(newMetadata.getType()));
            }
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Type already exists.  Merging previously retrieved metadata using action " + String.valueOf((Object)newMetadata.getMergeAction()) + " : " + String.valueOf(newMetadata.getType()));
            }
            if (newMetadata.getMergeAction() == MetadataMergeAction.MERGE) {
                if (newMetadata instanceof DataObjectMetadataInternal && existingMetadata instanceof DataObjectMetadataInternal) {
                    ((DataObjectMetadataInternal)newMetadata).setEmbedded((DataObjectMetadataInternal)existingMetadata);
                    this.masterMetadataMap.put(newMetadata.getType(), newMetadata);
                } else {
                    LOG.warn("New or existing Metadata object does not implement the DataObjectMetadataInternal interface, unable to embed the previously retrieved metadata.  REPLACING the entry in the masterMetadataMap (" + String.valueOf(existingMetadata) + ") with the new version: " + String.valueOf(newMetadata));
                    this.masterMetadataMap.put(newMetadata.getType(), newMetadata);
                }
            } else if (newMetadata.getMergeAction() == MetadataMergeAction.REPLACE) {
                this.masterMetadataMap.put(newMetadata.getType(), newMetadata);
            } else if (newMetadata.getMergeAction() == MetadataMergeAction.REMOVE) {
                this.masterMetadataMap.remove(newMetadata.getType());
            } else if (newMetadata.getMergeAction() != MetadataMergeAction.NO_OVERRIDE) {
                LOG.warn("Unsupported MetadataMergeAction: " + String.valueOf((Object)newMetadata.getMergeAction()) + " on " + String.valueOf(newMetadata));
            }
        }
    }

    @Override
    public List<MetadataProvider> getProviders() {
        return this.providers;
    }

    public void setProviders(List<MetadataProvider> providers) {
        this.providers = providers;
    }
}

