/*
 * Decompiled with CFR 0.152.
 */
package edu.sampleu.travel.dataobject;

import edu.sampleu.travel.dataobject.TravelDestination;
import edu.sampleu.travel.dataobject.TravelExpenseItem;
import edu.sampleu.travel.dataobject.TravelPerDiemExpense;
import edu.sampleu.travel.dataobject.TravelerDetail;
import edu.sampleu.travel.options.TripTypeKeyValuesFinder;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.AssociationOverride;
import javax.persistence.AssociationOverrides;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.krad.data.jpa.converters.KualiDecimalConverter;
import org.kuali.rice.krad.data.provider.annotation.Description;
import org.kuali.rice.krad.data.provider.annotation.KeyValuesFinderClass;
import org.kuali.rice.krad.data.provider.annotation.Label;
import org.kuali.rice.krad.data.provider.annotation.UifAutoCreateViewType;
import org.kuali.rice.krad.data.provider.annotation.UifAutoCreateViews;
import org.kuali.rice.krad.data.provider.annotation.UifDisplayHint;
import org.kuali.rice.krad.data.provider.annotation.UifDisplayHintType;
import org.kuali.rice.krad.data.provider.annotation.UifDisplayHints;
import org.kuali.rice.krad.document.Copyable;
import org.kuali.rice.krad.document.TransactionalDocumentBase;

@Entity
@Table(name="TRVL_AUTH_DOC_T")
@AttributeOverrides(value={@AttributeOverride(name="documentNumber", column=@Column(name="TRVL_AUTH_DOC_ID", insertable=true, updatable=true, length=14))})
@AssociationOverrides(value={@AssociationOverride(name="pessimisticLocks", joinColumns={@JoinColumn(name="TRVL_AUTH_DOC_ID", insertable=false, updatable=false)})})
@UifAutoCreateViews(value={UifAutoCreateViewType.INQUIRY, UifAutoCreateViewType.LOOKUP})
public class TravelAuthorizationDocument
extends TransactionalDocumentBase
implements Copyable {
    private static final long serialVersionUID = -6609385831976630737L;
    @Temporal(value=TemporalType.DATE)
    @Column(name="TRVL_BGN_DT")
    @Label(value="Trip Begin Date")
    private Date tripBegin;
    @Temporal(value=TemporalType.DATE)
    @Column(name="TRVL_END_DT")
    @Label(value="Trip End Date")
    private Date tripEnd;
    @Column(name="TRVL_DESC", length=255)
    @Label(value="Business Purpose")
    private String tripDescription;
    @Column(name="TRVL_DEST_ID", length=40)
    private String tripDestinationId;
    @Transient
    private TravelDestination tripDestination;
    @Column(name="TRAVELER_DTL_ID", length=40)
    private String travelerDetailId;
    @Transient
    private TravelerDetail travelerDetail;
    @Column(name="TRVL_TYP_CD", length=40)
    @Label(value="Travel type code")
    @Description(value="Trip Type")
    @KeyValuesFinderClass(value=TripTypeKeyValuesFinder.class)
    @UifDisplayHints(value={@UifDisplayHint(value=UifDisplayHintType.DROPDOWN), @UifDisplayHint(value=UifDisplayHintType.NO_INQUIRY)})
    private String travelTypeCode;
    @Column(name="EXP_LMT", length=19, precision=2)
    @Label(value="Expense Limit")
    @Convert(converter=KualiDecimalConverter.class)
    @Description(value="Expense limit imposed by department or grant or some other budgetary restrictions on trip.")
    private KualiDecimal expenseLimit;
    @Column(name="CELL_PH_NUM", length=20)
    @Label(value="Contact Number")
    @Description(value="This is the contact phone number during the trip.")
    private String cellPhoneNumber;
    @OneToMany(fetch=FetchType.EAGER, orphanRemoval=true, cascade={CascadeType.ALL}, mappedBy="travelAuthorizationDocument")
    private List<TravelPerDiemExpense> dailyExpenseEstimates = new ArrayList<TravelPerDiemExpense>();
    @OneToMany(fetch=FetchType.EAGER, orphanRemoval=true, cascade={CascadeType.ALL}, mappedBy="travelAuthorizationDocument")
    private List<TravelExpenseItem> actualExpenseItems = new ArrayList<TravelExpenseItem>();

    public Date getTripBegin() {
        return this.tripBegin;
    }

    public void setTripBegin(Date tripBegin) {
        this.tripBegin = tripBegin;
    }

    public Date getTripEnd() {
        return this.tripEnd;
    }

    public void setTripEnd(Date tripEnd) {
        this.tripEnd = tripEnd;
    }

    public String getTripDescription() {
        return this.tripDescription;
    }

    public void setTripDescription(String tripDescription) {
        this.tripDescription = tripDescription;
    }

    public String getTravelerDetailId() {
        return this.travelerDetailId;
    }

    public void setTravelerDetailId(String travelerDetailId) {
        this.travelerDetailId = travelerDetailId;
    }

    public TravelerDetail getTravelerDetail() {
        return this.travelerDetail;
    }

    public void setTravelerDetail(TravelerDetail travelerDetail) {
        this.travelerDetail = travelerDetail;
    }

    public String getCellPhoneNumber() {
        return this.cellPhoneNumber;
    }

    public void setCellPhoneNumber(String cellPhoneNumber) {
        this.cellPhoneNumber = cellPhoneNumber;
    }

    public KualiDecimal getExpenseLimit() {
        return this.expenseLimit;
    }

    public void setExpenseLimit(KualiDecimal expenseLimit) {
        this.expenseLimit = expenseLimit;
    }

    public String getTripDestinationId() {
        return this.tripDestinationId;
    }

    public void setTripDestinationId(String tripDestinationId) {
        this.tripDestinationId = tripDestinationId;
    }

    public TravelDestination getTripDestination() {
        return this.tripDestination;
    }

    public void setTripDestination(TravelDestination tripDestination) {
        this.tripDestination = tripDestination;
    }

    public List<TravelPerDiemExpense> getDailyExpenseEstimates() {
        return this.dailyExpenseEstimates;
    }

    public void setDailyExpenseEstimates(List<TravelPerDiemExpense> dailyExpenseEstimates) {
        this.dailyExpenseEstimates = dailyExpenseEstimates;
    }

    public List<TravelExpenseItem> getActualExpenseItems() {
        return this.actualExpenseItems;
    }

    public void setActualExpenseItems(List<TravelExpenseItem> actualExpenseItems) {
        this.actualExpenseItems = actualExpenseItems;
    }

    public String getTravelTypeCode() {
        return this.travelTypeCode;
    }

    public void setTravelTypeCode(String travelTypeCode) {
        this.travelTypeCode = travelTypeCode;
    }
}

