/*
 * Decompiled with CFR 0.152.
 */
package edu.sampleu.travel.dataobject;

import edu.sampleu.travel.options.PostalCountryCode;
import edu.sampleu.travel.options.PostalCountryCodeKeyValuesFinder;
import edu.sampleu.travel.options.PostalStateCode;
import edu.sampleu.travel.options.PostalStateCodeKeyValuesFinder;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.kuali.rice.core.api.mo.common.active.MutableInactivatable;
import org.kuali.rice.krad.bo.DataObjectBase;
import org.kuali.rice.krad.data.jpa.PortableSequenceGenerator;
import org.kuali.rice.krad.data.jpa.converters.BooleanYNConverter;
import org.kuali.rice.krad.data.provider.annotation.Description;
import org.kuali.rice.krad.data.provider.annotation.KeyValuesFinderClass;
import org.kuali.rice.krad.data.provider.annotation.Label;
import org.kuali.rice.krad.data.provider.annotation.UifAutoCreateViewType;
import org.kuali.rice.krad.data.provider.annotation.UifAutoCreateViews;
import org.kuali.rice.krad.data.provider.annotation.UifDisplayHint;
import org.kuali.rice.krad.data.provider.annotation.UifDisplayHintType;
import org.kuali.rice.krad.data.provider.annotation.UifDisplayHints;
import org.kuali.rice.krad.data.provider.annotation.UifValidCharactersConstraintBeanName;

@Entity
@Table(name="TRVL_DEST_T")
@UifAutoCreateViews(value={UifAutoCreateViewType.INQUIRY, UifAutoCreateViewType.LOOKUP})
public class TravelDestination
extends DataObjectBase
implements MutableInactivatable,
Serializable {
    private static final long serialVersionUID = 8448891916448081149L;
    @Id
    @Column(name="TRVL_DEST_ID", length=40)
    @GeneratedValue(generator="TRVL_DEST_ID_S")
    @PortableSequenceGenerator(name="TRVL_DEST_ID_S")
    @Label(value="Id")
    @Description(value="Unique identifier for destination item")
    @UifValidCharactersConstraintBeanName(value="AlphaNumericPatternConstraint")
    private String travelDestinationId;
    @Column(name="DEST_NM", length=40)
    @Label(value="Destination")
    @Description(value="Name of location")
    private String travelDestinationName;
    @Column(name="POSTAL_CNTRY_CD")
    @UifDisplayHints(value={@UifDisplayHint(value=UifDisplayHintType.NO_LOOKUP_RESULT), @UifDisplayHint(value=UifDisplayHintType.NO_INQUIRY)})
    @KeyValuesFinderClass(value=PostalCountryCodeKeyValuesFinder.class)
    @Label(value="Country")
    private String countryCd;
    @Transient
    @UifDisplayHints(value={@UifDisplayHint(value=UifDisplayHintType.NO_LOOKUP_CRITERIA)})
    @Label(value="Country")
    private String countryName;
    @Column(name="POSTAL_STATE_CD")
    @UifDisplayHints(value={@UifDisplayHint(value=UifDisplayHintType.NO_LOOKUP_RESULT), @UifDisplayHint(value=UifDisplayHintType.NO_INQUIRY)})
    @KeyValuesFinderClass(value=PostalStateCodeKeyValuesFinder.class)
    @Label(value="State")
    private String stateCd;
    @Transient
    @UifDisplayHints(value={@UifDisplayHint(value=UifDisplayHintType.NO_LOOKUP_CRITERIA)})
    @Label(value="State")
    private String stateName;
    @Column(name="ACTV_IND", nullable=false, length=1)
    @Convert(converter=BooleanYNConverter.class)
    @Label(value="Active")
    @Description(value="Whether active or inactive")
    private boolean active = Boolean.TRUE;

    public String getTravelDestinationId() {
        return this.travelDestinationId;
    }

    public void setTravelDestinationId(String travelDestinationId) {
        this.travelDestinationId = travelDestinationId;
    }

    public String getTravelDestinationName() {
        return this.travelDestinationName;
    }

    public void setTravelDestinationName(String travelDestinationName) {
        this.travelDestinationName = travelDestinationName;
    }

    public String getCountryCd() {
        return this.countryCd;
    }

    public void setCountryCd(String countryCd) {
        this.countryCd = countryCd;
    }

    public String getCountryName() {
        return PostalCountryCode.valueOf(this.countryCd).getLabel();
    }

    public String getStateCd() {
        return this.stateCd;
    }

    public void setStateCd(String stateCd) {
        this.stateCd = stateCd;
    }

    public String getStateName() {
        return PostalStateCode.valueOf(this.stateCd).getLabel();
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }
}

