/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.theme.util;

import java.io.File;
import java.io.FilenameFilter;

/**
 * Filter implementation that excludes non-directories and hidden directories (those that start with ".")
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class NonHiddenDirectoryFilter implements FilenameFilter {

    /**
     * @see java.io.FilenameFilter#accept(java.io.File, java.lang.String)
     */
    @Override
    public boolean accept(File dir, String name) {
        return dir.isDirectory() && !name.startsWith(".");
    }
}
