/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.runnable.impl;

import java.text.NumberFormat;
import java.util.Date;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RunnablesRunnable
implements Runnable {
    private static final String NO_NULLS = "null not allowed";
    public static final double SECOND = 1000.0;
    public static final double MINUTE = 60000.0;
    public static final double HOUR = 3600000.0;
    public static final double DAY = 8.64E7;
    public static final double YEAR = 3.1536E10;
    private static final Logger logger = LogManager.getLogger(RunnablesRunnable.class);
    private final List<Runnable> runnables;
    private final boolean skip;
    private final boolean timed;

    public RunnablesRunnable(List<? extends Runnable> runnables) {
        this(runnables, false);
    }

    public RunnablesRunnable(List<? extends Runnable> runnables, boolean skip) {
        this(runnables, skip, false);
    }

    public RunnablesRunnable(List<? extends Runnable> runnables, boolean skip, boolean timed) {
        RunnablesRunnable.noNulls(runnables);
        this.runnables = List.copyOf(runnables);
        this.skip = skip;
        this.timed = timed;
    }

    @Override
    public void run() {
        if (this.skip) {
            logger.info("Skipping execution of {} runnables", (Object)this.runnables.size());
            return;
        }
        long start = System.currentTimeMillis();
        for (Runnable runnable : this.runnables) {
            runnable.run();
        }
        if (this.timed) {
            long stop = System.currentTimeMillis();
            logger.info("------------------------------------------------------------------------");
            logger.info("Total Time: {}", (Object)RunnablesRunnable.getTime(stop - start));
            logger.info("Finished at: {}", (Object)new Date(stop));
            logger.info("------------------------------------------------------------------------");
        }
    }

    public List<Runnable> getrunnables() {
        return this.runnables;
    }

    public boolean isSkip() {
        return this.skip;
    }

    public boolean isTimed() {
        return this.timed;
    }

    private static void noNulls(Object ... objects) {
        RunnablesRunnable.noNullsWithMsg(NO_NULLS, objects);
    }

    private static void noNullsWithMsg(String msg, Object ... objects) {
        for (Object object : objects) {
            if (object == null) {
                throw new AssertionError((Object)msg);
            }
        }
    }

    public static String getTime(long millis) {
        return RunnablesRunnable.getTime(millis, NumberFormat.getInstance());
    }

    public static String getTime(long millis, NumberFormat formatter) {
        long abs = Math.abs(millis);
        if ((double)abs < 1000.0) {
            return millis + "ms";
        }
        if ((double)abs < 60000.0) {
            return formatter.format((double)millis / 1000.0) + "s";
        }
        if ((double)abs < 3600000.0) {
            return formatter.format((double)millis / 60000.0) + "m";
        }
        if ((double)abs < 8.64E7) {
            return formatter.format((double)millis / 3600000.0) + "h";
        }
        if ((double)abs < 3.1536E10) {
            return formatter.format((double)millis / 8.64E7) + "d";
        }
        return formatter.format((double)millis / 3.1536E10) + "y";
    }
}

