/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.theme;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.codehaus.plexus.util.FileUtils;
import org.kuali.rice.krad.theme.ThemeBuilder;
import org.kuali.rice.krad.theme.util.ThemeBuilderUtils;

public class ThemeBuilderOverlays {
    private static final Logger LOG = LogManager.getLogger(ThemeBuilder.class);

    protected static void copyAssetsToWorkingDir(String webappSourceDir, String themeBuilderOutputDir, List<String> additionalThemeDirectories, List<String> additionalPluginDirectories) throws IOException {
        if (StringUtils.isBlank((String)themeBuilderOutputDir)) {
            throw new IllegalStateException("Working directory for theme builder not set");
        }
        File webappSource = new File(webappSourceDir);
        if (!webappSource.exists()) {
            throw new RuntimeException("Webapp source directory does not exist");
        }
        File workingDir = new File(themeBuilderOutputDir);
        if (!workingDir.exists()) {
            workingDir.mkdir();
        }
        workingDir.setWritable(true);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Copying script, theme, plugin resource to working dir: " + themeBuilderOutputDir);
        }
        ThemeBuilderUtils.copyDirectory(webappSourceDir + "/krad/scripts", themeBuilderOutputDir + "/krad/scripts");
        ThemeBuilderUtils.copyDirectory(webappSourceDir + "/themes", themeBuilderOutputDir + "/themes");
        if (additionalThemeDirectories != null) {
            for (String additionalThemeDirectory : additionalThemeDirectories) {
                ThemeBuilderUtils.copyDirectory(webappSourceDir + additionalThemeDirectory, themeBuilderOutputDir + additionalThemeDirectory);
            }
        }
        ThemeBuilderUtils.copyDirectory(webappSourceDir + "/plugins", themeBuilderOutputDir + "/plugins");
        if (additionalPluginDirectories != null) {
            for (String additionalPluginDirectory : additionalPluginDirectories) {
                ThemeBuilderUtils.copyDirectory(webappSourceDir + additionalPluginDirectory, themeBuilderOutputDir + additionalPluginDirectory);
            }
        }
    }

    protected static void overlayParentAssets(String themeName, File themeDirectory, Properties themeProperties, Map<String, String> themeNamePathMapping) {
        if (!themeProperties.containsKey("parent")) {
            return;
        }
        String parentThemeName = themeProperties.getProperty("parent");
        if (StringUtils.isBlank((String)parentThemeName)) {
            return;
        }
        LOG.info("Overlaying assets from parent " + parentThemeName + " to child " + themeName);
        String[] parentExcludes = ThemeBuilderUtils.getPropertyValueAsArray("parentExcludes", themeProperties);
        String parentThemePath = themeNamePathMapping.get(parentThemeName);
        File parentThemeDirectory = new File(parentThemePath);
        if (!parentThemeDirectory.exists()) {
            throw new RuntimeException("Parent theme does not exist at path: " + parentThemePath);
        }
        ArrayList<String> copyDirectoryExcludes = new ArrayList<String>();
        copyDirectoryExcludes.add("theme.properties");
        if (parentExcludes != null) {
            copyDirectoryExcludes.addAll(Arrays.asList(parentExcludes));
        }
        try {
            ThemeBuilderUtils.copyMissingContent(parentThemeDirectory, themeDirectory, copyDirectoryExcludes);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to copy parent theme directory", e);
        }
    }

    protected static void overlayAdditionalDirs(File themeDirectory, Properties themeProperties, String webappSourceDir, String themeBuilderOutputDir) {
        if (!themeProperties.containsKey("additionalOverlays")) {
            return;
        }
        String additionalOverlaysStr = themeProperties.getProperty("additionalOverlays");
        Map<String, String> additionalOverlays = ThemeBuilderOverlays.parseAdditionalOverlaysStr(additionalOverlaysStr);
        for (Map.Entry<String, String> overlayMapping : additionalOverlays.entrySet()) {
            File targetDir;
            String fromSource = overlayMapping.getKey();
            String toThemeDir = overlayMapping.getValue();
            if (StringUtils.isBlank((String)fromSource)) {
                throw new RuntimeException("Invalid additional overlay mapping, from directory is blank");
            }
            File sourceFile = null;
            if (fromSource.startsWith("/")) {
                sourceFile = new File(themeBuilderOutputDir + fromSource);
                if (!sourceFile.exists()) {
                    sourceFile = new File(webappSourceDir + fromSource);
                }
            } else {
                sourceFile = new File(themeDirectory, fromSource);
            }
            if (!sourceFile.exists()) {
                throw new RuntimeException("Source directory/file for additional overlay does not exist at " + sourceFile.getPath());
            }
            if (StringUtils.isBlank((String)toThemeDir)) {
                targetDir = themeDirectory;
            } else {
                if (toThemeDir.startsWith("/")) {
                    toThemeDir = toThemeDir.substring(1);
                }
                targetDir = new File(themeDirectory, toThemeDir);
            }
            if (!targetDir.exists()) {
                targetDir.mkdir();
            }
            try {
                if (sourceFile.isDirectory()) {
                    ThemeBuilderUtils.copyMissingContent(sourceFile, targetDir, null);
                    continue;
                }
                File targetFile = new File(targetDir, sourceFile.getName());
                FileUtils.copyFile((File)sourceFile, (File)targetFile);
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to perform additional overlay", e);
            }
        }
    }

    protected static Map<String, String> parseAdditionalOverlaysStr(String additionalOverlaysStr) {
        String[] additionalOverlaysArray;
        HashMap<String, String> additionalOverlays = new HashMap<String, String>();
        if (StringUtils.isBlank((String)additionalOverlaysStr)) {
            return additionalOverlays;
        }
        for (String additionalOverlay : additionalOverlaysArray = additionalOverlaysStr.split(",")) {
            String fromDir;
            String toDir = "";
            if (additionalOverlay.contains("(") && additionalOverlay.contains(")")) {
                fromDir = StringUtils.substringBefore((String)additionalOverlay, (String)"(");
                toDir = StringUtils.substringBetween((String)additionalOverlay, (String)"(", (String)")");
            } else {
                fromDir = additionalOverlay;
            }
            additionalOverlays.put(StringUtils.trimToEmpty((String)fromDir), StringUtils.trimToEmpty((String)toDir));
        }
        return additionalOverlays;
    }
}

