/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.theme.preprocessor;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.krad.theme.preprocessor.ThemePreProcessor;
import org.kuali.rice.krad.theme.util.ThemeBuilderUtils;
import org.lesscss.LessCompiler;
import org.lesscss.LessException;
import org.lesscss.LessSource;

public class LessThemePreProcessor
implements ThemePreProcessor {
    private static final Logger LOG = LogManager.getLogger(LessThemePreProcessor.class);

    @Override
    public void processTheme(String themeName, File themeDirectory, Properties themeProperties) {
        File stylesheetsDirectory;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Performing Less compilation for theme " + themeName);
        }
        if (!(stylesheetsDirectory = new File(themeDirectory, "stylesheets")).exists()) {
            throw new RuntimeException("Stylesheets directory does not exist for theme: " + themeName);
        }
        List<String> lessFileNames = this.getLessFileNamesForTheme(themeName, themeDirectory, themeProperties, stylesheetsDirectory);
        LessCompiler lessCompiler = new LessCompiler();
        lessCompiler.setCompress(false);
        for (String lessFileName : lessFileNames) {
            LOG.info("compiling less file: " + lessFileName);
            File sourceLessFile = new File(stylesheetsDirectory, lessFileName);
            File compiledLessFile = new File(stylesheetsDirectory, lessFileName.replace(".less", ".css"));
            try {
                LessSource lessSource = new LessSource(sourceLessFile);
                lessCompiler.compile(lessSource, compiledLessFile, true);
            }
            catch (IOException e) {
                throw new RuntimeException("Error while compiling LESS source: " + lessFileName, e);
            }
            catch (LessException e) {
                throw new RuntimeException("Error while compiling LESS source: " + lessFileName, e);
            }
        }
        themeProperties.put("themeLessFiles", StringUtils.join(lessFileNames, (String)","));
    }

    protected List<String> getLessFileNamesForTheme(String themeName, File themeDirectory, Properties themeProperties, File stylesheetsDirectory) {
        String[] lessIncludes = ThemeBuilderUtils.getPropertyValueAsArray("lessIncludes", themeProperties);
        if (lessIncludes == null || lessIncludes.length == 0) {
            lessIncludes = new String[]{"**/*.less"};
        }
        String[] lessExcludes = ThemeBuilderUtils.getPropertyValueAsArray("lessExcludes", themeProperties);
        lessExcludes = ThemeBuilderUtils.addToArray(lessExcludes, "includes/*");
        return ThemeBuilderUtils.getDirectoryContents(stylesheetsDirectory, lessIncludes, lessExcludes);
    }
}

