/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.datadictionary.validator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.rice.krad.datadictionary.DataDictionary;
import org.kuali.rice.krad.datadictionary.DataDictionaryEntry;
import org.kuali.rice.krad.datadictionary.DataDictionaryException;
import org.kuali.rice.krad.datadictionary.uif.UifBeanFactoryPostProcessor;
import org.kuali.rice.krad.datadictionary.uif.UifDictionaryBean;
import org.kuali.rice.krad.datadictionary.validator.ErrorReport;
import org.kuali.rice.krad.datadictionary.validator.ValidationTrace;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycle;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycleUtils;
import org.kuali.rice.krad.uif.util.LifecycleElement;
import org.kuali.rice.krad.uif.view.View;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

public class Validator {
    private static final Log LOG = LogFactory.getLog(Validator.class);
    private static ArrayList<ErrorReport> errorReports = new ArrayList();
    private ValidationTrace tracerTemp = new ValidationTrace();
    private int numberOfErrors = 0;
    private int numberOfWarnings = 0;

    public static void addErrorReport(ErrorReport report) {
        errorReports.add(report);
    }

    public static void resetErrorReport() {
        errorReports = new ArrayList();
    }

    private boolean runValidations(DefaultListableBeanFactory beans, boolean failOnWarning) {
        LOG.info((Object)"Starting Dictionary Validation");
        Validator.resetErrorReport();
        try {
            Map uifBeans = beans.getBeansOfType(View.class);
            for (View views : uifBeans.values()) {
                try {
                    ValidationTrace tracer = this.tracerTemp.getCopy();
                    if (!this.doValidationOnUIFBean(views)) continue;
                    tracer.setValidationStage(0);
                    this.runValidationsOnComponents(views, tracer);
                }
                catch (Exception e) {
                    String[] value = new String[]{views.getId(), "Exception = " + e.getMessage()};
                    this.tracerTemp.createError("Error Validating Bean View", value);
                }
            }
        }
        catch (Exception e) {
            String[] value = new String[]{"Validation set = views", "Exception = " + e.getMessage()};
            this.tracerTemp.createError("Error in Loading Spring Beans", value);
        }
        try {
            Map ddBeans = beans.getBeansOfType(DataDictionaryEntry.class);
            for (DataDictionaryEntry entry : ddBeans.values()) {
                try {
                    ValidationTrace tracer = this.tracerTemp.getCopy();
                    tracer.setValidationStage(1);
                    entry.completeValidation(tracer);
                }
                catch (Exception e) {
                    String[] value = new String[]{"Validation set = Data Dictionary Entries", "Exception = " + e.getMessage()};
                    this.tracerTemp.createError("Error in Loading Spring Beans", value);
                }
            }
        }
        catch (Exception e) {
            String[] value = new String[]{"Validation set = Data Dictionary Entries", "Exception = " + e.getMessage()};
            this.tracerTemp.createError("Error in Loading Spring Beans", value);
        }
        this.compileFinalReport();
        LOG.info((Object)"Completed Dictionary Validation");
        if (this.numberOfErrors > 0) {
            return false;
        }
        return !failOnWarning || this.numberOfWarnings <= 0;
    }

    public boolean validate(Component object, boolean failOnWarning) {
        LOG.info((Object)"Starting Dictionary Validation");
        if (this.doValidationOnUIFBean(object)) {
            ValidationTrace tracer = this.tracerTemp.getCopy();
            Validator.resetErrorReport();
            tracer.setValidationStage(1);
            LOG.debug((Object)("Validating Component: " + object.getId()));
            object.completeValidation(tracer.getCopy());
            this.runValidationsOnLifecycle(object, tracer.getCopy());
        }
        this.compileFinalReport();
        LOG.info((Object)"Completed Dictionary Validation");
        if (this.numberOfErrors > 0) {
            return false;
        }
        return !failOnWarning || this.numberOfWarnings <= 0;
    }

    public boolean validate(String[] xmlFiles, boolean failOnWarning) {
        DefaultListableBeanFactory beans = this.loadBeans(xmlFiles);
        return this.runValidations(beans, failOnWarning);
    }

    public boolean validate(String[] xmlFiles, ResourceLoader loader, DefaultListableBeanFactory beans, boolean failOnWarning) {
        this.tracerTemp = new ValidationTrace(xmlFiles, loader);
        return this.runValidations(beans, failOnWarning);
    }

    private void runValidationsOnComponents(Component component, ValidationTrace tracer) {
        String[] value;
        try {
            ViewLifecycle.getExpressionEvaluator().populatePropertyExpressionsFromGraph(component, false);
        }
        catch (Exception e) {
            value = new String[]{"view = " + component.getId()};
            this.tracerTemp.createError("Error Validating Bean View while loading expressions", value);
        }
        LOG.debug((Object)("Validating View: " + component.getId()));
        try {
            component.completeValidation(tracer.getCopy());
        }
        catch (Exception e) {
            value = new String[]{component.getId()};
            this.tracerTemp.createError("Error Validating Bean View", value);
        }
        try {
            this.runValidationsOnLifecycle(component, tracer.getCopy());
        }
        catch (Exception e) {
            value = new String[]{component.getId(), ViewLifecycleUtils.getElementsForLifecycle(component).size() + "", "Exception " + e.getMessage()};
            this.tracerTemp.createError("Error Validating Bean Lifecycle", value);
        }
    }

    private void runValidationsOnLifecycle(LifecycleElement element, ValidationTrace tracer) {
        Map<String, LifecycleElement> nestedComponents = ViewLifecycleUtils.getElementsForLifecycle(element, "INITIALIZE");
        if (nestedComponents == null) {
            return;
        }
        Component component = null;
        if (element instanceof Component) {
            component = (Component)element;
            if (!this.doValidationOnUIFBean(component)) {
                return;
            }
            tracer.addBean(component);
        }
        for (LifecycleElement temp : nestedComponents.values()) {
            if (!(temp instanceof Component)) continue;
            if (tracer.getValidationStage() == 0) {
                ViewLifecycle.getExpressionEvaluator().populatePropertyExpressionsFromGraph((UifDictionaryBean)((Object)temp), false);
            }
            if (!((Component)temp).isRender()) continue;
            ((DataDictionaryEntry)((Object)temp)).completeValidation(tracer.getCopy());
            this.runValidationsOnLifecycle(temp, tracer.getCopy());
        }
        ViewLifecycleUtils.recycleElementMap(nestedComponents);
    }

    private boolean doValidationOnUIFBean(Component component) {
        if (component.getId() == null) {
            return true;
        }
        if (component.getId().length() < 3) {
            return true;
        }
        String temp = component.getId().substring(0, 3).toLowerCase();
        return !temp.contains("uif");
    }

    public static boolean validateSpringEL(String expression) {
        if (expression == null) {
            return true;
        }
        if (expression.compareTo("") == 0) {
            return true;
        }
        if (expression.length() <= 3) {
            return false;
        }
        if (!(expression.substring(0, 1).contains("@") && expression.substring(1, 2).contains("{") && expression.substring(expression.length() - 1, expression.length()).contains("}"))) {
            return false;
        }
        expression = expression.substring(2, expression.length() - 2);
        ArrayList<String> values = Validator.getExpressionValues(expression);
        for (int i = 0; i < values.size(); ++i) {
            Validator.checkPropertyName(values.get(i));
        }
        return true;
    }

    private static ArrayList<String> getExpressionValues(String expression) {
        expression = StringUtils.replace((String)expression, (String)"!=", (String)" != ");
        expression = StringUtils.replace((String)expression, (String)"==", (String)" == ");
        expression = StringUtils.replace((String)expression, (String)">", (String)" > ");
        expression = StringUtils.replace((String)expression, (String)"<", (String)" < ");
        expression = StringUtils.replace((String)expression, (String)"<=", (String)" <= ");
        expression = StringUtils.replace((String)expression, (String)">=", (String)" >= ");
        ArrayList<String> controlNames = new ArrayList<String>();
        controlNames.addAll(ViewLifecycle.getExpressionEvaluator().findControlNamesInExpression(expression));
        return controlNames;
    }

    private static boolean checkPropertyName(String name) {
        return Character.isLetter(name.charAt(0));
    }

    public static boolean checkExpressions(Component object, String property) {
        return object.getPropertyExpressions().containsKey(property);
    }

    private void compileFinalReport() {
        ArrayList<ErrorReport> reports = errorReports;
        for (int i = 0; i < reports.size(); ++i) {
            if (reports.get(i).getErrorStatus() == 1) {
                ++this.numberOfErrors;
                continue;
            }
            if (reports.get(i).getErrorStatus() != 2) continue;
            ++this.numberOfWarnings;
        }
    }

    public DefaultListableBeanFactory loadBeans(String[] xmlFiles) {
        LOG.info((Object)"Starting XML File Load");
        DefaultListableBeanFactory beans = new DefaultListableBeanFactory();
        XmlBeanDefinitionReader xmlReader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)beans);
        DataDictionary.setupProcessor(beans);
        ArrayList<String> coreFiles = new ArrayList<String>();
        ArrayList<String> testFiles = new ArrayList<String>();
        for (int i = 0; i < xmlFiles.length; ++i) {
            if (xmlFiles[i].contains("classpath")) {
                coreFiles.add(xmlFiles[i]);
                continue;
            }
            testFiles.add(xmlFiles[i]);
        }
        String[] core = new String[coreFiles.size()];
        coreFiles.toArray(core);
        String[] test = new String[testFiles.size()];
        testFiles.toArray(test);
        try {
            xmlReader.loadBeanDefinitions(core);
        }
        catch (Exception e) {
            LOG.error((Object)"Error loading bean definitions", (Throwable)e);
            throw new DataDictionaryException("Error loading bean definitions: " + e.getLocalizedMessage(), e);
        }
        try {
            xmlReader.loadBeanDefinitions(this.getResources(test));
        }
        catch (Exception e) {
            LOG.error((Object)"Error loading bean definitions", (Throwable)e);
            throw new DataDictionaryException("Error loading bean definitions: " + e.getLocalizedMessage(), e);
        }
        UifBeanFactoryPostProcessor factoryPostProcessor = new UifBeanFactoryPostProcessor();
        factoryPostProcessor.postProcessBeanFactory((ConfigurableListableBeanFactory)beans);
        this.tracerTemp = new ValidationTrace(xmlFiles, xmlReader.getResourceLoader());
        LOG.info((Object)"Completed XML File Load");
        return beans;
    }

    private Resource[] getResources(String[] files) {
        Resource[] resources = new Resource[files.length];
        for (int i = 0; i < files.length; ++i) {
            resources[0] = new FileSystemResource(files[i]);
        }
        return resources;
    }

    public int getNumberOfErrors() {
        return this.numberOfErrors;
    }

    public int getNumberOfWarnings() {
        return this.numberOfWarnings;
    }

    public ErrorReport getErrorReport(int index) {
        return errorReports.get(index);
    }

    public int getErrorReportSize() {
        return errorReports.size();
    }

    public static List<ErrorReport> getErrorReports() {
        return Collections.unmodifiableList(errorReports);
    }
}

