/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.field;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.uif.UifConstants;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.component.ComponentBase;
import org.kuali.rice.krad.uif.component.ComponentSecurity;
import org.kuali.rice.krad.uif.component.DelayedCopy;
import org.kuali.rice.krad.uif.element.Label;
import org.kuali.rice.krad.uif.field.DataFieldBase;
import org.kuali.rice.krad.uif.field.Field;
import org.kuali.rice.krad.uif.field.FieldSecurity;
import org.kuali.rice.krad.uif.field.SpaceField;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycle;
import org.kuali.rice.krad.uif.util.ComponentFactory;
import org.kuali.rice.krad.uif.util.LifecycleElement;
import org.kuali.rice.krad.uif.util.MessageStructureUtils;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.util.KRADUtils;

@BeanTag(name="fieldBase", parent="Uif-FieldBase")
public class FieldBase
extends ComponentBase
implements Field {
    private static final long serialVersionUID = -5888414844802862760L;
    private static final Logger LOG = Logger.getLogger(FieldBase.class);
    private String shortLabel;
    @DelayedCopy
    private Label fieldLabel;
    private boolean labelLeft;
    private boolean labelRendered = false;

    @Override
    public void performApplyModel(Object model, LifecycleElement parent) {
        super.performApplyModel(model, parent);
        if (!this.labelRendered && this.fieldLabel == null) {
            if (this instanceof DataFieldBase) {
                LOG.warn((Object)("DataField (" + this.getClass().getName() + ") ID: " + this.getId() + ", propertyName: " + ((DataFieldBase)this).getPropertyName() + " has no label. A hidden default label will be created."));
                this.setLabel(((DataFieldBase)this).getPropertyName());
                this.setLabelRendered(false);
                this.setShowLabel(true);
            } else if (!(this instanceof SpaceField)) {
                LOG.warn((Object)("Field (" + this.getClass().getName() + ") ID: " + this.getId() + " has no label."));
            }
        }
    }

    @Override
    public void afterEvaluateExpression() {
        super.afterEvaluateExpression();
        if (this.getReadOnly() == null) {
            Component parent = ViewLifecycle.getPhase().getParent();
            this.setReadOnly(parent == null ? null : parent.getReadOnly());
        }
    }

    @Override
    public void performFinalize(Object model, LifecycleElement parent) {
        super.performFinalize(model, parent);
        if (this.fieldLabel != null) {
            this.fieldLabel.setLabelForComponentId(this.getId());
            if (this.getRequired() != null && this.getRequired().booleanValue()) {
                View view = ViewLifecycle.getView();
                if (view.getViewTypeName() != null && view.getViewTypeName().equals((Object)UifConstants.ViewType.MAINTENANCE)) {
                    this.fieldLabel.setRenderRequiredIndicator(!Boolean.TRUE.equals(view.getReadOnly()));
                } else {
                    this.fieldLabel.setRenderRequiredIndicator(!Boolean.TRUE.equals(this.getReadOnly()));
                }
            } else {
                this.setRequired(false);
                this.fieldLabel.setRenderRequiredIndicator(false);
            }
            if (this.labelLeft) {
                this.fieldLabel.addStyleClass("uif-labelLeft");
            } else {
                this.fieldLabel.addStyleClass("uif-labelBlock");
            }
            this.fieldLabel.addDataAttribute("label_for", this.getId());
            if (StringUtils.isNotBlank((String)this.getFieldLabel().getLabelText())) {
                this.addDataAttribute("label", MessageStructureUtils.translateStringMessage(this.getFieldLabel().getLabelText()));
            }
        }
        if (this.isOmitFromFormPost()) {
            this.addDataAttribute("omit", "true");
        }
    }

    protected void setNestedComponentIdAndSuffix(Component component, String suffix) {
        if (component != null) {
            String fieldId = this.getId();
            fieldId = fieldId + suffix;
            component.setId(fieldId);
        }
    }

    @Override
    public final String getComponentTypeName() {
        return "field";
    }

    @Override
    @BeanTagAttribute
    public String getLabel() {
        if (this.fieldLabel != null) {
            return this.fieldLabel.getLabelText();
        }
        return "";
    }

    @Override
    public void setLabel(String labelText) {
        if (StringUtils.isNotBlank((String)labelText) && this.fieldLabel == null) {
            this.fieldLabel = ComponentFactory.getLabel();
        }
        if (this.fieldLabel != null) {
            this.fieldLabel.setLabelText(labelText);
        }
    }

    @Override
    @BeanTagAttribute
    public List<String> getLabelStyleClasses() {
        if (this.fieldLabel != null) {
            return this.fieldLabel.getCssClasses();
        }
        return null;
    }

    @Override
    public void setLabelStyleClasses(List<String> labelStyleClasses) {
        if (labelStyleClasses != null && this.fieldLabel == null) {
            this.fieldLabel = ComponentFactory.getLabel();
        }
        if (this.fieldLabel != null) {
            this.fieldLabel.setCssClasses(labelStyleClasses);
        }
    }

    @Override
    @BeanTagAttribute
    public int getLabelColSpan() {
        if (this.fieldLabel != null) {
            return this.fieldLabel.getColSpan();
        }
        return 1;
    }

    @Override
    public void setLabelColSpan(int labelColSpan) {
        if (this.fieldLabel == null) {
            this.fieldLabel = ComponentFactory.getLabel();
        }
        if (this.fieldLabel != null) {
            this.fieldLabel.setColSpan(labelColSpan);
        }
    }

    @Override
    @BeanTagAttribute
    public String getShortLabel() {
        return this.shortLabel;
    }

    @Override
    public void setShortLabel(String shortLabel) {
        this.shortLabel = shortLabel;
    }

    public void setShowLabel(boolean showLabel) {
        if (this.fieldLabel != null) {
            this.fieldLabel.setHidden(showLabel);
        }
    }

    @Override
    @BeanTagAttribute
    public Label getFieldLabel() {
        return this.fieldLabel;
    }

    @Override
    public void setFieldLabel(Label fieldLabel) {
        this.fieldLabel = fieldLabel;
    }

    @Override
    @BeanTagAttribute
    public boolean isLabelLeft() {
        return this.labelLeft;
    }

    @Override
    public void setLabelLeft(boolean labelLeft) {
        this.labelLeft = labelLeft;
    }

    @Override
    @BeanTagAttribute
    public boolean isLabelRendered() {
        return this.labelRendered;
    }

    @Override
    public void setLabelRendered(boolean labelRendered) {
        this.labelRendered = labelRendered;
    }

    @Override
    public FieldSecurity getFieldSecurity() {
        return (FieldSecurity)super.getComponentSecurity();
    }

    @Override
    public void setComponentSecurity(ComponentSecurity componentSecurity) {
        if (componentSecurity != null && !(componentSecurity instanceof FieldSecurity)) {
            throw new RiceRuntimeException("Component security for Field should be instance of FieldSecurity");
        }
        super.setComponentSecurity(componentSecurity);
    }

    @Override
    protected void initializeComponentSecurity() {
        if (this.getComponentSecurity() == null) {
            this.setComponentSecurity(KRADUtils.createNewObjectFromClass(FieldSecurity.class));
        }
    }

    @BeanTagAttribute
    public Boolean isEditInLineAuthz() {
        this.initializeComponentSecurity();
        return this.getFieldSecurity().isEditInLineAuthz();
    }

    public void setEditInLineAuthz(Boolean editInLineAuthz) {
        this.initializeComponentSecurity();
        this.getFieldSecurity().setEditInLineAuthz(editInLineAuthz);
    }

    @BeanTagAttribute
    public Boolean isViewInLineAuthz() {
        this.initializeComponentSecurity();
        return this.getFieldSecurity().isViewInLineAuthz();
    }

    public void setViewInLineAuthz(Boolean viewInLineAuthz) {
        this.initializeComponentSecurity();
        this.getFieldSecurity().setViewInLineAuthz(viewInLineAuthz);
    }
}

