/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.freemarker;

import freemarker.core.Environment;
import freemarker.core.InlineTemplateUtils;
import freemarker.core.Macro;
import freemarker.ext.beans.BeansWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.container.CollectionGroup;
import org.kuali.rice.krad.uif.container.Group;
import org.kuali.rice.krad.uif.element.Pager;
import org.kuali.rice.krad.uif.layout.LayoutManager;
import org.kuali.rice.krad.uif.layout.StackedLayoutManager;
import org.kuali.rice.krad.uif.util.ScriptUtils;
import org.kuali.rice.krad.uif.widget.Disclosure;
import org.kuali.rice.krad.uif.widget.Tooltip;
import org.springframework.util.StringUtils;

public class FreeMarkerInlineRenderUtils {
    public static <T> T resolve(Environment env, String name) {
        TemplateModel tm = FreeMarkerInlineRenderUtils.resolveModel(env, name);
        try {
            return (T)FreeMarkerInlineRenderUtils.getBeansWrapper(env).unwrap(tm);
        }
        catch (TemplateModelException e) {
            throw new IllegalArgumentException("Failed to unwrap " + name + ", template model " + tm, e);
        }
    }

    public static <T> T resolve(Environment env, String name, Class<T> type) {
        Object rv = FreeMarkerInlineRenderUtils.resolve(env, name);
        if (rv instanceof Collection && !Collection.class.isAssignableFrom(type)) {
            Collection rc = (Collection)rv;
            if (rc.isEmpty()) {
                return null;
            }
            rv = rc.iterator().next();
        }
        if ("".equals(rv) && !String.class.equals(type)) {
            return null;
        }
        return type.cast(rv);
    }

    public static BeansWrapper getBeansWrapper(Environment env) {
        ObjectWrapper wrapper = env.getObjectWrapper();
        if (!(wrapper instanceof BeansWrapper)) {
            throw new UnsupportedOperationException("FreeMarker environment uses unsupported ObjectWrapper " + wrapper);
        }
        return (BeansWrapper)wrapper;
    }

    public static TemplateModel resolveModel(Environment env, String name) {
        try {
            return env.getVariable(name);
        }
        catch (TemplateModelException e) {
            throw new IllegalArgumentException("Failed to resolve " + name + " in current freemarker environment", e);
        }
    }

    public static void renderTemplate(Environment env, Component component, String body, boolean componentUpdate, boolean includeSrc, Map<String, TemplateModel> tmplParms) throws TemplateException, IOException {
        List<String> refreshWhenChanged;
        String dataJsScripts = "";
        String templateJsScripts = "";
        if (component == null) {
            return;
        }
        Writer out = env.getOut();
        if (component.isRender() && (!component.isRetrieveViaAjax() || componentUpdate) || component.getProgressiveRender() != null && !component.getProgressiveRender().equals("") && !component.isProgressiveRenderViaAJAX() && !component.isProgressiveRenderAndRefresh()) {
            String s = component.getPreRenderContent();
            if (StringUtils.hasText((String)s)) {
                out.write(s);
            }
            if (component.isSelfRendered()) {
                out.write(component.getRenderedHtmlOutput());
            } else {
                Macro fmMacro;
                if (includeSrc) {
                    env.include(component.getTemplate(), env.getTemplate().getEncoding(), true);
                }
                Macro macro = fmMacro = component.getTemplateName() == null ? null : (Macro)env.getMainNamespace().get(component.getTemplateName());
                if (fmMacro == null) {
                    env.include(component.getTemplate(), env.getTemplate().getEncoding(), true);
                    Macro macro2 = fmMacro = component.getTemplateName() == null ? null : (Macro)env.getCurrentNamespace().get(component.getTemplateName());
                    if (fmMacro == null) {
                        throw new TemplateException("No macro found using " + component.getTemplateName(), env);
                    }
                }
                Iterator<String> args = new HashMap<String, Component>();
                args.put(component.getComponentTypeName(), component);
                if (tmplParms != null) {
                    args.putAll(tmplParms);
                }
                if (StringUtils.hasText((String)body)) {
                    args.put("body", body);
                }
                InlineTemplateUtils.invokeMacro(env, fmMacro, args, null);
            }
            s = component.getEventHandlerScript();
            if (StringUtils.hasText((String)s)) {
                templateJsScripts = templateJsScripts + s;
            }
            if (StringUtils.hasText((String)(s = component.getScriptDataAttributesJs()))) {
                dataJsScripts = dataJsScripts + s;
            }
            if (StringUtils.hasText((String)(s = component.getPostRenderContent()))) {
                out.append(s);
            }
        }
        if (componentUpdate || "R".equals(component.getViewStatus())) {
            FreeMarkerInlineRenderUtils.renderScript(dataJsScripts, component, "dataScript", out);
            FreeMarkerInlineRenderUtils.renderScript(templateJsScripts, component, null, out);
            return;
        }
        String methodToCallOnRefresh = component.getMethodToCallOnRefresh();
        if (!StringUtils.hasText((String)methodToCallOnRefresh)) {
            methodToCallOnRefresh = "";
        }
        if (!component.isRender() && (component.isProgressiveRenderViaAJAX() || component.isProgressiveRenderAndRefresh() || component.isDisclosedByAction() || component.isRefreshedByAction()) || component.isRetrieveViaAjax()) {
            out.write("<span id=\"");
            out.write(component.getId());
            out.write("\" data-role=\"placeholder\" class=\"uif-placeholder " + component.getStyleClassesAsString() + "\"></span>");
        }
        if (StringUtils.hasText((String)component.getProgressiveRender())) {
            for (String cName : component.getProgressiveDisclosureControlNames()) {
                templateJsScripts = templateJsScripts + "var condition = function(){return (" + component.getProgressiveDisclosureConditionJs() + ");};setupProgressiveCheck('" + StringEscapeUtils.escapeJavaScript((String)cName) + "', '" + component.getId() + "', condition," + component.isProgressiveRenderAndRefresh() + ", '" + methodToCallOnRefresh + "', " + ScriptUtils.translateValue(component.getFieldsToSendOnRefresh()) + ");";
            }
            templateJsScripts = templateJsScripts + "hiddenInputValidationToggle('" + component.getId() + "');";
        }
        if (StringUtils.hasText((String)component.getConditionalRefresh())) {
            for (String cName : component.getConditionalRefreshControlNames()) {
                templateJsScripts = templateJsScripts + "var condition = function(){return (" + component.getConditionalRefreshConditionJs() + ");};setupRefreshCheck('" + StringEscapeUtils.escapeJavaScript((String)cName) + "', '" + component.getId() + "', condition,'" + methodToCallOnRefresh + "', " + ScriptUtils.translateValue(component.getFieldsToSendOnRefresh()) + ");";
            }
        }
        if ((refreshWhenChanged = component.getRefreshWhenChangedPropertyNames()) != null) {
            for (String cName : refreshWhenChanged) {
                templateJsScripts = templateJsScripts + "setupOnChangeRefresh('" + StringEscapeUtils.escapeJavaScript((String)cName) + "', '" + component.getId() + "','" + methodToCallOnRefresh + "', " + ScriptUtils.translateValue(component.getFieldsToSendOnRefresh()) + ");";
            }
        }
        FreeMarkerInlineRenderUtils.renderScript(dataJsScripts, component, "dataScript", out);
        FreeMarkerInlineRenderUtils.renderScript(templateJsScripts, component, null, out);
        FreeMarkerInlineRenderUtils.renderTooltip(component, out);
    }

    public static void renderTooltip(Component component, Writer out) throws IOException {
        Tooltip tt = component.getToolTip();
        String script = "";
        if (tt != null && StringUtils.hasText((String)tt.getTooltipContent())) {
            String templateOptionsJSString = tt.getTemplateOptionsJSString();
            script = script + "createTooltip('" + component.getId() + "', '" + tt.getTooltipContent() + "', " + (templateOptionsJSString == null ? "''" : templateOptionsJSString) + ", " + tt.isOnMouseHover() + ", " + tt.isOnFocus() + ");";
            FreeMarkerInlineRenderUtils.renderScript(script, component, null, out);
        }
    }

    public static void renderScript(String script, Component component, String role, Writer out) throws IOException {
        if (script == null || "".equals(script.trim())) {
            return;
        }
        out.write("<input name=\"script\" type=\"hidden\" data-role=\"");
        out.write(role == null ? "script" : role);
        out.write("\" ");
        if (component != null && component.getId() != null) {
            out.write("data-for=\"");
            out.write(component.getId());
            out.write("\" ");
        }
        out.write("value=\"");
        out.write(StringEscapeUtils.escapeHtml((String)script));
        out.write("\" />");
    }

    public static void renderAttrBuild(Component component, Writer out) throws IOException {
        String s = component.getStyleClassesAsString();
        if (StringUtils.hasText((String)s)) {
            out.write(" class=\"");
            out.write(s);
            out.write("\"");
        }
        if (StringUtils.hasText((String)(s = component.getStyle()))) {
            out.write(" style=\"");
            out.write(s);
            out.write("\"");
        }
        if (StringUtils.hasText((String)(s = component.getTitle()))) {
            out.write(" title=\"");
            out.write(s);
            out.write("\"");
        }
        if (StringUtils.hasText((String)(s = component.getRole()))) {
            out.write(" role=\"");
            out.write(s);
            out.write("\"");
        }
        if (StringUtils.hasText((String)(s = component.getAriaAttributesAsString()))) {
            out.write(s);
        }
    }

    public static void renderOpenDiv(Component component, Writer out) throws IOException {
        out.write("<div id=\"");
        out.write(component.getId());
        out.write("\"");
        FreeMarkerInlineRenderUtils.renderAttrBuild(component, out);
        out.write(component.getSimpleDataAttributes());
        out.write(">");
    }

    public static void renderCloseDiv(Writer out) throws IOException {
        out.write("</div>");
    }

    public static void renderOpenGroupWrap(Environment env, Group group) throws IOException, TemplateException {
        Writer out = env.getOut();
        FreeMarkerInlineRenderUtils.renderTemplate(env, group.getHeader(), null, false, false, null);
        if (group.isRenderLoading()) {
            out.write("<div id=\"");
            out.write(group.getId());
            out.write("_disclosureContent\" data-role=\"placeholder\"> Loading... </div>");
        } else {
            Disclosure disclosure = group.getDisclosure();
            if (disclosure != null && disclosure.isRender()) {
                out.write("<div id=\"");
                out.write(group.getId() + "_disclosureContent");
                out.write("\" data-role=\"disclosureContent\" data-open=\"");
                out.write(Boolean.toString(disclosure.isDefaultOpen()));
                out.write("\" class=\"uif-disclosureContent\">");
            }
            FreeMarkerInlineRenderUtils.renderTemplate(env, group.getInstructionalMessage(), null, false, false, null);
        }
    }

    public static void renderCloseGroupWrap(Environment env, Group group) throws IOException, TemplateException {
        Disclosure disclosure;
        Writer out = env.getOut();
        boolean renderLoading = group.isRenderLoading();
        if (!renderLoading) {
            FreeMarkerInlineRenderUtils.renderTemplate(env, group.getFooter(), null, false, false, null);
        }
        if ((disclosure = group.getDisclosure()) != null && disclosure.isRender()) {
            if (!renderLoading) {
                out.write("</div>");
            }
            HashMap<String, TemplateModel> tmplParms = new HashMap<String, TemplateModel>();
            tmplParms.put("parent", env.getObjectWrapper().wrap((Object)group));
            FreeMarkerInlineRenderUtils.renderTemplate(env, disclosure, null, false, false, tmplParms);
        }
    }

    public static void renderCollectionGroup(Environment env, CollectionGroup group) throws IOException, TemplateException {
        FreeMarkerInlineRenderUtils.renderOpenGroupWrap(env, group);
        HashMap<String, TemplateModel> tmplParms = new HashMap<String, TemplateModel>();
        tmplParms.put("componentId", env.getObjectWrapper().wrap((Object)group.getId()));
        FreeMarkerInlineRenderUtils.renderTemplate(env, group.getCollectionLookup(), null, false, false, tmplParms);
        if ("TOP".equals(group.getAddLinePlacement())) {
            if (group.isRenderAddBlankLineButton()) {
                FreeMarkerInlineRenderUtils.renderTemplate(env, group.getAddBlankLineAction(), null, false, false, null);
            }
            if (group.isAddWithDialog()) {
                FreeMarkerInlineRenderUtils.renderTemplate(env, group.getAddWithDialogAction(), null, false, false, null);
            }
        }
        LayoutManager layoutManager = group.getLayoutManager();
        String managerTemplateName = layoutManager.getTemplateName();
        List<? extends Component> items = group.getItems();
        if ("uif_stacked".equals(managerTemplateName)) {
            FreeMarkerInlineRenderUtils.renderStacked(env, items, (StackedLayoutManager)layoutManager, group);
        } else {
            Macro fmMacro = (Macro)env.getMainNamespace().get(layoutManager.getTemplateName());
            if (fmMacro == null) {
                throw new TemplateException("No macro found using " + layoutManager.getTemplateName(), env);
            }
            HashMap<String, Object> args = new HashMap<String, Object>();
            args.put("items", items);
            args.put("manager", group.getLayoutManager());
            args.put("container", group);
            InlineTemplateUtils.invokeMacro(env, fmMacro, args, null);
        }
        if ("BOTTOM".equals(group.getAddLinePlacement())) {
            if (group.isRenderAddBlankLineButton()) {
                FreeMarkerInlineRenderUtils.renderTemplate(env, group.getAddBlankLineAction(), null, false, false, null);
            }
            if (group.isAddWithDialog()) {
                FreeMarkerInlineRenderUtils.renderTemplate(env, group.getAddWithDialogAction(), null, false, false, null);
            }
        }
        if (group.isAddWithDialog()) {
            FreeMarkerInlineRenderUtils.renderTemplate(env, group.getAddLineDialog(), null, false, false, null);
        }
        FreeMarkerInlineRenderUtils.renderCloseGroupWrap(env, group);
    }

    public static void renderStacked(Environment env, List<? extends Component> items, StackedLayoutManager manager, CollectionGroup container) throws IOException, TemplateException {
        Group wrapperGroup;
        Writer out = env.getOut();
        Pager pager = manager.getPagerWidget();
        HashMap<String, Object> pagerTmplParms = null;
        if (pager != null && container.isUseServerPaging()) {
            pagerTmplParms = new HashMap<String, TemplateModel>();
            FreeMarkerInlineRenderUtils.renderTemplate(env, pager, null, false, false, pagerTmplParms);
        }
        if ((wrapperGroup = manager.getWrapperGroup()) != null) {
            FreeMarkerInlineRenderUtils.renderTemplate(env, wrapperGroup, null, false, false, null);
        } else {
            for (Group item : manager.getStackedGroups()) {
                FreeMarkerInlineRenderUtils.renderTemplate(env, item, null, false, false, null);
            }
        }
        if (pager != null && container.isUseServerPaging()) {
            pagerTmplParms = new HashMap();
            FreeMarkerInlineRenderUtils.renderTemplate(env, pager, null, false, false, pagerTmplParms);
        }
    }
}

