/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.util;

import java.text.DecimalFormat;
import java.util.Date;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;

public class ProcessLogger {
    private static final Logger LOG = Logger.getLogger(ProcessLogger.class);
    private static final ThreadLocal<Map<String, ProcessStatus>> TL_STAT = new ThreadLocal();
    private static final String[] SIZE_INTERVALS = new String[]{"k", "M", "G", "T", "E"};

    public static String intervalToString(long millis) {
        long days;
        DecimalFormat df = new DecimalFormat("000");
        StringBuilder sb = new StringBuilder();
        sb.append('.');
        sb.append(df.format(millis % 1000L));
        df.applyPattern("00");
        long sec = millis / 1000L;
        sb.insert(0, df.format(sec % 60L));
        long min = sec / 60L;
        sb.insert(0, ':');
        sb.insert(0, df.format(min % 60L));
        long hours = min / 60L;
        if (hours > 0L) {
            sb.insert(0, ':');
            sb.insert(0, df.format(hours % 24L));
        }
        if ((days = hours / 24L) > 0L) {
            sb.insert(0, " days, ");
            sb.insert(0, days);
        }
        return sb.toString();
    }

    public static String sizeToString(long bytes) {
        DecimalFormat df = new DecimalFormat("000");
        StringBuilder sb = new StringBuilder();
        int i = -1;
        int mod = 0;
        if (bytes < 0L) {
            sb.append('-');
            bytes = Math.abs(bytes);
        }
        while (bytes / 1024L > 0L && i < SIZE_INTERVALS.length) {
            ++i;
            mod = (int)(bytes % 1024L);
            bytes /= 1024L;
        }
        sb.append(bytes);
        if (mod > 0) {
            sb.append('.');
            sb.append(df.format(mod * 1000 / 1024));
        }
        if (i >= 0) {
            sb.append(SIZE_INTERVALS[i]);
        }
        return sb.toString();
    }

    public static String memoryToString(long free, long tot, long max) {
        StringBuilder sb = new StringBuilder();
        sb.append(ProcessLogger.sizeToString(free));
        sb.append('/');
        sb.append(ProcessLogger.sizeToString(tot));
        sb.append('/');
        sb.append(ProcessLogger.sizeToString(max));
        sb.append(" - ");
        sb.append(free * 100L / tot);
        sb.append("% free");
        return sb.toString();
    }

    public static <T> T safeFollow(String name, String processDescription, Callable<T> callableProcess) {
        try {
            return ProcessLogger.follow(name, processDescription, null, callableProcess);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new IllegalStateException("Error in followed process " + name + " - " + processDescription, e);
        }
    }

    public static <T> T safeFollow(String name, String processDescription, Boolean verbose, Callable<T> callableProcess) {
        try {
            return ProcessLogger.follow(name, processDescription, verbose, callableProcess);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new IllegalStateException("Error in followed process " + name + " - " + processDescription, e);
        }
    }

    public static <T> T follow(String name, String processDescription, Callable<T> callableProcess) throws Exception {
        return ProcessLogger.follow(name, processDescription, null, callableProcess);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T follow(String name, String processDescription, Boolean verbose, Callable<T> callableProcess) throws Exception {
        if (!LOG.isInfoEnabled()) {
            return callableProcess.call();
        }
        assert (TL_STAT.get() == null || TL_STAT.get().get(name) == null);
        if (TL_STAT.get() == null) {
            TL_STAT.set(new HashMap());
        }
        ProcessStatus processStatus = new ProcessStatus(name);
        if (verbose != null) {
            processStatus.verbose = verbose;
        }
        try {
            TL_STAT.get().put(name, processStatus);
            processStatus.appendTraceHeader(name, processDescription);
            T t = callableProcess.call();
            return t;
        }
        finally {
            if (TL_STAT.get() != null) {
                TL_STAT.get().remove(name);
                if (TL_STAT.get().isEmpty()) {
                    TL_STAT.remove();
                }
            }
            processStatus.elapse();
            processStatus.appendTraceFooter();
            LOG.info((Object)processStatus.traceBuffer.toString());
        }
    }

    public static boolean isTraceActive() {
        return TL_STAT.get() != null && !TL_STAT.get().isEmpty();
    }

    public static boolean isTraceActive(String name) {
        return TL_STAT.get() != null && TL_STAT.get().containsKey(name);
    }

    public static boolean isVerbose(String name) {
        ProcessStatus processStatus = TL_STAT.get() == null ? null : TL_STAT.get().get(name);
        return processStatus != null && processStatus.verbose;
    }

    public static void setVerbose(String name, boolean verbose) {
        ProcessStatus ps;
        ProcessStatus processStatus = ps = TL_STAT.get() == null ? null : TL_STAT.get().get(name);
        if (ps != null) {
            ps.verbose = verbose;
        }
    }

    public static void trace(String message) {
        if (TL_STAT.get() != null) {
            for (String k : TL_STAT.get().keySet()) {
                ProcessLogger.trace(k, message);
            }
        }
    }

    public static void trace(String name, String message) {
        ProcessStatus processStatus;
        ProcessStatus processStatus2 = processStatus = TL_STAT.get() == null ? null : TL_STAT.get().get(name);
        if (processStatus != null) {
            processStatus.elapse();
            processStatus.appendTraceMessage(message);
        }
    }

    public static long ntrace(String prefix, String suffix, long interval) {
        return ProcessLogger.ntrace(prefix, suffix, interval, 0L);
    }

    public static long ntrace(String prefix, String suffix, long interval, long threshold) {
        long rv = 0L;
        if (TL_STAT.get() != null) {
            for (String k : TL_STAT.get().keySet()) {
                rv = Math.max(rv, ProcessLogger.ntrace(k, prefix, suffix, interval, threshold));
            }
        }
        return rv;
    }

    public static long ntrace(String name, String prefix, String suffix, long interval) {
        return ProcessLogger.ntrace(name, prefix, suffix, interval, 0L);
    }

    public static long ntrace(String name, String prefix, String suffix, long interval, long threshold) {
        ProcessStatus processStatus = TL_STAT.get() == null ? null : TL_STAT.get().get(name);
        String nTraceCountKey = prefix + suffix;
        Long nTraceCount = (Long)processStatus.ntraceCount.get(nTraceCountKey);
        if (nTraceCount == null) {
            nTraceCount = 0L;
        }
        nTraceCount = nTraceCount + 1L;
        processStatus.ntraceCount.put(nTraceCountKey, nTraceCount);
        if (threshold > 0L) {
            processStatus.ntraceThreshold.put(nTraceCountKey, threshold);
        }
        if (nTraceCount % interval == 0L) {
            String msg = prefix + nTraceCount + suffix;
            ProcessLogger.trace(msg);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)msg, new Throwable());
            }
        }
        return nTraceCount;
    }

    public static void countBegin(String name) {
        if (TL_STAT.get() != null) {
            for (String k : TL_STAT.get().keySet()) {
                ProcessLogger.countBegin(k, name);
            }
        }
    }

    public static void countBegin(String traceName, String name) {
        ProcessStatus ps;
        ProcessStatus processStatus = ps = TL_STAT.get() == null ? null : TL_STAT.get().get(traceName);
        if (ps != null) {
            ps.countBegin(name);
        }
    }

    public static void countEnd(String name, String detail) {
        if (TL_STAT.get() != null) {
            for (String k : TL_STAT.get().keySet()) {
                ProcessLogger.countEnd(k, name, detail);
            }
        }
    }

    public static void countEnd(String traceName, String name, String detail) {
        ProcessStatus processStatus;
        ProcessStatus processStatus2 = processStatus = TL_STAT.get() == null ? null : TL_STAT.get().get(traceName);
        if (processStatus != null) {
            processStatus.countEnd(name, detail);
        }
    }

    public static void addExtra(String traceName, Object message) {
        ProcessStatus processStatus;
        ProcessStatus processStatus2 = processStatus = TL_STAT.get() == null ? null : TL_STAT.get().get(traceName);
        if (processStatus == null) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Information Message Reported at ");
        sb.append(new Date());
        sb.append(":\n");
        sb.append(message);
        LOG.info((Object)sb.toString());
        processStatus.extra.append((CharSequence)sb);
        processStatus.extra.append("\n\n");
    }

    private static class ProcessStatus {
        private final String name;
        private final long startTime;
        private final long startFree;
        private final long startTot;
        private final long startMax;
        private long lastTime;
        private long lastFree;
        private long lastTot;
        private long lastMax;
        private long diffTime;
        private long diffFree;
        private long diffTot;
        private Map<String, ProcessCounter> counters = new LinkedHashMap<String, ProcessCounter>();
        private Map<String, Long> ntraceCount = new TreeMap<String, Long>();
        private Map<String, Long> ntraceThreshold = new HashMap<String, Long>();
        private boolean verbose = ProcessLogger.access$000().isDebugEnabled();
        private StringBuilder traceBuffer = new StringBuilder();
        private StringBuilder extra = new StringBuilder();

        private ProcessStatus(String name) {
            this.name = name;
            this.startTime = System.currentTimeMillis();
            this.startFree = Runtime.getRuntime().freeMemory();
            this.startTot = Runtime.getRuntime().totalMemory();
            this.startMax = Runtime.getRuntime().maxMemory();
            this.lastTime = this.startTime;
            this.lastFree = this.startFree;
            this.lastTot = this.startTot;
            this.lastMax = this.startMax;
        }

        private void elapse() {
            long nTime = System.currentTimeMillis();
            long nFree = Runtime.getRuntime().freeMemory();
            long nTot = Runtime.getRuntime().totalMemory();
            long nMax = Runtime.getRuntime().maxMemory();
            this.diffTime = nTime - this.lastTime;
            this.diffFree = nFree - this.lastFree;
            this.diffTot = nTot - this.lastTot;
            this.lastTime = nTime;
            this.lastFree = nFree;
            this.lastTot = nTot;
            this.lastMax = nMax;
        }

        private void countBegin(String name) {
            ProcessCounter pc = this.counters.get(name);
            if (pc == null) {
                pc = new ProcessCounter(name);
                this.counters.put(name, pc);
            }
            pc.start.push(new Long(System.currentTimeMillis()));
        }

        private ProcessCounter countEnd(String name, String detail) {
            ProcessCounter pc = this.counters.get(name);
            if (pc == null || pc.start.isEmpty()) {
                return null;
            }
            long start = (Long)pc.start.pop();
            long elapsed = System.currentTimeMillis() - start;
            if (elapsed < pc.min || pc.count == 0L) {
                pc.min = elapsed;
            }
            if (elapsed > pc.max) {
                pc.max = elapsed;
                pc.longest = detail;
            }
            pc.count++;
            pc.avg = (pc.avg * (pc.count - 1L) + elapsed) / pc.count;
            return pc;
        }

        private void appendTraceHeader(String name, String processDescription) {
            int stackTraceIndex;
            this.traceBuffer.append("KRAD Process Trace (");
            this.traceBuffer.append(name);
            this.traceBuffer.append("): ");
            this.traceBuffer.append(processDescription);
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            String callerClassName = stackTrace[3].getClassName();
            int indexOfPeriod = callerClassName.lastIndexOf(46);
            String callerPackageName = "";
            if (indexOfPeriod != -1) {
                callerPackageName = callerClassName.substring(0, indexOfPeriod);
            }
            for (stackTraceIndex = 3; stackTraceIndex < stackTrace.length - 1 && (stackTrace[stackTraceIndex].getClassName().startsWith("sun.") || stackTrace[stackTraceIndex].getClassName().startsWith("java.") || stackTrace[stackTraceIndex].getClassName().startsWith(ProcessLogger.class.getPackage().getName()) || stackTrace[stackTraceIndex].getClassName().startsWith(callerPackageName)); ++stackTraceIndex) {
                if (ProcessLogger.class.getName().equals(stackTrace[stackTraceIndex].getClassName())) continue;
                this.traceBuffer.append("\n  at ").append(stackTrace[stackTraceIndex]);
            }
            this.traceBuffer.append("\n  at ").append(stackTrace[stackTraceIndex]);
            this.traceBuffer.append("\nInitial Memory Usage: ");
            this.traceBuffer.append(ProcessLogger.memoryToString(this.startFree, this.startTot, this.startMax));
            if (LOG.isInfoEnabled() && this.verbose) {
                LOG.debug((Object)("Processing Started\n" + this.traceBuffer.toString()));
            }
        }

        public void appendTraceMessage(String message) {
            if (LOG.isDebugEnabled() && this.verbose) {
                LOG.debug((Object)(message + " (" + this.name + ")\nElapsed Time: " + ProcessLogger.intervalToString(this.diffTime) + "\nMemory Usage: " + ProcessLogger.memoryToString(this.lastFree, this.lastTot, this.lastMax) + "\nMemory Delta: " + ProcessLogger.memoryToString(this.diffFree, this.lastTot, this.lastMax) + " - tot delta: " + ProcessLogger.sizeToString(this.diffTot)));
            }
            if (LOG.isInfoEnabled() && (this.verbose || this.diffTime > 0L)) {
                this.traceBuffer.append('\n');
                if (message.length() < 40) {
                    this.traceBuffer.append(message);
                    for (int i = message.length(); i < 40; ++i) {
                        this.traceBuffer.append('.');
                    }
                } else {
                    this.traceBuffer.append(message.substring(0, 40));
                }
                this.traceBuffer.append(ProcessLogger.intervalToString(this.diffTime));
                this.traceBuffer.append(' ');
                this.traceBuffer.append(ProcessLogger.intervalToString(this.lastTime - this.startTime));
                this.traceBuffer.append(' ');
                this.traceBuffer.append(ProcessLogger.sizeToString(this.lastFree));
                this.traceBuffer.append(' ');
                this.traceBuffer.append(ProcessLogger.sizeToString(this.diffFree));
            }
        }

        public void appendTraceFooter() {
            this.traceBuffer.append('\n');
            String message = "Processing Complete";
            this.traceBuffer.append(message);
            for (int i = message.length(); i < 40; ++i) {
                this.traceBuffer.append('.');
            }
            this.traceBuffer.append(ProcessLogger.intervalToString(this.diffTime));
            this.traceBuffer.append(' ');
            this.traceBuffer.append(ProcessLogger.intervalToString(this.lastTime - this.startTime));
            this.traceBuffer.append(' ');
            this.traceBuffer.append(ProcessLogger.sizeToString(this.lastFree));
            this.traceBuffer.append(' ');
            this.traceBuffer.append(ProcessLogger.sizeToString(this.diffFree));
            if (!this.ntraceCount.isEmpty()) {
                this.traceBuffer.append("\nMonitors:");
                for (Map.Entry<String, Long> ce : this.ntraceCount.entrySet()) {
                    Long threshold = this.ntraceThreshold.get(ce.getKey());
                    if (threshold != null && threshold >= ce.getValue()) continue;
                    this.traceBuffer.append("\n  ");
                    StringBuilder sb = new StringBuilder(ce.getKey());
                    int iocc = sb.indexOf("::");
                    if (iocc == -1) {
                        sb.append(":" + ce.getValue());
                    } else {
                        sb.insert(iocc + 1, ce.getValue());
                    }
                    this.traceBuffer.append((CharSequence)sb);
                }
            }
            if (!this.counters.isEmpty()) {
                this.traceBuffer.append("\nCounters:");
                for (ProcessCounter pc : this.counters.values()) {
                    this.traceBuffer.append("\n  ");
                    this.traceBuffer.append(pc.name);
                    this.traceBuffer.append(": ");
                    this.traceBuffer.append(pc.count);
                    this.traceBuffer.append(" (");
                    this.traceBuffer.append(ProcessLogger.intervalToString(pc.min));
                    this.traceBuffer.append("/");
                    this.traceBuffer.append(ProcessLogger.intervalToString(pc.max));
                    this.traceBuffer.append("/");
                    this.traceBuffer.append(ProcessLogger.intervalToString(pc.avg));
                    this.traceBuffer.append(")");
                    if (pc.longest == null || "".equals(pc.longest)) continue;
                    this.traceBuffer.append("\n    longest : ");
                    this.traceBuffer.append(pc.longest);
                }
            }
            this.traceBuffer.append("\nElapsed Time: ");
            this.traceBuffer.append(ProcessLogger.intervalToString(this.lastTime - this.startTime));
            this.traceBuffer.append("\nMemory Usage: ");
            this.traceBuffer.append(ProcessLogger.memoryToString(this.lastFree, this.lastTot, this.lastMax));
            this.traceBuffer.append("\nMemory Delta: ");
            this.traceBuffer.append(ProcessLogger.memoryToString(this.lastFree - this.startFree, this.lastTot, this.lastMax));
            this.traceBuffer.append(" - tot delta: ");
            this.traceBuffer.append(ProcessLogger.sizeToString(this.lastTot - this.startTot));
        }
    }

    private static class ProcessCounter {
        private final String name;
        private Deque<Long> start = new LinkedList<Long>();
        private long count;
        private long min;
        private long max;
        private long avg;
        private String longest;

        private ProcessCounter(String name) {
            this.name = name;
        }
    }
}

