/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.util;

import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.kuali.rice.core.api.util.type.TypeUtils;
import org.kuali.rice.krad.uif.util.ObjectPropertyUtils;
import org.springframework.util.Assert;

public class ScriptUtils {
    public static String translateValue(Object value) {
        String jsValue = "";
        if (value == null) {
            jsValue = "null";
            return jsValue;
        }
        if (value instanceof List) {
            jsValue = "[";
            List list = (List)value;
            for (Object listItem : list) {
                jsValue = jsValue + ScriptUtils.translateValue(listItem);
                jsValue = jsValue + ",";
            }
            jsValue = StringUtils.removeEnd((String)jsValue, (String)",");
            jsValue = jsValue + "]";
        } else if (value instanceof Set) {
            jsValue = "[";
            Set set = (Set)value;
            for (Object setItem : set) {
                jsValue = jsValue + ScriptUtils.translateValue(setItem);
                jsValue = jsValue + ",";
            }
            jsValue = StringUtils.removeEnd((String)jsValue, (String)",");
            jsValue = jsValue + "]";
        } else if (value instanceof Map) {
            jsValue = "{";
            Map map = (Map)value;
            for (Map.Entry mapEntry : map.entrySet()) {
                jsValue = jsValue + "\"" + mapEntry.getKey().toString() + "\":";
                jsValue = jsValue + ScriptUtils.translateValue(mapEntry.getValue());
                jsValue = jsValue + ",";
            }
            jsValue = StringUtils.removeEnd((String)jsValue, (String)",");
            jsValue = jsValue + "}";
        } else {
            Class<?> valueClass = value.getClass();
            if (TypeUtils.isSimpleType(valueClass) || TypeUtils.isClassClass(valueClass)) {
                boolean quoteValue = true;
                if (TypeUtils.isBooleanClass(valueClass) || TypeUtils.isDecimalClass(valueClass) || TypeUtils.isIntegralClass(valueClass)) {
                    quoteValue = false;
                }
                if (quoteValue) {
                    jsValue = "\"";
                }
                jsValue = jsValue + value.toString();
                if (quoteValue) {
                    jsValue = jsValue + "\"";
                }
            } else {
                jsValue = "{";
                Map<String, PropertyDescriptor> propertyDescriptors = ObjectPropertyUtils.getPropertyDescriptors(valueClass);
                for (String propertyName : propertyDescriptors.keySet()) {
                    if (!ObjectPropertyUtils.isReadableProperty(value, propertyName) || "class".equals(propertyName)) continue;
                    String propertyValue = ObjectPropertyUtils.getPropertyValueAsText(value, propertyName);
                    jsValue = jsValue + propertyName + ":";
                    jsValue = jsValue + ScriptUtils.translateValue(propertyValue);
                    jsValue = jsValue + ",";
                }
                jsValue = StringUtils.removeEnd((String)jsValue, (String)",");
                jsValue = jsValue + "}";
            }
        }
        return jsValue;
    }

    public static String toJSON(Map<String, String> map) {
        StringBuffer sb = new StringBuffer("{");
        for (String key : map.keySet()) {
            String optionValue = map.get(key);
            if (sb.length() > 1) {
                sb.append(",");
            }
            sb.append("\"" + key + "\"");
            sb.append(":");
            sb.append("\"" + ScriptUtils.escapeJSONString(optionValue) + "\"");
        }
        sb.append("}");
        return sb.toString();
    }

    public static String escapeJSONString(String jsonString) {
        if (jsonString != null) {
            jsonString = jsonString.replace("\"", "&quot;");
        }
        return jsonString;
    }

    public static String convertToJsValue(Map<String, String> stringMap) {
        if (stringMap == null || stringMap.isEmpty()) {
            return "{}";
        }
        String convertedValue = "{";
        for (String key : stringMap.keySet()) {
            convertedValue = convertedValue + "\"" + key + "\":" + ScriptUtils.convertToJsValue(stringMap.get(key)) + ",";
        }
        convertedValue = StringUtils.removeEnd((String)convertedValue, (String)",");
        convertedValue = convertedValue + "}";
        return convertedValue;
    }

    public static String convertToJsValue(String value) {
        String originalValue = value;
        if (StringUtils.startsWith((String)(value = StringUtils.strip((String)value)), (String)"{") || StringUtils.startsWith((String)value, (String)"[")) {
            return originalValue;
        }
        if (value.equalsIgnoreCase("false") || value.equalsIgnoreCase("true")) {
            return originalValue.toLowerCase();
        }
        if (StringUtils.startsWith((String)value, (String)"function") && StringUtils.endsWith((String)value, (String)"}")) {
            return originalValue;
        }
        if (NumberUtils.isNumber((String)value)) {
            return originalValue;
        }
        return "\"" + originalValue + "\"";
    }

    public static String escapeName(String name) {
        name = name.replace("'", "\\'");
        return name;
    }

    public static String convertStringListToJsArray(List<String> list) {
        String array = "[";
        if (list != null) {
            for (String s : list) {
                array = array + "'" + s + "',";
            }
            array = StringUtils.removeEnd((String)array, (String)",");
        }
        array = array + "]";
        return array;
    }

    public static String escapeHtml(String string) {
        if (string == null) {
            return null;
        }
        return StringEscapeUtils.escapeHtml((String)string).replace("'", "&apos;").replace("&quot;", "\\u0022");
    }

    public static List<String> escapeHtml(List<String> strings) {
        if (strings == null) {
            return null;
        }
        if (strings.isEmpty()) {
            return strings;
        }
        ArrayList<String> result = new ArrayList<String>(strings.size());
        for (String string : strings) {
            result.add(ScriptUtils.escapeHtml(string));
        }
        return result;
    }

    public static String appendScript(String script, String appendScript) {
        String appendedScript = script;
        if (appendedScript == null) {
            appendedScript = "";
        } else if (StringUtils.isNotBlank((String)appendedScript) && !appendedScript.trim().endsWith(";")) {
            appendedScript = appendedScript + "; ";
        }
        appendedScript = appendedScript + appendScript;
        return appendedScript;
    }

    public static String buildFunctionCall(String functionName, Object ... arguments) {
        StringBuffer sb = new StringBuffer(functionName).append("(");
        if (arguments != null) {
            ArrayList<String> jsArguments = new ArrayList<String>();
            for (Object argument : arguments) {
                jsArguments.add(ScriptUtils.translateValue(argument));
            }
            sb.append(StringUtils.join(jsArguments, (String)","));
        }
        sb.append(");");
        return sb.toString();
    }

    public static String buildEventHandlerScript(String id, String eventName, String eventScript) {
        if (StringUtils.isBlank((String)eventScript)) {
            return "";
        }
        Assert.hasLength((String)id, (String)"Id is required for building event handler script");
        Assert.hasLength((String)eventName, (String)"Event name is required for building event handler script");
        StringBuffer sb = new StringBuffer();
        sb.append("jQuery('#" + id + "').on('");
        sb.append(eventName);
        sb.append("', function(e) {");
        sb.append(eventScript);
        sb.append("}); ");
        return sb.toString();
    }
}

