/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.uif.container;

import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.parse.BeanTags;

/**
 * Special <code>Group</code> that presents a grouping on links, which can
 * also include nested groupings of links
 *
 * <p>
 * Generally this group outputs a list of <code>LinkField</code> instances, however
 * it can be configured to place separates between the fields and also delimiters
 * for the grouping
 * </p>
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
@BeanTags({@BeanTag(name = "linkGroup", parent = "Uif-LinkGroup"),
        @BeanTag(name = "linkSubGroup", parent = "Uif-LinkSubGroup")})
public class LinkGroup extends GroupBase {
    private static final long serialVersionUID = -4173031543626881250L;

    private String groupBeginDelimiter;
    private String groupEndDelimiter;
    private String linkSeparator;
    private String emptyLinkGroupString;

    public LinkGroup() {
        super();
    }

    /**
     * String that will be rendered before the group of links are rendered
     *
     * <p>
     * If the list of links is empty, the start delimiter will not be
     * rendered but instead the #emptyLinkGroupString will be outputted
     * </p>
     *
     * e.g. '['
     *
     * @return group begin delimiter
     */
    @BeanTagAttribute
    public String getGroupBeginDelimiter() {
        return groupBeginDelimiter;
    }

    /**
     * Setter for the group begin delimiter
     *
     * @param groupBeginDelimiter
     */
    public void setGroupBeginDelimiter(String groupBeginDelimiter) {
        this.groupBeginDelimiter = groupBeginDelimiter;
    }

    /**
     * String that will be rendered after the group of links are rendered
     *
     * <p>
     * If the list of links is empty, the end delimiter will not be
     * rendered but instead the #emptyLinkGroupString will be outputted
     * </p>
     *
     * e.g. ']'
     *
     * @return group end delimiter
     */
    @BeanTagAttribute
    public String getGroupEndDelimiter() {
        return groupEndDelimiter;
    }

    /**
     * Setter for the group end delimiter
     *
     * @param groupEndDelimiter
     */
    public void setGroupEndDelimiter(String groupEndDelimiter) {
        this.groupEndDelimiter = groupEndDelimiter;
    }

    /**
     * String that will be rendered between each rendered link
     *
     * e.g. '|'
     *
     * @return link separator
     */
    @BeanTagAttribute
    public String getLinkSeparator() {
        return linkSeparator;
    }

    /**
     * Setter for the link separator
     *
     * @param linkSeparator
     */
    public void setLinkSeparator(String linkSeparator) {
        this.linkSeparator = linkSeparator;
    }

    /**
     * String that will be outputted when the list backing the
     * link group is empty
     *
     * @return empty group string
     */
    @BeanTagAttribute
    public String getEmptyLinkGroupString() {
        return emptyLinkGroupString;
    }

    /**
     * Setter for the empty group string
     *
     * @param emptyLinkGroupString
     */
    public void setEmptyLinkGroupString(String emptyLinkGroupString) {
        this.emptyLinkGroupString = emptyLinkGroupString;
    }

}
