/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.lookup;

import org.kuali.rice.krad.web.form.UifFormBase;
import org.kuali.rice.krad.web.service.impl.CollectionControllerServiceImpl;
import org.springframework.web.servlet.ModelAndView;

/**
 * Override of the default collection controller service to maintain selected line state.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class LookupCollectionControllerServiceImpl extends CollectionControllerServiceImpl {

    /**
     * {@inheritDoc}
     */
    @Override
    public ModelAndView retrieveCollectionPage(UifFormBase form) {
        LookupUtils.refreshLookupResultSelections((LookupForm) form);

        return super.retrieveCollectionPage(form);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ModelAndView tableJsonRetrieval(UifFormBase form) {
        LookupUtils.refreshLookupResultSelections((LookupForm) form);

        return super.tableJsonRetrieval(form);
    }
}
