/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.uif.container;

import java.util.HashSet;
import java.util.Set;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.parse.BeanTags;
import org.kuali.rice.krad.uif.UifConstants;
import org.kuali.rice.krad.uif.component.ClientSideState;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.util.LifecycleElement;
import org.kuali.rice.krad.uif.widget.Tabs;

/**
 * A group that presents its child Groups as tabs.  Items in this group's item list must be Groups
 * themselves.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 * @see Group
 */
@BeanTags({@BeanTag(name = "tabGroup", parent = "Uif-TabGroup"),
        @BeanTag(name = "tabSection", parent = "Uif-TabSection"),
        @BeanTag(name = "tabSubSection", parent = "Uif-TabSubSection")})
public class TabGroup extends GroupBase {
    private static final long serialVersionUID = 3L;

    private Tabs tabsWidget;

    // Required by ClientSideState annotation though not used by class
    @ClientSideState(variableName = "activeTab")
    private String defaultActiveTabId;

    public TabGroup() {
        super();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void performFinalize(Object model, LifecycleElement parent) {
        super.performFinalize(model, parent);
        this.addDataAttribute(UifConstants.DataAttributes.TYPE, "Uif-TabGroup");

        if (StringUtils.isBlank(defaultActiveTabId) && CollectionUtils.isNotEmpty(this.getItems())) {
            defaultActiveTabId = this.getItems().get(0).getId();
        }
    }

    /**
     * Only groups are supported for this group.
     *
     * {@inheritDoc}
     */
    @Override
    public Set<Class<? extends Component>> getSupportedComponents() {
        Set<Class<? extends Component>> supportedComponents = new HashSet<Class<? extends Component>>();
        supportedComponents.add(Group.class);

        return supportedComponents;
    }

    /**
     * Gets the widget which contains any configuration for the tab widget component used to render
     * this TabGroup
     *
     * @return the tabsWidget
     */
    @BeanTagAttribute
    public Tabs getTabsWidget() {
        return this.tabsWidget;
    }

    /**
     * @param tabsWidget the tabsWidget to set
     */
    public void setTabsWidget(Tabs tabsWidget) {
        this.tabsWidget = tabsWidget;
    }

    /**
     * Id of the active tab of the tab group when rendered.
     *
     * @return the default active tab of this tab group
     */
    @BeanTagAttribute
    public String getDefaultActiveTabId() {
        return defaultActiveTabId;
    }

    /**
     * @see org.kuali.rice.krad.uif.container.TabGroup#getDefaultActiveTabId()
     */
    public void setDefaultActiveTabId(String defaultActiveTabId) {
        this.defaultActiveTabId = defaultActiveTabId;
    }
}
