/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.uif.layout;

import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.parse.BeanTags;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.component.ListAware;
import org.kuali.rice.krad.uif.container.Group;
import org.kuali.rice.krad.uif.util.LifecycleElement;

/**
 * List layout manager is a layout manager for group types to output their items as either ordered or
 * unordered lists.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
@BeanTags({@BeanTag(name = "listLayout", parent = "Uif-ListLayout"),
        @BeanTag(name = "orderedListLayout", parent = "Uif-OrderedListLayout")})
public class ListLayoutManager extends LayoutManagerBase {
    private static final long serialVersionUID = -8611267646944565117L;

    private boolean orderedList;

    public ListLayoutManager() {
        super();
    }

    /**
     * Iterates through the groups items and sets the rendered in list boolean.
     *
     * {@inheritDoc}
     */
    @Override
    public void performApplyModel(Object model, LifecycleElement component) {
        super.performApplyModel(model, component);

        Group parentGroup = (Group) component;

        for (Component item : parentGroup.getItems()) {
            if (ListAware.class.isAssignableFrom(item.getClass())) {
                ((ListAware) item).setRenderedInList(true);
            }
        }
    }

    /**
     * If true, this list layout is an ordered list (ol).  Otherwise, the the layout is an unordered list (ul).
     *
     * @return true if orderedList, false if unordered
     */
    @BeanTagAttribute
    public boolean isOrderedList() {
        return orderedList;
    }

    /**
     * Setter for {@link ListLayoutManager#isOrderedList()}.
     * @param orderedList property value
     */
    public void setOrderedList(boolean orderedList) {
        this.orderedList = orderedList;
    }

}
