/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.datadictionary.validation.processor;

import java.util.Collection;
import org.kuali.rice.krad.datadictionary.exception.AttributeValidationException;
import org.kuali.rice.krad.datadictionary.validation.AttributeValueReader;
import org.kuali.rice.krad.datadictionary.validation.ValidationUtils;
import org.kuali.rice.krad.datadictionary.validation.constraint.CollectionSizeConstraint;
import org.kuali.rice.krad.datadictionary.validation.constraint.Constraint;
import org.kuali.rice.krad.datadictionary.validation.processor.CollectionConstraintProcessor;
import org.kuali.rice.krad.datadictionary.validation.result.ConstraintValidationResult;
import org.kuali.rice.krad.datadictionary.validation.result.DictionaryValidationResult;
import org.kuali.rice.krad.datadictionary.validation.result.ProcessorResult;

public class CollectionSizeConstraintProcessor
implements CollectionConstraintProcessor<Collection<?>, CollectionSizeConstraint> {
    private static final String CONSTRAINT_NAME = "collection size constraint";

    @Override
    public ProcessorResult process(DictionaryValidationResult result, Collection<?> collection, CollectionSizeConstraint constraint, AttributeValueReader attributeValueReader) throws AttributeValidationException {
        return new ProcessorResult(this.processSingleCollectionSizeConstraint(result, collection, constraint, attributeValueReader));
    }

    @Override
    public String getName() {
        return CONSTRAINT_NAME;
    }

    @Override
    public Class<? extends Constraint> getConstraintType() {
        return CollectionSizeConstraint.class;
    }

    @Override
    public boolean isOptional() {
        return false;
    }

    protected ConstraintValidationResult processSingleCollectionSizeConstraint(DictionaryValidationResult result, Collection<?> collection, CollectionSizeConstraint constraint, AttributeValueReader attributeValueReader) throws AttributeValidationException {
        String minErrorParameter;
        Integer sizeOfCollection = new Integer(0);
        if (collection != null) {
            sizeOfCollection = collection.size();
        }
        Integer maxOccurances = constraint.getMaximumNumberOfElements();
        Integer minOccurances = constraint.getMinimumNumberOfElements();
        ValidationUtils.Result lessThanMax = ValidationUtils.isLessThanOrEqual(sizeOfCollection, maxOccurances);
        ValidationUtils.Result greaterThanMin = ValidationUtils.isGreaterThanOrEqual(sizeOfCollection, minOccurances);
        if (lessThanMax != ValidationUtils.Result.INVALID && greaterThanMin != ValidationUtils.Result.INVALID) {
            if (lessThanMax == ValidationUtils.Result.UNDEFINED && greaterThanMin == ValidationUtils.Result.UNDEFINED) {
                return result.addNoConstraint(attributeValueReader, CONSTRAINT_NAME);
            }
            return result.addSuccess(attributeValueReader, CONSTRAINT_NAME);
        }
        String maxErrorParameter = maxOccurances != null ? maxOccurances.toString() : null;
        String string = minErrorParameter = minOccurances != null ? minOccurances.toString() : null;
        if (lessThanMax != ValidationUtils.Result.UNDEFINED && greaterThanMin != ValidationUtils.Result.UNDEFINED) {
            return result.addError(attributeValueReader, CONSTRAINT_NAME, "error.quantityRange", minErrorParameter, maxErrorParameter);
        }
        if (lessThanMax == ValidationUtils.Result.INVALID) {
            return result.addError(attributeValueReader, CONSTRAINT_NAME, "error.maxOccurs", maxErrorParameter);
        }
        return result.addError(attributeValueReader, CONSTRAINT_NAME, "error.minOccurs", minErrorParameter);
    }
}

