/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.document;

import java.util.HashSet;
import java.util.Set;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.document.DocumentPresentationController;
import org.kuali.rice.krad.document.DocumentRequestAuthorizationCache;
import org.kuali.rice.krad.uif.view.RequestAuthorizationCache;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.uif.view.ViewModel;
import org.kuali.rice.krad.uif.view.ViewPresentationControllerBase;
import org.kuali.rice.krad.util.KRADUtils;
import org.kuali.rice.krad.web.form.DocumentFormBase;
import org.kuali.rice.krad.web.form.UifFormBase;

public class DocumentViewPresentationControllerBase
extends ViewPresentationControllerBase
implements DocumentPresentationController {
    private static final long serialVersionUID = 1461173145806477758L;
    private DocumentPresentationController documentPresentationController;

    @Override
    public Set<String> getActionFlags(View view, UifFormBase model) {
        HashSet<String> documentActions = new HashSet<String>();
        Document document = ((DocumentFormBase)model).getDocument();
        DocumentRequestAuthorizationCache requestAuthorizationCache = (DocumentRequestAuthorizationCache)this.getRequestAuthorizationCache();
        if (this.canEdit(document)) {
            documentActions.add("canEdit");
        }
        if (this.canAnnotate(document)) {
            documentActions.add("canAnnotate");
        }
        if (this.canClose(document)) {
            documentActions.add("canClose");
        }
        if (this.canSave(document)) {
            documentActions.add("canSave");
        }
        if (this.canRoute(document)) {
            documentActions.add("canRoute");
        }
        if (this.canCancel(document)) {
            documentActions.add("canCancel");
        }
        if (this.canReload(document)) {
            documentActions.add("canReload");
        }
        if (this.canCopy(document)) {
            documentActions.add("canCopy");
        }
        if (this.canPerformRouteReport(document)) {
            documentActions.add("canPerformRouteReport");
        }
        if (this.canAddAdhocRequests(document)) {
            documentActions.add("canAddAdHocRequests");
        }
        if (this.canBlanketApprove(document)) {
            documentActions.add("canBlanketApprove");
        }
        if (this.canApprove(document)) {
            documentActions.add("canApprove");
        }
        if (this.canDisapprove(document)) {
            documentActions.add("canDisapprove");
        }
        if (this.canSendAdhocRequests(document)) {
            documentActions.add("canSendAdHocRequests");
        }
        if (this.canSendNoteFyi(document)) {
            documentActions.add("canSendNoteFyi");
        }
        if (this.canEditDocumentOverview(document)) {
            documentActions.add("canEditDocumentOverview");
        }
        if (this.canFyi(document)) {
            documentActions.add("canFYI");
        }
        if (this.canAcknowledge(document)) {
            documentActions.add("canAcknowledge");
        }
        if (this.canComplete(document)) {
            documentActions.add("canComplete");
        }
        if (this.canRecall(document)) {
            documentActions.add("canRecall");
        }
        if (this.canSuperUserTakeAction(document)) {
            documentActions.add("canSuperUserTakeAction");
        }
        if (this.canSuperUserApprove(document)) {
            documentActions.add("canSuperUserApprove");
        }
        if (this.canSuperUserDisapprove(document)) {
            documentActions.add("canSuperUserDisapprove");
        }
        return documentActions;
    }

    @Override
    public boolean canInitiate(String documentTypeName) {
        return this.getDocumentPresentationController().canInitiate(documentTypeName);
    }

    @Override
    public boolean canEdit(Document document) {
        return this.getDocumentPresentationController().canEdit(document);
    }

    @Override
    public boolean canEditView(View view, ViewModel model) {
        DocumentFormBase documentForm = (DocumentFormBase)model;
        return super.canEditView(view, model) && this.canEdit(documentForm.getDocument());
    }

    @Override
    public boolean canAnnotate(Document document) {
        return this.getDocumentPresentationController().canAnnotate(document);
    }

    @Override
    public boolean canReload(Document document) {
        return this.getDocumentPresentationController().canReload(document);
    }

    @Override
    public boolean canClose(Document document) {
        return this.getDocumentPresentationController().canClose(document);
    }

    @Override
    public boolean canSave(Document document) {
        return this.getDocumentPresentationController().canSave(document);
    }

    @Override
    public boolean canRoute(Document document) {
        return this.getDocumentPresentationController().canRoute(document);
    }

    @Override
    public boolean canCancel(Document document) {
        return this.getDocumentPresentationController().canCancel(document);
    }

    @Override
    public boolean canRecall(Document document) {
        return this.getDocumentPresentationController().canRecall(document);
    }

    @Override
    public boolean canCopy(Document document) {
        return this.getDocumentPresentationController().canCopy(document);
    }

    @Override
    public boolean canPerformRouteReport(Document document) {
        return this.getDocumentPresentationController().canPerformRouteReport(document);
    }

    @Override
    public boolean canAddAdhocRequests(Document document) {
        return this.getDocumentPresentationController().canAddAdhocRequests(document);
    }

    @Override
    public boolean canBlanketApprove(Document document) {
        return this.getDocumentPresentationController().canBlanketApprove(document);
    }

    @Override
    public boolean canApprove(Document document) {
        return this.getDocumentPresentationController().canApprove(document);
    }

    @Override
    public boolean canDisapprove(Document document) {
        return this.getDocumentPresentationController().canDisapprove(document);
    }

    @Override
    public boolean canSendAdhocRequests(Document document) {
        return this.getDocumentPresentationController().canSendAdhocRequests(document);
    }

    @Override
    public boolean canSendNoteFyi(Document document) {
        return this.getDocumentPresentationController().canSendNoteFyi(document);
    }

    @Override
    public boolean canEditDocumentOverview(Document document) {
        return this.getDocumentPresentationController().canEditDocumentOverview(document);
    }

    @Override
    public boolean canFyi(Document document) {
        return this.getDocumentPresentationController().canFyi(document);
    }

    @Override
    public boolean canAcknowledge(Document document) {
        return this.getDocumentPresentationController().canAcknowledge(document);
    }

    @Override
    public boolean canComplete(Document document) {
        return this.getDocumentPresentationController().canComplete(document);
    }

    @Override
    public boolean canSuperUserTakeAction(Document document) {
        return this.getDocumentPresentationController().canSuperUserTakeAction(document);
    }

    @Override
    public boolean canSuperUserApprove(Document document) {
        return this.getDocumentPresentationController().canSuperUserApprove(document);
    }

    @Override
    public boolean canSuperUserDisapprove(Document document) {
        return this.getDocumentPresentationController().canSuperUserDisapprove(document);
    }

    public DocumentPresentationController getDocumentPresentationController() {
        return this.documentPresentationController;
    }

    public void setDocumentPresentationController(DocumentPresentationController documentPresentationController) {
        this.documentPresentationController = documentPresentationController;
    }

    public void setDocumentPresentationControllerClass(Class<? extends DocumentPresentationController> documentPresentationControllerClass) {
        this.documentPresentationController = KRADUtils.createNewObjectFromClass(documentPresentationControllerClass);
    }

    protected DocumentRequestAuthorizationCache getDocumentRequestAuthorizationCache(Document document) {
        DocumentRequestAuthorizationCache documentRequestAuthorizationCache;
        if (this.getRequestAuthorizationCache() == null) {
            this.setRequestAuthorizationCache(new DocumentRequestAuthorizationCache());
        }
        if ((documentRequestAuthorizationCache = (DocumentRequestAuthorizationCache)this.getRequestAuthorizationCache()).getWorkflowDocumentInfo() == null) {
            documentRequestAuthorizationCache.createWorkflowDocumentInfo(document.getDocumentHeader().getWorkflowDocument());
        }
        return documentRequestAuthorizationCache;
    }

    @Override
    public void setDocumentRequestAuthorizationCache(DocumentRequestAuthorizationCache documentRequestAuthorizationCache) {
        this.setRequestAuthorizationCache(documentRequestAuthorizationCache);
    }

    @Override
    public void setRequestAuthorizationCache(RequestAuthorizationCache requestAuthorizationCache) {
        super.setRequestAuthorizationCache(requestAuthorizationCache);
        if (!(requestAuthorizationCache instanceof DocumentRequestAuthorizationCache)) {
            throw new RuntimeException("Request authorization cache should be instance of " + DocumentRequestAuthorizationCache.class.getName());
        }
        this.getDocumentPresentationController().setDocumentRequestAuthorizationCache((DocumentRequestAuthorizationCache)requestAuthorizationCache);
    }
}

