/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.messages.providers;

import java.lang.invoke.CallSite;
import java.util.Collection;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.core.api.search.SearchOperator;
import org.kuali.rice.krad.messages.Message;
import org.kuali.rice.krad.messages.MessageProvider;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.LookupService;

public class DatabaseMessageProvider
implements MessageProvider {
    private LookupService lookupService;

    @Override
    public Message getMessage(String namespace, String component, String key, String locale) {
        Collection<Message> results = this.getMessageByCriteria(namespace, component, key, locale);
        if (results != null && !results.isEmpty()) {
            return results.iterator().next();
        }
        return null;
    }

    @Override
    public Collection<Message> getAllMessagesForComponent(String namespace, String component, String locale) {
        return this.getMessageByCriteria(namespace, component, null, locale);
    }

    protected Collection<Message> getMessageByCriteria(String namespace, String component, String key, String locale) {
        Collection<Message> results = null;
        HashMap<String, String> criteria = new HashMap<String, String>();
        if (StringUtils.isNotBlank((String)namespace)) {
            criteria.put("namespaceCode", namespace);
        }
        if (StringUtils.isNotBlank((String)component)) {
            criteria.put("componentCode", component);
        }
        if (StringUtils.isNotBlank((String)key)) {
            criteria.put("key", key);
        }
        if (StringUtils.isNotBlank((String)locale)) {
            String[] localeIdentifiers = StringUtils.split((String)locale, (String)"-");
            if (localeIdentifiers == null || localeIdentifiers.length != 2) {
                throw new RiceRuntimeException("Invalid locale code: " + (locale == null ? "Null" : locale));
            }
            String localeLanguage = localeIdentifiers[0];
            if (StringUtils.isNotBlank((String)localeLanguage)) {
                criteria.put("locale", locale + SearchOperator.OR.op() + localeLanguage);
            } else {
                criteria.put("locale", locale);
            }
        }
        results = this.getLookupService().findCollectionBySearch(Message.class, criteria);
        HashMap<CallSite, Message> uniqueMessages = new HashMap<CallSite, Message>();
        for (Message message : results) {
            String messageKey = message.getNamespaceCode() + "|" + message.getComponentCode() + "|" + message.getKey();
            if (uniqueMessages.containsKey(messageKey)) {
                Message duplicateMessage = (Message)((Object)uniqueMessages.get(messageKey));
                if (!message.getLocale().equals(locale)) continue;
                uniqueMessages.put((CallSite)((Object)messageKey), message);
                continue;
            }
            uniqueMessages.put((CallSite)((Object)messageKey), message);
        }
        return uniqueMessages.values();
    }

    public LookupService getLookupService() {
        if (this.lookupService == null) {
            this.lookupService = KRADServiceLocatorWeb.getLookupService();
        }
        return this.lookupService;
    }

    public void setLookupService(LookupService lookupService) {
        this.lookupService = lookupService;
    }
}

