/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.component;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.uif.UifDictionaryBeanBase;
import org.kuali.rice.krad.datadictionary.validator.ValidationTrace;
import org.kuali.rice.krad.datadictionary.validator.Validator;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.component.KeepExpression;

@BeanTag(name="propertyReplacer", parent="Uif-ConditionalBeanPropertyReplacer")
public class PropertyReplacer
extends UifDictionaryBeanBase {
    private static final long serialVersionUID = -8405429643299461398L;
    private String propertyName;
    @KeepExpression
    private String condition;
    private Object replacement;

    public List<Component> getNestedComponents() {
        ArrayList<Component> nestedComponents;
        block3: {
            block4: {
                block2: {
                    nestedComponents = new ArrayList<Component>();
                    if (!(this.replacement instanceof Component)) break block2;
                    nestedComponents.add((Component)this.replacement);
                    break block3;
                }
                if (!(this.replacement instanceof List)) break block4;
                for (Object replacementItem : (List)this.replacement) {
                    if (!(replacementItem instanceof Component)) continue;
                    nestedComponents.add((Component)replacementItem);
                }
                break block3;
            }
            if (!(this.replacement instanceof Map)) break block3;
            for (Object replacementItem : ((Map)this.replacement).values()) {
                if (!(replacementItem instanceof Component)) continue;
                nestedComponents.add((Component)replacementItem);
            }
        }
        return nestedComponents;
    }

    @BeanTagAttribute
    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    @BeanTagAttribute
    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    @BeanTagAttribute
    public Object getReplacement() {
        return this.replacement;
    }

    public void setReplacement(Object replacement) {
        this.replacement = replacement;
    }

    public void completeValidation(ValidationTrace tracer) {
        String[] currentValues;
        tracer.addBean("PropertyReplacer", this.getPropertyName());
        if (this.getPropertyName() == null || this.getCondition() == null || this.getReplacement() == null) {
            currentValues = new String[]{"propertyName =" + this.getPropertyName(), "condition =" + this.getCondition(), "replacement =" + String.valueOf(this.getReplacement())};
            tracer.createWarning("PropertyName, condition and replacement should be set", currentValues);
        }
        if (!Validator.validateSpringEL(this.getCondition())) {
            currentValues = new String[]{"condition =" + this.getCondition()};
            tracer.createError("Invalid Spring Expression Language", currentValues);
        }
    }
}

