/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.control;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.uif.control.FilterableLookupCriteriaControl;
import org.kuali.rice.krad.uif.control.FilterableLookupCriteriaControlPostData;
import org.kuali.rice.krad.uif.control.TextControlBase;
import org.kuali.rice.krad.uif.field.InputField;
import org.kuali.rice.krad.uif.util.ComponentFactory;
import org.kuali.rice.krad.uif.util.LifecycleElement;
import org.kuali.rice.krad.uif.widget.QuickFinder;

@BeanTag(name="kimGroupControl", parent="Uif-KimGroupControl")
public class GroupControl
extends TextControlBase
implements FilterableLookupCriteriaControl {
    private static final long serialVersionUID = 5598459655735440981L;
    private String namespaceCodePropertyName;
    private String groupIdPropertyName;

    @Override
    public void performApplyModel(Object model, LifecycleElement parent) {
        super.performApplyModel(model, parent);
        if (!(parent instanceof InputField)) {
            return;
        }
        InputField field = (InputField)parent;
        if (StringUtils.isNotBlank((String)this.groupIdPropertyName)) {
            field.getAdditionalHiddenPropertyNames().add(this.groupIdPropertyName);
        }
        this.buildGroupQuickfinder(model, field);
    }

    protected void buildGroupQuickfinder(Object model, InputField field) {
        QuickFinder quickFinder = field.getQuickfinder();
        if (!field.isEnableAutoQuickfinder()) {
            return;
        }
        if (quickFinder == null) {
            quickFinder = ComponentFactory.getQuickFinder();
            field.setQuickfinder(quickFinder);
        }
        if (field.getQuickfinder() != null) {
            if (StringUtils.isBlank((String)field.getQuickfinder().getDataObjectClassName())) {
                field.getQuickfinder().setDataObjectClassName("org.kuali.rice.kim.impl.group.GroupBo");
            }
            if (field.getQuickfinder().getFieldConversions().isEmpty()) {
                if (StringUtils.isNotBlank((String)this.groupIdPropertyName)) {
                    field.getQuickfinder().getFieldConversions().put("id", this.groupIdPropertyName);
                }
                field.getQuickfinder().getFieldConversions().put("name", field.getPropertyName());
                if (StringUtils.isNotBlank((String)this.namespaceCodePropertyName)) {
                    field.getQuickfinder().getFieldConversions().put("namespaceCode", this.namespaceCodePropertyName);
                }
            }
            if (field.getQuickfinder().getLookupParameters().isEmpty() && StringUtils.isNotBlank((String)this.namespaceCodePropertyName)) {
                field.getQuickfinder().getLookupParameters().put(this.namespaceCodePropertyName, "namespaceCode");
            }
        }
    }

    @Override
    public Map<String, String> filterSearchCriteria(String propertyName, Map<String, String> searchCriteria, FilterableLookupCriteriaControlPostData postData) {
        HashMap<String, String> filteredSearchCriteria = new HashMap<String, String>(searchCriteria);
        GroupControlPostData groupControlPostData = (GroupControlPostData)postData;
        String groupName = searchCriteria.get(propertyName);
        String groupNamespaceCd = searchCriteria.get(groupControlPostData.getNamespaceCodePropertyName());
        if (StringUtils.isNotBlank((String)groupName) && StringUtils.isNotBlank((String)groupNamespaceCd)) {
            Group group = KimApiServiceLocator.getGroupService().getGroupByNamespaceCodeAndName(groupNamespaceCd, groupName);
            if (group == null) {
                return null;
            }
            filteredSearchCriteria.put(groupControlPostData.getGroupIdPropertyName(), group.getId());
        }
        filteredSearchCriteria.remove(propertyName);
        filteredSearchCriteria.remove(groupControlPostData.getNamespaceCodePropertyName());
        return filteredSearchCriteria;
    }

    @BeanTagAttribute
    public String getNamespaceCodePropertyName() {
        return this.namespaceCodePropertyName;
    }

    public void setNamespaceCodePropertyName(String namespaceCodePropertyName) {
        this.namespaceCodePropertyName = namespaceCodePropertyName;
    }

    @BeanTagAttribute
    public String getGroupIdPropertyName() {
        return this.groupIdPropertyName;
    }

    public void setGroupIdPropertyName(String groupIdPropertyName) {
        this.groupIdPropertyName = groupIdPropertyName;
    }

    @Override
    public GroupControlPostData getPostData(String propertyName) {
        return new GroupControlPostData(propertyName, this);
    }

    public static class GroupControlPostData
    implements FilterableLookupCriteriaControlPostData,
    Serializable {
        private static final long serialVersionUID = -1859777965985379673L;
        private String propertyName;
        private String namespaceCodePropertyName;
        private String groupIdPropertyName;

        public GroupControlPostData(String propertyName, GroupControl groupControl) {
            this.propertyName = propertyName;
            this.namespaceCodePropertyName = groupControl.getNamespaceCodePropertyName();
            this.groupIdPropertyName = groupControl.getGroupIdPropertyName();
        }

        @Override
        public Class<? extends FilterableLookupCriteriaControl> getControlClass() {
            return GroupControl.class;
        }

        @Override
        public String getPropertyName() {
            return this.propertyName;
        }

        public String getNamespaceCodePropertyName() {
            return this.namespaceCodePropertyName;
        }

        public String getGroupIdPropertyName() {
            return this.groupIdPropertyName;
        }
    }
}

